/*
 * Decompiled with CFR 0.152.
 */
package com.wittified.services.statuspage;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.google.common.collect.Lists;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.wittified.ao.Notification;
import com.wittified.ao.NotificationService;
import com.wittified.ao.statuspage.ConfigToProject;
import com.wittified.ao.statuspage.ConfigToStatus;
import com.wittified.ao.statuspage.Incident;
import com.wittified.ao.statuspage.IncidentUpdate;
import com.wittified.ao.statuspage.StatusPageConfig;
import com.wittified.services.TokenChangeService;
import com.wittified.services.statuspage.StatusPageService;
import java.text.ParseException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class StatusPageServiceImpl
implements StatusPageService {
    private final Logger logger = LoggerFactory.getLogger(StatusPageServiceImpl.class);
    private final ActiveObjects ao;
    private final NotificationService notificationService;
    private final TokenChangeService tokenChangeService;
    private final PluginSettings settings;
    private final TransactionTemplate transactionTemplate;
    private final PluginLicenseManager licenseStorageManager;

    public StatusPageServiceImpl(ActiveObjects activeObjects, PluginSettingsFactory settingsFactory, NotificationService notificationService, TokenChangeService tokenChangeService, TransactionTemplate transactionTemplate, PluginLicenseManager licenseStorageManager) {
        this.ao = activeObjects;
        this.settings = settingsFactory.createSettingsForKey("com.wittified.atl-announcer:atl-announcer");
        this.notificationService = notificationService;
        this.tokenChangeService = tokenChangeService;
        this.transactionTemplate = transactionTemplate;
        this.licenseStorageManager = licenseStorageManager;
    }

    @Override
    public StatusPageConfig[] getAllStatusPageConfigs() {
        return (StatusPageConfig[])this.ao.find(StatusPageConfig.class, Query.select().order("WEIGHT ASC"));
    }

    @Override
    public Incident[] getAllIncidents() {
        return (Incident[])this.ao.find(Incident.class, Query.select().order("START_DATE DESC"));
    }

    @Override
    public void deleteConfig(HttpServletRequest req) {
        if (req.getParameter("configId") == null) {
            this.logger.error("invalid configuration id");
            return;
        }
        int id = Integer.parseInt(req.getParameter("configId"));
        StatusPageConfig config = (StatusPageConfig)this.ao.get(StatusPageConfig.class, (Object)id);
        if (config != null) {
            ConfigToStatus[] statuses = (ConfigToStatus[])this.ao.find(ConfigToStatus.class, "SP_CONFIG_ID = ?", new Object[]{id});
            this.ao.delete((RawEntity[])statuses);
            ConfigToProject[] projects = (ConfigToProject[])this.ao.find(ConfigToProject.class, "SP_CONFIG_ID = ?", new Object[]{id});
            this.ao.delete((RawEntity[])projects);
            Incident[] incidents = (Incident[])this.ao.find(Incident.class, "SP_CONFIG_ID = ?", new Object[]{id});
            for (int i = 0; i < incidents.length; ++i) {
                Notification notification = incidents[i].getNotification();
                IncidentUpdate[] updates = incidents[i].getUpdates();
                for (int j = 0; j < updates.length; ++j) {
                    this.ao.delete(new RawEntity[]{updates[j]});
                }
                this.ao.delete(new RawEntity[]{incidents[i]});
                if (notification == null) continue;
                this.notificationService.deleteNotification(notification);
            }
            this.ao.delete(new RawEntity[]{config});
        }
    }

    private StatusPageConfig populate(HttpServletRequest req, int id) {
        String[] projects;
        StatusPageConfig config = null;
        config = id > 0 ? (StatusPageConfig)this.ao.get(StatusPageConfig.class, (Object)id) : (StatusPageConfig)this.ao.create(StatusPageConfig.class, new DBParam[0]);
        Boolean active = StringUtils.isNotBlank(req.getParameter("active")) ? Boolean.valueOf(req.getParameter("active").equalsIgnoreCase("on")) : false;
        String name = req.getParameter("name");
        String description = req.getParameter("description");
        String announcementType = req.getParameter("announcementType");
        String notificationType = req.getParameter("notificationType");
        String eol = req.getParameter("eol");
        boolean filterGroups = StringUtils.isNotBlank(req.getParameter("groupsOne"));
        config.setActive(active);
        config.setTitle(name);
        config.setDescription(description);
        config.setAnnouncementType(announcementType);
        config.setNotificationType(Integer.parseInt(notificationType));
        config.setEOL(eol);
        config.setFilterGroups(filterGroups);
        String group = req.getParameter("groups");
        if (group != null && config.getFilterGroups()) {
            config.setGroup(group);
        }
        if ((projects = req.getParameterValues("projects")) != null && projects.length > 0) {
            config.setFilterProjects(true);
            for (String project : projects) {
                ConfigToProject configToProject = (ConfigToProject)this.ao.create(ConfigToProject.class, new DBParam[0]);
                configToProject.setProjectKey(project.split("#", 2)[0]);
                configToProject.setProjectName(project.split("#", 2)[1]);
                configToProject.setStatusPageConfig(config);
                configToProject.save();
            }
        } else {
            config.setFilterProjects(false);
        }
        config.save();
        return config;
    }

    @Override
    public void updateConfig(HttpServletRequest req) {
        int i;
        Incident[] incidents;
        int id = Integer.parseInt(req.getParameter("configId"));
        StatusPageConfig config = this.populate(req, id);
        String page = req.getParameter("status-pages");
        if (!config.getActive()) {
            incidents = (Incident[])this.ao.find(Incident.class, "SP_CONFIG_ID = ?", new Object[]{id});
            for (i = 0; i < incidents.length; ++i) {
                Notification notification = incidents[i].getNotification();
                this.updateStatus(incidents[i].getKey(), false);
                notification.setActive(false);
                if (notification == null) continue;
                this.notificationService.saveNotification(notification);
            }
        } else if (!config.getPage().equalsIgnoreCase(page)) {
            config.setPage(page);
            incidents = (Incident[])this.ao.find(Incident.class, "SP_CONFIG_ID = ?", new Object[]{id});
            for (i = 0; i < incidents.length; ++i) {
                Notification notification = incidents[i].getNotification();
                IncidentUpdate[] updates = incidents[i].getUpdates();
                this.ao.delete((RawEntity[])updates);
                this.ao.delete(new RawEntity[]{incidents[i]});
                if (notification == null) continue;
                this.notificationService.deleteNotification(notification);
            }
        } else {
            incidents = (Incident[])this.ao.find(Incident.class, "SP_CONFIG_ID = ?", new Object[]{id});
            for (i = 0; i < incidents.length; ++i) {
                boolean needsUpdate = false;
                Notification notification = incidents[i].getNotification();
                if (!notification.getType().equalsIgnoreCase(config.getAnnouncementType())) {
                    notification.setType(config.getAnnouncementType());
                    needsUpdate = true;
                }
                if (notification.getDisplay().intValue() != config.getNotificationType()) {
                    notification.setDisplay(config.getNotificationType());
                    needsUpdate = true;
                }
                notification.setGroupTarget(config.getGroup());
                if (config.getFilterProjects()) {
                    notification.setFilterProject(true);
                    List projects = Arrays.asList(config.getProjects()).stream().map(project -> project.getProjectKey()).collect(Collectors.toList());
                    String projectKeys = ":" + StringUtils.join(projects, "::") + ":";
                    notification.setTargetProject(projectKeys);
                }
                if (notification == null || !needsUpdate) continue;
                this.notificationService.saveNotification(notification);
            }
        }
        String[] statuses = req.getParameterValues("statuses");
        ConfigToStatus[] configToStatuses = (ConfigToStatus[])this.ao.find(ConfigToStatus.class, "SP_CONFIG_ID = ?", new Object[]{id});
        this.ao.delete((RawEntity[])configToStatuses);
        for (String status : statuses) {
            ConfigToStatus configToStatus = (ConfigToStatus)this.ao.create(ConfigToStatus.class, new DBParam[0]);
            configToStatus.setStatus(status);
            configToStatus.setStatusPageConfig(config);
            configToStatus.save();
        }
    }

    @Override
    public void createConfig(HttpServletRequest req) {
        String[] statuses;
        StatusPageConfig config = this.populate(req, -1);
        String page = req.getParameter("status-pages");
        config.setPage(page);
        for (String status : statuses = req.getParameterValues("statuses")) {
            ConfigToStatus configToStatus = (ConfigToStatus)this.ao.create(ConfigToStatus.class, new DBParam[0]);
            configToStatus.setStatus(status);
            configToStatus.setStatusPageConfig(config);
            configToStatus.save();
        }
        config.save();
    }

    @Override
    public StatusPageConfig getConfig(HttpServletRequest req) {
        return this.getConfig(req.getParameter("ID"));
    }

    public StatusPageConfig getConfig(String id) {
        StatusPageConfig config = null;
        if (StringUtils.isNotBlank(id)) {
            config = (StatusPageConfig)this.ao.get(StatusPageConfig.class, (Object)Integer.parseInt(id));
        }
        return config;
    }

    @Override
    public void addIncident(JSONObject jsonIncident, StatusPageConfig config, Notification notification) {
        Incident incident = (Incident)this.ao.create(Incident.class, new DBParam[0]);
        try {
            incident.setKey(jsonIncident.getString("id"));
            incident.setTitle(jsonIncident.getString("name"));
            incident.setStatusPageConfig(config);
            incident.setStartDate(Date.from(Instant.parse(jsonIncident.getString("created_at"))));
            incident.setUpdatedDate(Date.from(Instant.parse(jsonIncident.getString("updated_at"))));
            incident.setStatus(true);
            incident.setNotification(notification);
            incident.save();
            JSONArray updates = jsonIncident.getJSONArray("incident_updates");
            for (int i = 0; i < updates.length(); ++i) {
                JSONObject jsonUpdate = updates.getJSONObject(i);
                this.addOrUpdateIncidentUpdate(incident, jsonUpdate);
            }
        }
        catch (JSONException e) {
            this.logger.error("Error while parsing JSON resposne");
        }
        catch (ParseException e) {
            this.logger.error("Error while parsing JSON resposne");
        }
    }

    @Override
    public Incident getIncident(String incidentKey) {
        Incident[] incidents = (Incident[])this.ao.find(Incident.class, "KEY = ?", new Object[]{incidentKey});
        return incidents.length == 1 ? incidents[0] : null;
    }

    public void deleteIncident(Incident incident) {
        this.ao.get(IncidentUpdate.class, (Object[])new Integer[0]);
    }

    private IncidentUpdate getIncidentUpdate(String key) {
        IncidentUpdate[] incidentUpdates = (IncidentUpdate[])this.ao.find(IncidentUpdate.class, "KEY = ?", new Object[]{key});
        return incidentUpdates.length == 1 ? incidentUpdates[0] : null;
    }

    private void addOrUpdateIncidentUpdate(Incident incident1, JSONObject jsonIncidentUpdate) throws JSONException, ParseException {
        IncidentUpdate update = this.getIncidentUpdate(jsonIncidentUpdate.getString("id"));
        Incident incident = this.getIncident(incident1.getKey());
        if (update != null) {
            update.setUpdateDate(Date.from(Instant.parse(jsonIncidentUpdate.getString("updated_at"))));
            update.setMessage(jsonIncidentUpdate.getString("body"));
            update.save();
        } else {
            update = (IncidentUpdate)this.ao.create(IncidentUpdate.class, new DBParam[0]);
            update.setIncident(incident);
            update.setKey(jsonIncidentUpdate.getString("id"));
            update.setStatus(jsonIncidentUpdate.getString("status"));
            update.setMessage(jsonIncidentUpdate.getString("body"));
            update.setUpdateDate(Date.from(Instant.parse(jsonIncidentUpdate.getString("updated_at"))));
            update.save();
        }
    }

    @Override
    public Incident updateIncident(JSONObject jsonIncident, Incident incident) {
        try {
            incident.setUpdatedDate(Date.from(Instant.parse(jsonIncident.getString("updated_at"))));
            incident.setTitle(jsonIncident.getString("name"));
            incident.save();
            JSONArray updates = jsonIncident.getJSONArray("incident_updates");
            for (int i = 0; i < updates.length(); ++i) {
                this.addOrUpdateIncidentUpdate(incident, updates.getJSONObject(i));
            }
        }
        catch (ParseException | JSONException e) {
            this.logger.warn("Parse expection while updating the incident :" + e.getMessage());
        }
        return incident;
    }

    private boolean isIncidentResolved(Incident inc) {
        boolean isResolved = false;
        for (IncidentUpdate update : inc.getUpdates()) {
            if (!update.getStatus().equalsIgnoreCase("resolved")) continue;
            isResolved = true;
            break;
        }
        return isResolved;
    }

    @Override
    public void updateStatus(String incidentKey, boolean status) {
        Incident inc = this.getIncident(incidentKey);
        inc.setStatus(status);
        inc.save();
        Notification notification = inc.getNotification();
        if (notification != null) {
            notification.setActive(status);
            this.notificationService.saveNotification(notification);
        }
    }

    @Override
    public void scanforIncidents() {
        Properties props = (Properties)this.settings.get("com.wittified.atl-announcer:atl-announcer:token-config");
        if (props == null) {
            this.logger.info("Statuspage token is not configured. Not scanning for incidents.");
            return;
        }
        String baseUrl = (String)props.get("baseUrl");
        String apiToken = (String)props.get("apiToken");
        String applicationType = (String)props.get("applicationType");
        String prefix = (String)props.get("announcementPrefix");
        StatusPageConfig[] configs = this.getAllStatusPageConfigs();
        Arrays.sort(configs, Comparator.comparingInt(StatusPageConfig::getWeight));
        for (int i = 0; i < configs.length; ++i) {
            if (!configs[i].getActive()) {
                this.logger.info("config is not active: " + configs[i].getTitle());
                continue;
            }
            String page = configs[i].getPage();
            String eol = configs[i].getEOL();
            List statuses = Arrays.asList(configs[i].getStatuses()).stream().map(status -> status.getStatus().toLowerCase()).collect(Collectors.toList());
            try {
                JSONArray incidents = this.getAllIncidents(baseUrl, apiToken, applicationType, page);
                if (incidents.length() == 0) continue;
                for (int j = 0; j < incidents.length(); ++j) {
                    Notification notification;
                    JSONObject jsonIncident = incidents.getJSONObject(j);
                    if (!statuses.contains(jsonIncident.getString("status"))) {
                        this.logger.info("configuration does not have mapping for this incident status : " + jsonIncident.getString("status") + ", so skipping.");
                        continue;
                    }
                    Incident incident = this.getIncident(jsonIncident.getString("id"));
                    Instant instant = Instant.parse(jsonIncident.getString("updated_at"));
                    if (incident == null) {
                        if (ChronoUnit.MINUTES.between(instant, Instant.now()) > (long)this.parseTime(eol)) continue;
                        notification = this.createAnnouncement(configs[i], incidents.getJSONObject(j), prefix);
                        this.addIncident(incidents.getJSONObject(j), configs[i], notification);
                    } else {
                        instant = Instant.parse(jsonIncident.getString("updated_at"));
                        if (instant.compareTo(incident.getUpdatedDate().toInstant()) > 0) {
                            if (!incident.getStatus()) {
                                if (ChronoUnit.MINUTES.between(incident.getUpdatedDate().toInstant(), Instant.now()) <= (long)this.parseTime(eol)) continue;
                                incident.setStatus(true);
                                incident.getNotification().setActive(true);
                            }
                            incident = this.updateIncident(jsonIncident, incident);
                            notification = incident.getNotification();
                            IncidentUpdate latestUpdate = incident.getUpdates()[0];
                            String content = latestUpdate.getMessage();
                            String statusPage = jsonIncident.getString("shortlink");
                            String status2 = "<br/>Status : <b>" + jsonIncident.getString("status") + "</b><br/>";
                            content = status2.concat(content).concat("<br/><br/><div>" + prefix + " <a href=" + statusPage + ">status page</a><div/><br/>");
                            notification.setHtml(content);
                            notification.setTitle(incident.getTitle());
                            notification.save();
                            this.notificationService.resetNotification(notification);
                        } else if (ChronoUnit.MINUTES.between(incident.getUpdatedDate().toInstant(), Instant.now()) >= (long)this.parseTime(eol) && this.isIncidentResolved(incident)) {
                            Notification staleNotification = incident.getNotification();
                            IncidentUpdate[] updates = incident.getUpdates();
                            this.ao.delete((RawEntity[])updates);
                            this.ao.delete(new RawEntity[]{incident});
                            if (staleNotification != null) {
                                this.notificationService.deleteNotification(staleNotification);
                            }
                        } else if (ChronoUnit.MINUTES.between(incident.getUpdatedDate().toInstant(), Instant.now()) > (long)this.parseTime(eol)) {
                            this.updateStatus(incident.getKey(), false);
                        }
                    }
                    if (!configs[i].getAnnouncementType().equals("login") && !configs[i].getAnnouncementType().equals("intercept")) continue;
                    this.tokenChangeService.updateToken();
                }
                continue;
            }
            catch (JSONException e) {
                this.logger.error("Error while parsing the response");
                return;
            }
            catch (ParseException e) {
                this.logger.error("Error while parsing the response");
                return;
            }
            catch (Exception ex) {
                this.logger.error("Error while parsing the response ", (Throwable)ex);
                return;
            }
        }
    }

    private int parseTime(String eol) {
        int minutes = 0;
        if (eol.contains("d")) {
            minutes = Integer.parseInt(eol.split("d")[0]) * 3600;
        } else if (eol.contains("h")) {
            minutes = Integer.parseInt(eol.split("h")[0]) * 60;
        } else if (eol.contains("m")) {
            minutes = Integer.parseInt(eol.split("m")[0]);
        }
        return minutes;
    }

    private Notification createAnnouncement(StatusPageConfig config, JSONObject incident, String prefix) throws JSONException, ParseException {
        JSONArray updates = incident.getJSONArray("incident_updates");
        JSONObject latestUpdate = updates.getJSONObject(0);
        String name = incident.getString("name");
        String status = null;
        Notification notification = this.notificationService.createNewNotification();
        notification.setDescription("");
        notification.setAnonymous(false);
        notification.setButtonText("");
        notification.setShowButton(true);
        notification.setActive(true);
        notification.setFormat(0);
        notification.setStartDate(new Date());
        notification.setEndDate(new Date());
        String content = latestUpdate.getString("body");
        String statusPage = incident.getString("shortlink");
        status = config.getAnnouncementType().equalsIgnoreCase("dialog") || config.getAnnouncementType().equalsIgnoreCase("intercept") ? "Status: <b>" + incident.getString("status") + "</b><br/>" : "<br/>Status: <b>" + incident.getString("status") + "</b><br/>";
        content = status.concat(content).concat("<br/><br/><div>" + prefix + " <a href=" + statusPage + ">status page</a><div/><br/>");
        notification.setHtml(content);
        notification.setDisplay(config.getNotificationType());
        notification.setFilterGroups(false);
        notification.setFilterProject(false);
        notification.setDateRestrict(false);
        notification.setTitle(name);
        notification.setType(config.getAnnouncementType());
        if (config.getFilterGroups()) {
            notification.setFilterGroups(true);
            String group = config.getGroup();
            notification.setGroupTarget(group);
        }
        if (config.getFilterProjects()) {
            notification.setFilterProject(true);
            List projects = Arrays.asList(config.getProjects()).stream().map(project -> project.getProjectKey()).collect(Collectors.toList());
            String projectKeys = ":" + StringUtils.join(projects, "::") + ":";
            notification.setTargetProject(projectKeys);
        }
        if (notification.getActive()) {
            if (BooleanUtils.isTrue(notification.getDateRestrict())) {
                Date currentDate = new Date();
                notification.setTempActive(currentDate.compareTo(notification.getStartDate()) > -1 && currentDate.compareTo(notification.getEndDate()) < 1);
                this.tokenChangeService.updateToken();
            } else {
                notification.setTempActive(true);
            }
        } else if (notification.getActive()) {
            notification.setTempActive(false);
        }
        this.notificationService.saveNotification(notification);
        return notification;
    }

    private JSONArray getAllIncidents(String baseUrl, String apiToken, String applicationType, String configPage) throws JSONException {
        String fullUrl = baseUrl.concat(configPage + "/incidents.json");
        String responseBody = "BITBUCKET".equals(applicationType) ? this.getJerseyResponse(fullUrl, apiToken) : this.getResponse(fullUrl, apiToken);
        JSONArray incidents = new JSONArray();
        if (responseBody != null) {
            incidents = new JSONArray(responseBody);
        }
        return incidents;
    }

    private void updatePriority(final StatusPageConfig config) {
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Object>(){

            public Object doInTransaction() {
                config.save();
                return null;
            }
        });
    }

    private void reOrder(final StatusPageConfig[] configs) {
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Object>(){

            public Object doInTransaction() {
                int weight = 1;
                for (StatusPageConfig config : configs) {
                    config.setWeight(weight);
                    StatusPageServiceImpl.this.updatePriority(config);
                    ++weight;
                }
                return null;
            }
        });
    }

    @Override
    public List<JSONObject> getPages(String baseUrl, String apiToken, String applicationType) throws JSONException {
        ArrayList<JSONObject> pageList = Lists.newArrayList();
        String responseBody = "BITBUCKET".equals(applicationType) ? this.getJerseyResponse(baseUrl, apiToken) : this.getResponse(baseUrl, apiToken);
        JSONArray pages = null;
        if (responseBody != null) {
            this.logger.debug("responseBody : " + responseBody);
            pages = new JSONArray(responseBody);
            for (int i = 0; i < pages.length(); ++i) {
                pageList.add(pages.getJSONObject(i));
            }
        }
        return pageList;
    }

    private String getResponse(String baseUrl, String apiToken) {
        RestTemplate restTemplate = new RestTemplate();
        HttpHeaders headers = new HttpHeaders();
        headers.add("Authorization", "OAuth " + apiToken);
        HttpEntity request = new HttpEntity((MultiValueMap)headers);
        try {
            ResponseEntity response = restTemplate.exchange(baseUrl, HttpMethod.GET, request, String.class, new Object[0]);
            if (response.getStatusCode() == HttpStatus.UNAUTHORIZED) {
                throw new RuntimeException("Authentication Error");
            }
            return (String)response.getBody();
        }
        catch (RestClientException e) {
            this.logger.error("Error while fetching the response from statuspage.io", (Throwable)e);
            throw e;
        }
    }

    private String getJerseyResponse(String url, String apiToken) {
        Client client = Client.create();
        WebResource webResource = client.resource(url);
        ClientResponse clientResponse = (ClientResponse)((WebResource.Builder)((WebResource.Builder)webResource.header("Authorization", (Object)("OAuth " + apiToken)).type("application/json")).accept(new String[]{"application/json"})).get(ClientResponse.class);
        int statusCode = clientResponse.getStatus();
        if (statusCode == 401) {
            throw new RuntimeException("Authentication Error");
        }
        return (String)clientResponse.getEntity(String.class);
    }

    @Override
    public void move(String movingId, String afterThisId) {
        int i;
        StatusPageConfig[] configs = this.getAllStatusPageConfigs();
        StatusPageConfig afterConfig = null;
        StatusPageConfig thisConfig = this.getConfig(movingId);
        if (afterThisId != null && !afterThisId.isEmpty()) {
            afterConfig = this.getConfig(afterThisId);
        }
        int movingItemIndex = -1;
        int afterThisItemIndex = -1;
        for (i = 0; i < configs.length; ++i) {
            if (String.valueOf(configs[i].getID()).equalsIgnoreCase(movingId)) {
                movingItemIndex = i;
                continue;
            }
            if (afterConfig == null || !String.valueOf(configs[i].getID()).equalsIgnoreCase(afterThisId)) continue;
            afterThisItemIndex = i;
        }
        if (movingItemIndex < afterThisItemIndex) {
            for (i = movingItemIndex; i < afterThisItemIndex; ++i) {
                configs[i] = configs[i + 1];
            }
        } else {
            for (i = movingItemIndex - 1; i >= 0; --i) {
                configs[i + 1] = configs[i];
            }
        }
        if (afterConfig != null) {
            if (afterThisItemIndex == configs.length - 1) {
                configs[afterThisItemIndex] = thisConfig;
            } else {
                configs[afterThisItemIndex + 1] = thisConfig;
            }
        } else {
            configs[0] = thisConfig;
        }
        this.reOrder(configs);
    }

    @Override
    public String getCheckLicense() {
        if (this.licenseStorageManager.getLicense().isDefined()) {
            PluginLicense pluginLicense = (PluginLicense)this.licenseStorageManager.getLicense().get();
            if (pluginLicense.getError().isDefined()) {
                if (((LicenseError)pluginLicense.getError().get()).name().equals("EXPIRED")) {
                    return "The evaluation license has expired. Please contact your System administrator";
                }
                return "An error occurred while validating your license for this plugin: " + ((LicenseError)pluginLicense.getError().get()).name();
            }
            return null;
        }
        return "Plugin is not licensed. In order to evaluate this plugin you need to create an evaluation license";
    }
}

