/*
 * Decompiled with CFR 0.152.
 */
package com.wittified.panels;

import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.ContextProvider;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.wittified.AnnouncerHelper;
import com.wittified.ao.NotificationService;
import com.wittified.cache.NotificationCacheEntry;
import com.wittified.cache.NotificationCacheList;
import com.wittified.licensecounters.LicenseCounter;
import com.wittified.services.TokenChangeService;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FullPageInterceptProvider
implements ContextProvider {
    private final LicenseCounter licenseCounter;
    private final UserManager userManager;
    private final PluginLicenseManager licenseManager;
    private final PluginSettingsFactory pluginSettingsFactory;
    private final NotificationService notificationService;
    private Pattern skipPaths = Pattern.compile("/foo");
    private final TokenChangeService tokenChangeService;
    private static final Logger logger = LoggerFactory.getLogger(FullPageInterceptProvider.class);

    public FullPageInterceptProvider(LicenseCounter licenseCounter, UserManager userManager, PluginSettingsFactory pluginSettingsFactory, PluginLicenseManager licenseManager, TokenChangeService tokenChangeService, NotificationService notificationService) {
        this.licenseCounter = licenseCounter;
        this.userManager = userManager;
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.licenseManager = licenseManager;
        this.tokenChangeService = tokenChangeService;
        this.notificationService = notificationService;
    }

    public void init(Map<String, String> context) throws PluginParseException {
        this.skipPaths = Pattern.compile(this.licenseCounter.getSkippedPaths());
    }

    public static String getUserKey(UserManager userManager) {
        String uKey = "anon";
        if (userManager.getRemoteUserKey() != null) {
            uKey = DigestUtils.sha256Hex((String)userManager.getRemoteUserKey().getStringValue());
        }
        return uKey;
    }

    private boolean isNotificationFound(List<NotificationCacheEntry> notifications, HttpServletRequest httpServletRequest) {
        boolean gotNotification = false;
        UserProfile user = this.userManager.getRemoteUser();
        String uKey = FullPageInterceptProvider.getUserKey(this.userManager);
        logger.debug("Inside isNotificationFound method uKey:" + uKey + ": username:" + (user != null ? user.getUsername() : "anonymous"));
        for (NotificationCacheEntry notification : notifications) {
            if (notification.isNewUser && this.licenseCounter.isNewUser(this.userManager.getRemoteUser())) {
                gotNotification = true;
            }
            if (notification.getFilterGroups() && this.isUserInGroups(notification)) {
                gotNotification = true;
                logger.debug("notification.getFilterGroups() && isUserInGroups(username, notification):" + gotNotification);
            } else if (!notification.getFilterGroups() && !notification.isNewUser) {
                gotNotification = true;
                logger.debug("!notification.getFilterGroups() gotNotification:" + gotNotification);
            }
            logger.debug("notification.getID():" + notification.getID() + " :notification.getID()+\"_\"+uKey:+" + notification.getID() + "_" + uKey);
            for (Cookie cookie : httpServletRequest.getCookies()) {
                logger.debug("Cookie name check (cookie.getName().equalsIgnoreCase):com.wittified.mute_" + notification.getID() + "_" + uKey);
                if (!cookie.getName().equalsIgnoreCase("com.wittified.mute_" + notification.getID() + "_" + uKey)) continue;
                if (Integer.parseInt(cookie.getValue().split("#")[0]) == notification.getID() && Long.parseLong(cookie.getValue().split("#")[1]) <= System.currentTimeMillis()) {
                    gotNotification = true;
                    logger.debug("Inside cookie check setting gotNotification to true:" + gotNotification);
                    continue;
                }
                gotNotification = false;
                logger.debug("Else block executed Inside cookie check setting gotNotification to false:" + gotNotification);
            }
            if (!gotNotification) continue;
            break;
        }
        logger.debug("Returning gotNotification:" + gotNotification);
        return gotNotification;
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        try {
            HttpServletRequest httpServletRequest = this.licenseCounter.getRequestObject();
            HttpServletResponse httpServletResponse = this.licenseCounter.getResponseObject();
            boolean doRedirect = true;
            UserProfile userProfile = this.userManager.getRemoteUser();
            String userName = userProfile != null ? userProfile.getUsername() : "anonymous";
            logger.debug("getContextMap start username:" + userName);
            logger.debug("httpServletRequest.getRequestURI():" + httpServletRequest.getRequestURI());
            Object redirectUrl = "";
            if (httpServletRequest.getParameter("X-ATLASSIAN-MAINTENANCE") != null || httpServletRequest.getRequestURI().endsWith("/wittified/admin/notifications/list") || httpServletRequest.getRequestURI().endsWith("/wittified/approval/notifications") || this.apply(httpServletRequest.getRequestURI()) || httpServletRequest.getRequestURI().contains("/plugins/servlet/ssh") || httpServletRequest.getRequestURI().contains("/plugins/servlet/branchmodel/projects/")) {
                doRedirect = false;
            } else if (httpServletRequest.getRequestURI().endsWith(".png") || httpServletRequest.getRequestURI().endsWith(".jpg") || httpServletRequest.getHeader("X-WITTIFIED-NO-CHECK") != null || httpServletRequest.getRequestURI().endsWith("/plugins/servlet/wittified/announcer/cookieCheck") || httpServletRequest.getRequestURI().endsWith("/wittified/approval/notifications") || httpServletRequest.getRequestURI().startsWith(httpServletRequest.getContextPath() + "/s/") || httpServletRequest.getRequestURI().startsWith(httpServletRequest.getContextPath() + "/images/") || httpServletRequest.getRequestURI().startsWith(httpServletRequest.getContextPath() + "/rest/") || httpServletRequest.getRequestURI().startsWith(httpServletRequest.getContextPath() + "/download/contextbatch") || httpServletRequest.getRequestURI().startsWith(httpServletRequest.getContextPath() + "/download/superbatch") || httpServletRequest.getRequestURI().startsWith(httpServletRequest.getContextPath() + "/download/batch") || httpServletRequest.getRequestURI().startsWith(httpServletRequest.getContextPath() + "/download/resources/") || httpServletRequest.getRequestURI().endsWith("/plugins/servlet/dev-toolbar") || httpServletRequest.getRequestURI().endsWith("/plugins/servlet/ssh") || httpServletRequest.getRequestURI().endsWith("/wittified/admin/notification/user-list") || httpServletRequest.getRequestURI().contains("/wittified/report/notifications") || httpServletRequest.getRequestURI().contains("/wittified/profile/notifications") || httpServletRequest.getRequestURI().contains("/plugins/servlet/desk/portal/1")) {
                doRedirect = false;
            } else {
                String value;
                String userAgent;
                String userAgentRegexp = (String)this.pluginSettingsFactory.createGlobalSettings().get("wittified.announcer.ignored.userAgents");
                if (userAgentRegexp == null || userAgentRegexp.isEmpty()) {
                    userAgentRegexp = "^(Jakarta Commons-HttpClient|Java\\/1\\.\\d+).+";
                }
                if ((userAgent = httpServletRequest.getHeader("user-agent")) != null && !userAgent.isEmpty()) {
                    try {
                        if (userAgent.matches(userAgentRegexp)) {
                            logger.debug(String.format("Applying %s to user agent %s", userAgentRegexp, userAgent));
                            doRedirect = false;
                        }
                    }
                    catch (Exception e) {
                        logger.error(String.format("Error applying %s to user agent %s", userAgentRegexp, userAgent));
                        logger.error("Intercept enabled");
                        e.printStackTrace();
                    }
                }
                if ((value = this.getCookieValue("wit-announce-token", httpServletRequest)) != null) {
                    String currentToken = this.tokenChangeService.getToken();
                    logger.debug("currentToken:" + currentToken);
                    String uKey = "anon";
                    if (this.userManager.getRemoteUserKey() != null) {
                        uKey = DigestUtils.sha256Hex((String)this.userManager.getRemoteUserKey().getStringValue());
                    }
                    logger.debug("Looking for cookie value:" + value);
                    logger.debug(" Found currentToken and uKey (currentToken-uKey):" + currentToken + "-" + uKey);
                    if (currentToken == null) {
                        doRedirect = false;
                    } else {
                        logger.debug("doRedirect: " + doRedirect);
                        Object qString = "";
                        qString = "?" + httpServletRequest.getQueryString();
                        try {
                            String currentUrl = URLEncoder.encode(httpServletRequest.getRequestURI() + (String)qString, "UTF-8");
                            redirectUrl = httpServletRequest.getContextPath() + "/plugins/servlet/wittified/approval/notifications?redirectURL=" + currentUrl;
                            logger.debug("redirectUrl:" + (String)redirectUrl);
                        }
                        catch (UnsupportedEncodingException e) {
                            logger.error("UnsupportedEncodingException:" + e.getMessage());
                            e.printStackTrace();
                        }
                    }
                }
            }
            if (httpServletRequest.getHeader("accept") != null && httpServletRequest.getHeader("accept").contains("image/") && httpServletRequest.getRequestURI().endsWith("/error404")) {
                doRedirect = false;
            }
            if (doRedirect) {
                String uKey = FullPageInterceptProvider.getUserKey(this.userManager);
                NotificationCacheList allNotifications = null;
                List<NotificationCacheEntry> interceptNotifications = null;
                logger.debug("UserProfile user:" + userProfile);
                if (userProfile == null) {
                    String sessionId = AnnouncerHelper.getCookieName(httpServletRequest, httpServletResponse);
                    logger.debug("User is anonymous. AnnouncerHelper.getCookieName sessionId:" + sessionId);
                    if (sessionId != null) {
                        logger.debug("Getting getAllNotificationsForAnonymous:" + sessionId);
                        allNotifications = this.notificationService.getAllNotificationsForAnonymous(sessionId);
                        httpServletRequest.setAttribute("Announcer_Notifications", (Object)allNotifications);
                        interceptNotifications = allNotifications.getEntries("intercept");
                        logger.debug("Getting getAllNotificationsForAnonymous:" + (Serializable)(interceptNotifications != null ? Integer.valueOf(interceptNotifications.size()) : ""));
                    }
                } else {
                    logger.debug("Getting notification for application user:" + userName);
                    allNotifications = this.notificationService.getAllNotificationsForUser(userProfile);
                    httpServletRequest.setAttribute("Announcer_Notifications", (Object)allNotifications);
                    interceptNotifications = allNotifications.getEntries("intercept");
                }
                boolean gotNotification = false;
                if (CollectionUtils.isNotEmpty(interceptNotifications)) {
                    gotNotification = this.isNotificationFound(interceptNotifications, httpServletRequest);
                }
                if (!gotNotification) {
                    logger.debug("No notifications found");
                    String path = httpServletRequest.getContextPath();
                    AnnouncerHelper.setCookie("wit-announce-token", this.tokenChangeService.getToken() + "-" + uKey, 604800, StringUtils.isEmpty(path) ? "/" : path, httpServletRequest, httpServletResponse);
                    doRedirect = false;
                }
            }
            context.put("doRedirect", doRedirect);
            context.put("redirectURL", redirectUrl);
            logger.debug("context value before returning:" + context);
            logger.debug("getContextMap end username:" + userName);
        }
        catch (Exception e) {
            logger.warn("Announcer encountered an error while verifying the user-full page redirect check.", (Throwable)e);
        }
        return context;
    }

    private boolean apply(String path) {
        if (this.skipPaths == null || path == null) {
            return false;
        }
        boolean skippedPaths = this.skipPaths.matcher(path).find();
        if (!skippedPaths) {
            String ignoreUrls = (String)this.pluginSettingsFactory.createGlobalSettings().get("wittified.announcer.ignored.urls");
            boolean ignoreUrlsMatch = false;
            if (StringUtils.isNoneBlank(ignoreUrls)) {
                ignoreUrlsMatch = Arrays.stream(ignoreUrls.split("\\|")).anyMatch(url -> path.contains((CharSequence)url));
                return ignoreUrlsMatch;
            }
        }
        return skippedPaths;
    }

    public boolean getCheckLicense() {
        return true;
    }

    private String getCookieValue(String name, HttpServletRequest request) {
        if (request.getCookies() == null) {
            return "";
        }
        for (Cookie cookie : request.getCookies()) {
            if (!cookie.getName().equals(name)) continue;
            return cookie.getValue();
        }
        return "";
    }

    public boolean isUserInGroup(String group) {
        logger.debug("Looking for " + group);
        if (group == null || group.isEmpty()) {
            return true;
        }
        UserKey userKey = this.userManager.getRemoteUserKey();
        if (userKey == null) {
            logger.debug("user not found - false");
            return false;
        }
        boolean retVal = this.userManager.isUserInGroup(userKey, group);
        logger.debug("Returning " + retVal);
        return retVal;
    }

    public boolean isUserInGroups(NotificationCacheEntry notification) {
        String[] groups = notification.getGroupTarget().split(",");
        boolean found = false;
        for (String group : groups) {
            if (!AnnouncerHelper.isUserInGroup(this.userManager, group)) continue;
            found = true;
            break;
        }
        logger.debug("isUserInGroups found?" + found);
        return found;
    }
}

