/*
 * Decompiled with CFR 0.152.
 */
package com.wittified.servlets;

import com.atlassian.plugins.rest.common.security.LicensedOnly;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.velocity.htmlsafe.HtmlSafe;
import com.wittified.AnnouncerHelper;
import com.wittified.ao.Notification;
import com.wittified.ao.NotificationService;
import com.wittified.ao.NotificationUser;
import com.wittified.format.FormatService;
import com.wittified.licensecounters.LicenseCounter;
import com.wittified.rest.entities.report.UserReport;
import com.wittified.services.ReportService;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LicensedOnly
public class ViewUserServlet
extends HttpServlet {
    private static Logger logger = LoggerFactory.getLogger(ViewUserServlet.class);
    private final TemplateRenderer templateRenderer;
    private final UserManager userManager;
    private final NotificationService notificationService;
    private final LicenseCounter licenseCounter;
    private final FormatService formatService;
    private final ReportService reportService;

    public ViewUserServlet(TemplateRenderer templateRenderer, UserManager userManager, NotificationService notificationService, LicenseCounter licenseCounter, FormatService formatService, ReportService reportService) {
        this.templateRenderer = templateRenderer;
        this.userManager = userManager;
        this.notificationService = notificationService;
        this.licenseCounter = licenseCounter;
        this.formatService = formatService;
        this.reportService = reportService;
    }

    private Map<String, Object> fetchUserDetails(Notification theNotification, String status, int usersPerPage, int page, String searchTerm) {
        Map<Object, Object> usersMap = new WeakHashMap();
        if (theNotification.getFilterGroups() && theNotification.getGroupTarget() != null && !theNotification.getGroupTarget().trim().equals("")) {
            logger.debug("Using filtered groups");
            usersMap = this.reportService.getUsersInGroup(theNotification, searchTerm, status, usersPerPage, page);
        } else {
            logger.debug("Using all groups");
            usersMap = this.reportService.getActiveUsers(theNotification, searchTerm, status, usersPerPage, page);
        }
        return usersMap;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        res.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
        res.setHeader("Expires", "0");
        res.setHeader("Pragma", "no-cache");
        UserProfile username = this.userManager.getRemoteUser();
        Notification notification = this.notificationService.getThisNotification(Integer.parseInt(req.getParameter("notification")));
        boolean block = true;
        if (username != null && AnnouncerHelper.isAdminUser(this.userManager)) {
            block = false;
        } else if (notification.getFilterProject()) {
            String pKey = notification.getTargetProject();
            if (pKey != null) {
                pKey = pKey.replaceAll(":", "");
            }
            if (notification.getTargetProject().contains(pKey) && this.licenseCounter.currentUserCanEdit(pKey)) {
                block = false;
            }
        }
        if (block) {
            res.setHeader("Status", "403");
            return;
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        List<NotificationUser> notificationUsers = Arrays.asList(notification.getNotificationUsers());
        Map<String, Object> usersMap = this.fetchUserDetails(notification, "accepted", 50, 1, "");
        List acceptedUsers = (List)usersMap.get("users");
        Collections.sort(acceptedUsers, Comparator.comparing(UserReport::getAcceptedDate, Comparator.nullsLast(Comparator.reverseOrder())));
        context.put("contextPath", req.getContextPath());
        context.put("acceptedUsersLength", notificationUsers.size());
        context.put("notificationId", notification.getID());
        context.put("users", acceptedUsers.stream().collect(Collectors.toList()));
        String template = "/templates/list-users.vm";
        res.setHeader("Content-Type", "text/plain");
        this.templateRenderer.render(template, context, (Writer)res.getWriter());
    }

    @HtmlSafe
    public String format(Notification notification) {
        return this.formatService.formatThis(notification.getFormat(), AnnouncerHelper.handleVars(this.licenseCounter, notification.getHtml()));
    }
}

