/*
 * Decompiled with CFR 0.152.
 */
package com.wittified.servlets;

import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.wittified.AnnouncerHelper;
import com.wittified.DisplayTypeHolder;
import com.wittified.ao.Notification;
import com.wittified.ao.NotificationService;
import com.wittified.cache.NotificationCacheEntry;
import com.wittified.format.FormatService;
import com.wittified.licensecounters.LicenseCounter;
import com.wittified.panels.FullPageInterceptProvider;
import com.wittified.services.GlobalConfigurationService;
import com.wittified.services.TokenChangeService;
import java.io.IOException;
import java.io.Writer;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationApprovalServlet
extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(NotificationApprovalServlet.class);
    private final TemplateRenderer templateRenderer;
    private final TokenChangeService tokenChangeService;
    private final UserManager userManager;
    private final I18nResolver i18nResolver;
    private final NotificationService notificationService;
    private final FormatService formatService;
    private final GlobalConfigurationService globalConfigurationService;
    private final LicenseCounter licenseCounter;

    public NotificationApprovalServlet(TemplateRenderer templateRenderer, UserManager userManager, NotificationService notificationService, LicenseCounter licenseCounter, I18nResolver i18nResolver, TokenChangeService tokenChangeService, FormatService formatService, GlobalConfigurationService globalConfigurationService) {
        this.templateRenderer = templateRenderer;
        this.userManager = userManager;
        this.notificationService = notificationService;
        this.licenseCounter = licenseCounter;
        this.i18nResolver = i18nResolver;
        this.tokenChangeService = tokenChangeService;
        this.formatService = formatService;
        this.globalConfigurationService = globalConfigurationService;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        List<NotificationCacheEntry> notifications;
        HashMap<String, Object> context = new HashMap<String, Object>();
        WeakHashMap page = new WeakHashMap();
        UserProfile user = this.userManager.getRemoteUser();
        String uKey = FullPageInterceptProvider.getUserKey(this.userManager);
        if (user == null) {
            String sessionId = AnnouncerHelper.getCookieName(req, res);
            if (sessionId == null) {
                context.put("message", "You are currently not logged in. Please log in order to confirm this announcement");
                this.render("/templates/security-breach.vm", context, res);
                return;
            }
            notifications = this.notificationService.getAllNotificationsForAnonymous(sessionId, "intercept").getEntries();
        } else {
            notifications = req.getParameter("type") != null && req.getParameter("type").equals("login") ? this.notificationService.getAllNotificationsForUser(user, "login").getEntries() : this.notificationService.getAllNotificationsForUser(user, "intercept").getEntries();
        }
        boolean gotNotification = false;
        int notificationCounter = -1;
        if (!notifications.isEmpty()) {
            notificationCounter = -1;
            for (NotificationCacheEntry notification : notifications) {
                if (notification.getFilterGroups() && this.isUserInGroups(user, notification)) {
                    gotNotification = true;
                } else if (!notification.getFilterGroups()) {
                    gotNotification = true;
                }
                for (Cookie cookie : req.getCookies()) {
                    if (!cookie.getName().equalsIgnoreCase("com.wittified.mute_" + notification.getID() + "_" + uKey)) continue;
                    gotNotification = Integer.parseInt(cookie.getValue().split("#")[0]) == notification.getID() && Long.parseLong(cookie.getValue().split("#")[1]) <= System.currentTimeMillis();
                }
                ++notificationCounter;
                if (!gotNotification) continue;
                break;
            }
        }
        if (!gotNotification) {
            logger.debug("No notifications found");
            this.redirectUser(req, res, context);
        } else {
            NotificationCacheEntry thisNotification = notifications.get(notificationCounter);
            context.put("isRemindMeLaterEnabled", this.globalConfigurationService.getRemindMeLaterEnabled());
            context.put("remindMeLaterText", this.globalConfigurationService.getRemindMeLaterText());
            context.put("remindMeLaterExplainerText", this.globalConfigurationService.getRemindMeLaterExplainerText().trim().replaceAll("[\n\r]", ""));
            context.put("remindMeLaterTime", this.globalConfigurationService.getRemindMeLaterTime());
            context.put("userKey", uKey);
            context.put("helper", (Object)this);
            context.put("loadTime", System.currentTimeMillis());
            context.put("displayTypeHtml", DisplayTypeHolder.getIconHtml(thisNotification.getDisplayType()));
            context.put("context", req.getContextPath());
            context.put("notification", thisNotification);
            thisNotification.setHtml(this.formatService.formatThis(thisNotification.getFormat(), AnnouncerHelper.handleVars(this.licenseCounter, thisNotification.getHtml())));
            context.put("redirectURL", req.getParameter("redirectURL"));
            if (thisNotification.getButtonText() == null || thisNotification.getButtonText().equals("")) {
                context.put("buttonText", this.i18nResolver.getText("wittified.announcer.fullpage.acknowledge"));
            } else {
                context.put("buttonText", thisNotification.getButtonText());
            }
            context.put("isPreview", false);
            if ("CONFLUENCE".equals(this.licenseCounter.getApplicationType())) {
                context.put("displayHeader", false);
            } else {
                context.put("displayHeader", true);
            }
            context.put("isAdmin", AnnouncerHelper.isAdminUser(this.userManager));
            this.render("/templates/approval/full-page.vm", context, res);
        }
    }

    public boolean isUserInGroups(UserProfile user, NotificationCacheEntry notification) {
        String[] groups = notification.getGroupTarget().split(",");
        boolean found = false;
        for (String group : groups) {
            if (!this.userManager.isUserInGroup(user.getUserKey(), group)) continue;
            found = true;
            break;
        }
        return found;
    }

    public String getCSS(Notification notification) {
        return DisplayTypeHolder.getCss(notification.getDisplay());
    }

    public String getCSS(NotificationCacheEntry notification) {
        return DisplayTypeHolder.getCss(notification.getDisplayType());
    }

    public String format(Notification notification) {
        return this.formatService.formatThis(notification.getFormat(), AnnouncerHelper.handleVars(this.licenseCounter, notification.getHtml()));
    }

    public String format(NotificationCacheEntry notification) {
        return this.formatService.formatThis(notification.getFormat(), AnnouncerHelper.handleVars(this.licenseCounter, notification.getHtml()));
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        block5: {
            int id = Integer.parseInt(req.getParameter("id"));
            long currTime = System.currentTimeMillis();
            long dwellTime = -1L;
            String startTime = req.getParameter("loadTime");
            if (startTime != null) {
                dwellTime = currTime - Long.parseLong(startTime);
            }
            logger.debug("Got ID: " + id);
            UserProfile user = this.userManager.getRemoteUser();
            logger.debug("User:" + user);
            String isAcknowledged = req.getParameter("mute");
            if (isAcknowledged.equalsIgnoreCase("acknowledged")) {
                if (user == null) {
                    logger.debug("anonymous user");
                    String sessionId = AnnouncerHelper.getCookieName(req, res);
                    if (sessionId != null && !sessionId.equals("")) {
                        this.notificationService.confirmNotificationForAnonymous(id, sessionId, dwellTime);
                        break block5;
                    } else {
                        HashMap<String, Object> context = new HashMap<String, Object>();
                        context.put("message", "Session not found.");
                        this.render("/templates/security-breach.vm", context, res);
                        return;
                    }
                }
                logger.debug(" Real user: " + user);
                this.notificationService.confirmNotificationForUser(id, user, dwellTime);
            }
        }
        this.doGet(req, res);
    }

    public boolean isUserInGroup(String group) {
        logger.debug("Looking for " + group);
        if (group == null || group.isEmpty()) {
            return true;
        }
        UserKey userKey = this.userManager.getRemoteUserKey();
        if (userKey == null) {
            logger.debug("user not found - false");
            return false;
        }
        boolean retVal = this.userManager.isUserInGroup(userKey, group);
        logger.debug("Returning " + retVal);
        return retVal;
    }

    private void redirectUser(HttpServletRequest req, HttpServletResponse res, Map<String, Object> context) throws IOException {
        String urlDecode = "";
        String redirectURL = req.getParameter("redirectURL");
        if (StringUtils.isNotEmpty(redirectURL) && redirectURL.startsWith("/") && !redirectURL.startsWith("/\\")) {
            urlDecode = URLEncoder.encode(redirectURL, StandardCharsets.UTF_8);
        }
        Object redirectPath = req.getContextPath();
        redirectPath = !urlDecode.isEmpty() ? (String)redirectPath + "/plugins/servlet/wittified/announcer/cookieCheck?redirectURL=" + urlDecode : (String)redirectPath + "/";
        String uKey = "anon";
        UserProfile userProfile = this.userManager.getRemoteUser();
        if (userProfile != null) {
            uKey = DigestUtils.sha256Hex((String)userProfile.getUsername());
        }
        String path = req.getContextPath();
        AnnouncerHelper.setCookie("wit-announce-token", this.tokenChangeService.getToken() + "-" + uKey, 604800, StringUtils.isEmpty(path) ? "/" : path, req, res);
        logger.debug("Redirecting to verification page");
        context.put("context", req.getContextPath());
        context.put("redirect", redirectPath);
        this.render("/templates/redirect-cookie.vm", context, res);
    }

    protected void render(String template, Map<String, Object> context, HttpServletResponse response) throws IOException {
        response.setContentType("text/html");
        this.templateRenderer.render(template, context, (Writer)response.getWriter());
    }
}

