/*
 * Decompiled with CFR 0.152.
 */
package com.wittified.job;

import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.wittified.ao.Notification;
import com.wittified.ao.NotificationService;
import com.wittified.licensecounters.LicenseCounter;
import com.wittified.services.ReportService;
import java.io.File;
import java.io.FileWriter;
import java.util.Map;
import org.apache.commons.csv.CSVPrinter;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluenceAnnouncerReportJob
implements JobRunner {
    private final Logger logger = LoggerFactory.getLogger(ConfluenceAnnouncerReportJob.class);
    private final ReportService reportService;
    private final NotificationService notificationService;
    private final LicenseCounter licenseCounter;
    private final PluginSettingsFactory pluginSettingsFactory;

    public ConfluenceAnnouncerReportJob(ReportService reportService, NotificationService notificationService, LicenseCounter licenseCounter, PluginSettingsFactory pluginSettingsFactory) {
        this.reportService = reportService;
        this.notificationService = notificationService;
        this.licenseCounter = licenseCounter;
        this.pluginSettingsFactory = pluginSettingsFactory;
    }

    @Nullable
    public JobRunnerResponse runJob(JobRunnerRequest jobRunnerRequest) {
        try {
            this.logger.info("Executing of Report job.... ");
            Map reportParams = (Map)this.pluginSettingsFactory.createGlobalSettings().get("wittified-announcer.reportParams");
            if (reportParams == null) {
                this.logger.error("Tried to run job without an notificationId parameter?!");
                return JobRunnerResponse.failed((String)"Tried to run job without an notificationId parameter?!");
            }
            Integer notificationId = (Integer)reportParams.get("announcerNotifId");
            String toUserEmail = (String)reportParams.get("announcerNotifEmail");
            if (notificationId == null) {
                this.logger.error("Tried to run job without an notificationId parameter?!");
                return JobRunnerResponse.failed((String)"Tried to run job without an notificationId parameter?!");
            }
            Notification theNotification = this.notificationService.getThisNotification(notificationId);
            if (theNotification == null) {
                this.logger.error("The notification with id=" + notificationId + " no longer exists!");
                return JobRunnerResponse.failed((String)("The notification with id=" + notificationId + " no longer exists!"));
            }
            this.notificationService.saveNotificationExportStatus(theNotification, true);
            String exportedFilePath = this.reportService.fetchExportFilePath(theNotification);
            File file = new File(exportedFilePath);
            FileWriter fw = new FileWriter(file);
            CSVPrinter csvFilePrinter = this.reportService.exportCSV(theNotification, fw);
            if (csvFilePrinter != null) {
                csvFilePrinter.flush();
                csvFilePrinter.close();
            }
            this.logger.debug("Announcer - Preparing to send mail");
            this.licenseCounter.sendEmail(theNotification, toUserEmail, exportedFilePath);
            this.notificationService.saveNotificationExportStatus(theNotification, false);
            return JobRunnerResponse.success();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("Email cannot be sent due to this error : " + e);
            return JobRunnerResponse.failed((Throwable)e);
        }
    }
}

