/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.scheduler.compat.local;

import com.atlassian.sal.api.scheduling.PluginJob;
import com.atlassian.scheduler.compat.JobHandler;
import com.atlassian.scheduler.compat.JobInfo;
import com.atlassian.util.concurrent.Assertions;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class LocalOnlyPluginJob
implements PluginJob {
    static final String JOB_INFO = "JobInfo";
    static final String JOB_HANDLER = "JobHandler";

    public void execute(Map<String, Object> jobDataMap) {
        Assertions.notNull("jobDataMap", jobDataMap);
        JobInfo jobInfo = (JobInfo)Assertions.notNull(JOB_INFO, jobDataMap.get(JOB_INFO));
        JobHandler jobHandler = (JobHandler)Assertions.notNull(JOB_HANDLER, jobDataMap.get(JOB_HANDLER));
        jobHandler.execute(jobInfo);
    }

    static Map<String, Object> toJobDataMap(JobInfo jobInfo, JobHandler jobHandler) {
        HashMap<String, Object> jobDataMap = new HashMap<String, Object>(4);
        jobDataMap.put(JOB_INFO, Assertions.notNull(JOB_INFO, jobInfo));
        jobDataMap.put(JOB_HANDLER, Assertions.notNull(JOB_HANDLER, jobHandler));
        return Collections.unmodifiableMap(jobDataMap);
    }
}

