/*
 * Decompiled with CFR 0.152.
 */
package com.wittified.rest;

import com.wittified.AnnouncerHelper;
import com.wittified.ao.Notification;
import com.wittified.ao.NotificationService;
import com.wittified.rest.dto.NotificationDTO;
import java.util.ArrayList;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import net.java.ao.Query;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/dashboard")
public class AnnouncerDashboardEndPoint {
    private static Logger logger = LoggerFactory.getLogger(AnnouncerDashboardEndPoint.class);
    private final NotificationService notificationService;

    @Inject
    public AnnouncerDashboardEndPoint(NotificationService notificationService) {
        this.notificationService = notificationService;
    }

    @Path(value="/notifications/")
    @GET
    @Produces(value={"application/json"})
    public Response getNotifications(@QueryParam(value="limit") String limit, @QueryParam(value="offset") String offset, @QueryParam(value="active") String active, @QueryParam(value="filterProject") String filterProject) {
        if (StringUtils.isAnyBlank(active, limit, offset)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        Query query = AnnouncerHelper.prepareQuery(limit, offset, active, filterProject);
        Notification[] notifications = this.notificationService.getNotifications(query);
        ArrayList<NotificationDTO> notificationList = new ArrayList<NotificationDTO>();
        if (ArrayUtils.isNotEmpty(notifications)) {
            for (Notification notification : notifications) {
                notificationList.add(this.convert(notification));
            }
        }
        return Response.ok(notificationList).build();
    }

    private NotificationDTO convert(Notification notification) {
        NotificationDTO notificationDTO = new NotificationDTO(notification);
        notificationDTO.setTotalUserCount(this.notificationService.getNumUsers(notification));
        if (!notification.getActive()) {
            this.notificationService.getValidationErrors(notificationDTO, notification);
        }
        return notificationDTO;
    }
}

