/*
 * Decompiled with CFR 0.152.
 */
package com.wittified.listeners;

import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.stash.auth.HttpAuthenticationSuccessContext;
import com.atlassian.stash.auth.HttpAuthenticationSuccessHandler;
import com.atlassian.stash.user.StashUser;
import com.wittified.ao.NotificationService;
import com.wittified.cache.NotificationCacheEntry;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationAuthenticationListener
implements HttpAuthenticationSuccessHandler {
    private final Logger logger = LoggerFactory.getLogger(NotificationAuthenticationListener.class);
    private final UserManager userManager;
    private final NotificationService notificationService;

    public NotificationAuthenticationListener(UserManager userManager, NotificationService notificationService) {
        this.notificationService = notificationService;
        this.userManager = userManager;
    }

    public boolean onAuthenticationSuccess(HttpAuthenticationSuccessContext context) {
        StashUser stashUser = context.getUser();
        String username = stashUser.getName();
        UserProfile user = this.userManager.getRemoteUser();
        HttpServletRequest request = context.getRequest();
        HttpServletResponse response = context.getResponse();
        this.logger.debug("Looking at " + username);
        List<NotificationCacheEntry> notifications = this.notificationService.getAllNotificationsForUser(user, "login").getEntries();
        if (!notifications.isEmpty()) {
            this.logger.debug("Got notifications");
            String queryString = "";
            if (request.getQueryString() != null) {
                try {
                    queryString = "&queryString=" + URLEncoder.encode(request.getQueryString(), "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
            try {
                response.sendRedirect(response.encodeRedirectURL(request.getContextPath() + "/plugins/servlet/wittified/approval/notifications?type=login&redirectURL=" + request.getRequestURI() + queryString));
                return true;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.logger.debug("done");
        return false;
    }
}

