/*
 * Decompiled with CFR 0.152.
 */
package com.wittified.bbserver;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.hook.repository.PostRepositoryHook;
import com.atlassian.bitbucket.hook.repository.PostRepositoryHookContext;
import com.atlassian.bitbucket.hook.repository.RepositoryHookRequest;
import com.atlassian.bitbucket.hook.repository.SynchronousPreferred;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.sal.api.user.UserManager;
import com.wittified.ao.NotificationService;
import com.wittified.cache.NotificationCacheEntry;
import java.util.ArrayList;

@SynchronousPreferred(asyncSupported=false)
public class EnhancePullRequest
implements PostRepositoryHook {
    private final NotificationService notificationService;
    private final AuthenticationContext authenticationContext;
    private final NavBuilder navBuilder;
    private final UserManager userManager;

    public EnhancePullRequest(NotificationService notificationService, AuthenticationContext authenticationContext, NavBuilder navBuilder, UserManager userManager) {
        this.notificationService = notificationService;
        this.authenticationContext = authenticationContext;
        this.navBuilder = navBuilder;
        this.userManager = userManager;
    }

    public void postUpdate(PostRepositoryHookContext postRepositoryHookContext, RepositoryHookRequest repositoryHookRequest) {
        ArrayList<NotificationCacheEntry> notificationList = new ArrayList<NotificationCacheEntry>();
        String targetProject = ":" + repositoryHookRequest.getRepository().getProject().getKey() + ":";
        if (!this.authenticationContext.isAuthenticated()) {
            for (NotificationCacheEntry notification : this.notificationService.getAllNotificationsForAnonymous("pull-request-anon").getEntries()) {
                if (notification.getFilterProject()) {
                    if (!notification.getTargetProject().contains(targetProject)) continue;
                    notificationList.add(notification);
                    continue;
                }
                notificationList.add(notification);
            }
        } else {
            for (NotificationCacheEntry notification : this.notificationService.getAllNotificationsForUser(this.userManager.getRemoteUser()).getEntries()) {
                if (notification.getFilterProject()) {
                    if (!notification.getTargetProject().contains(targetProject)) continue;
                    notificationList.add(notification);
                    continue;
                }
                notificationList.add(notification);
            }
        }
        if (notificationList.isEmpty()) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (notificationList.size() > 1) {
            stringBuffer.append("There are announcements for you to review. ");
        } else {
            stringBuffer.append("There is an announcement for you to review. ");
        }
        stringBuffer.append("Please visit " + this.navBuilder.repo(repositoryHookRequest.getRepository()).browse().buildAbsolute());
        for (NotificationCacheEntry notification : notificationList) {
            stringBuffer.append("\n\r");
            stringBuffer.append(notification.getTitle());
        }
        stringBuffer.append("\n\r");
        stringBuffer.append("\n\r");
        repositoryHookRequest.getScmHookDetails().ifPresent(scmDetails -> scmDetails.out().println(stringBuffer.toString()));
    }
}

