/*
 * Decompiled with CFR 0.152.
 */
package com.wittified.stash;

import com.atlassian.sal.api.user.UserManager;
import com.atlassian.stash.hook.HookResponse;
import com.atlassian.stash.hook.PostReceiveHook;
import com.atlassian.stash.nav.NavBuilder;
import com.atlassian.stash.repository.RefChange;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.user.StashAuthenticationContext;
import com.wittified.ao.NotificationService;
import com.wittified.cache.NotificationCacheEntry;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nonnull;

public class EnhancePullRequest
implements PostReceiveHook {
    private final NotificationService notificationService;
    private final StashAuthenticationContext stashAuthenticationContext;
    private final NavBuilder navBuilder;
    private final UserManager userManager;

    public EnhancePullRequest(NotificationService notificationService, StashAuthenticationContext stashAuthenticationContext, NavBuilder navBuilder, UserManager userManager) {
        this.notificationService = notificationService;
        this.stashAuthenticationContext = stashAuthenticationContext;
        this.navBuilder = navBuilder;
        this.userManager = userManager;
    }

    public void onReceive(@Nonnull Repository repository, @Nonnull Collection<RefChange> refChanges, @Nonnull HookResponse hookResponse) {
        ArrayList<NotificationCacheEntry> notificationList = new ArrayList<NotificationCacheEntry>();
        String targetProject = ":" + repository.getProject().getKey() + ":";
        if (!this.stashAuthenticationContext.isAuthenticated()) {
            for (NotificationCacheEntry notification : this.notificationService.getAllNotificationsForAnonymous("pull-request-anon").getEntries()) {
                if (notification.getFilterProject()) {
                    if (!notification.getTargetProject().contains(targetProject)) continue;
                    notificationList.add(notification);
                    continue;
                }
                notificationList.add(notification);
            }
        } else {
            for (NotificationCacheEntry notification : this.notificationService.getAllNotificationsForUser(this.userManager.getRemoteUser()).getEntries()) {
                if (notification.getFilterProject()) {
                    if (!notification.getTargetProject().contains(targetProject)) continue;
                    notificationList.add(notification);
                    continue;
                }
                notificationList.add(notification);
            }
        }
        if (notificationList.isEmpty()) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("There are Announcement for you to review. Please visit " + this.navBuilder.repo(repository).browse().buildAbsolute());
        for (NotificationCacheEntry notification : notificationList) {
            stringBuffer.append("\n\r");
            stringBuffer.append(notification.getTitle());
        }
        stringBuffer.append("\n\r");
        stringBuffer.append("\n\r");
        hookResponse.out().write(stringBuffer.toString());
    }
}

