/*
 * Decompiled with CFR 0.152.
 */
package com.wittified.servlets;

import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.sal.api.websudo.WebSudoSessionException;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.wittified.AnnouncerHelper;
import com.wittified.DisplayTypeHolder;
import com.wittified.RecurrenceType;
import com.wittified.ao.Notification;
import com.wittified.ao.NotificationService;
import com.wittified.format.FormatService;
import com.wittified.job.RecurringAnnouncementScheduler;
import com.wittified.licensecounters.LicenseCounter;
import com.wittified.services.TokenChangeService;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationAdminCreateServlet
extends HttpServlet {
    private static Logger logger = LoggerFactory.getLogger(NotificationAdminCreateServlet.class);
    private final TemplateRenderer templateRenderer;
    private final UserManager userManager;
    private final NotificationService notificationService;
    private final PluginLicenseManager licenseStorageManager;
    private final TokenChangeService tokenChangeService;
    private final LicenseCounter licenseCounter;
    private final WebSudoManager webSudoManager;
    private final PluginSettingsFactory pluginSettingsFactory;
    private final FormatService formatService;
    private final RecurringAnnouncementScheduler recurringAnnouncementScheduler;
    private static final String WEEK_DAY_CRON_DELIMITER = ",";

    public NotificationAdminCreateServlet(TemplateRenderer templateRenderer, UserManager userManager, NotificationService notificationService, PluginLicenseManager licenseStorageManager, LicenseCounter licenseCounter, TokenChangeService tokenChangeService, WebSudoManager webSudoManager, PluginSettingsFactory pluginSettingsFactory, FormatService formatService, RecurringAnnouncementScheduler recurringAnnouncementScheduler) {
        this.templateRenderer = templateRenderer;
        this.userManager = userManager;
        this.notificationService = notificationService;
        this.licenseStorageManager = licenseStorageManager;
        this.licenseCounter = licenseCounter;
        this.tokenChangeService = tokenChangeService;
        this.webSudoManager = webSudoManager;
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.formatService = formatService;
        this.recurringAnnouncementScheduler = recurringAnnouncementScheduler;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        res.setContentType("text/html");
        UserProfile userProfile = this.userManager.getRemoteUser();
        String username = userProfile.getUsername();
        String thisProjectOnly = req.getParameter("project");
        boolean shouldFilterProject = thisProjectOnly != null;
        String enabledProjectConfig = (String)this.pluginSettingsFactory.createGlobalSettings().get("wittified.announcer.projects");
        if (enabledProjectConfig == null) {
            enabledProjectConfig = "false";
        }
        if ((enabledProjectConfig = enabledProjectConfig.toLowerCase()).equals("false") && !shouldFilterProject) {
            try {
                this.webSudoManager.willExecuteWebSudoRequest(req);
            }
            catch (WebSudoSessionException wes) {
                this.webSudoManager.enforceWebSudoProtection(req, res);
            }
        }
        if (username != null && (AnnouncerHelper.isAdminUser(this.userManager) || thisProjectOnly != null && this.licenseCounter.currentUserCanEdit(thisProjectOnly))) {
            String title = "";
            String contents = "<!-- insert your html here -->";
            String id = req.getParameter("id");
            String description = "";
            String type = "intercept";
            String buttonText = "";
            int format = 0;
            String group = null;
            boolean allowAnonymous = false;
            boolean isActive = true;
            boolean filterProject = false;
            boolean filterProjectRole = false;
            boolean filterGroups = false;
            boolean delayButton = false;
            boolean restrictByDate = false;
            boolean resetButton = false;
            boolean filterCategory = false;
            boolean filterUser = false;
            boolean isNewUser = false;
            boolean isCustomRecurrence = false;
            boolean isRunningType = false;
            boolean isRecurringType = false;
            boolean runIndefinitely = false;
            int runningFreq = 1;
            String runningType = "days";
            String recurringType = "weekly";
            int recurringDay = 1;
            long endTime = 0L;
            long startTime = 0L;
            String weeklyStartTime = "";
            String weeklyEndTime = "";
            boolean isRecurringWeeklyType = false;
            String selectedDays = "";
            String targetProject = "";
            String targetCategories = "";
            String targetProjectRole = "";
            String targetUser = "";
            boolean showButton = true;
            int displayType = 0;
            if (thisProjectOnly != null) {
                targetProject = thisProjectOnly;
                type = "dialog";
            }
            if (!id.equals("-1")) {
                Notification notification = this.notificationService.getThisNotification(Integer.parseInt(id));
                title = notification.getTitle();
                contents = notification.getHtml();
                description = notification.getDescription();
                type = notification.getType();
                allowAnonymous = notification.getAnonymous();
                isActive = notification.getActive();
                buttonText = notification.getButtonText();
                filterProject = notification.getFilterProject();
                filterGroups = notification.getFilterGroups();
                targetProject = thisProjectOnly != null ? thisProjectOnly : notification.getTargetProject();
                filterUser = notification.getFilterUser();
                targetUser = notification.getTargetUser();
                if ("CONFLUENCE".equals(this.licenseCounter.getApplicationType()) || "JIRA".equals(this.licenseCounter.getApplicationType())) {
                    filterCategory = notification.getFilterCategory();
                    targetCategories = notification.getTargetCategories();
                }
                if ("JIRA".equals(this.licenseCounter.getApplicationType())) {
                    filterProjectRole = notification.getFilterProjectRole();
                    targetProjectRole = notification.getTargetProjectRole();
                }
                if ("CONFLUENCE".equals(this.licenseCounter.getApplicationType()) || "JIRA".equals(this.licenseCounter.getApplicationType())) {
                    isNewUser = notification.getNewUserOption();
                }
                if (notification.getEndDate() != null) {
                    if (Long.valueOf("253402108200000").equals(notification.getEndDate().getTime())) {
                        runIndefinitely = true;
                    } else {
                        endTime = notification.getEndDate().getTime();
                    }
                }
                if (notification.getStartDate() != null) {
                    startTime = notification.getStartDate().getTime();
                }
                if (notification.getDateRestrict() != null) {
                    restrictByDate = notification.getDateRestrict();
                }
                if (notification.getWeeklyEndTime() != null) {
                    weeklyEndTime = notification.getWeeklyEndTime();
                }
                if (notification.getWeeklyStartTime() != null) {
                    weeklyStartTime = notification.getWeeklyStartTime();
                }
                if (notification.getRecurringWeeklyType() != null) {
                    isRecurringWeeklyType = notification.getRecurringWeeklyType();
                }
                if (StringUtils.isNotBlank(notification.getSelectedDays())) {
                    selectedDays = notification.getSelectedDays();
                }
                if (notification.getFormat() > -1) {
                    format = notification.getFormat();
                }
                group = notification.getGroupTarget();
                delayButton = notification.getDelayButton();
                resetButton = notification.getResetButton();
                if (thisProjectOnly != null) {
                    boolean block = true;
                    String project = notification.getTargetProject();
                    if (notification.getFilterProject() && project != null && (project = project.replaceAll(":", "")).equalsIgnoreCase(thisProjectOnly)) {
                        block = false;
                    }
                    if (block) {
                        HashMap<String, Object> context = new HashMap<String, Object>();
                        context.put("message", "The user that you're currently logged in as is not an administrator. This page is limited to administrator access.");
                        res.setContentType("text/html");
                        this.render("/templates/security-breach.vm", context, res);
                        return;
                    }
                }
                if (notification.getDisplay() != null) {
                    displayType = notification.getDisplay();
                }
                if (notification.getShowButton() != null) {
                    showButton = notification.getShowButton();
                }
                isCustomRecurrence = notification.getCustomRecurrenceOption();
                isRunningType = notification.getRunningTypeOption();
                isRecurringType = notification.getRecurringTypeOption();
                runningFreq = notification.getRunningFreq();
                if (StringUtils.isNoneBlank(notification.getRunningType())) {
                    runningType = notification.getRunningType();
                }
                if (StringUtils.isNoneBlank(notification.getRecurringType())) {
                    recurringType = notification.getRecurringType();
                    if (recurringType.equals("weekly")) {
                        recurringDay = notification.getDayOfWeek();
                    } else if (recurringType.equals("monthly")) {
                        recurringDay = notification.getDayOfMonth();
                    }
                }
            }
            if (group == null) {
                group = "";
            }
            if (type == null) {
                type = "intercept";
            }
            if (title == null) {
                title = "";
            }
            if (contents == null) {
                contents = "";
            }
            if (description == null) {
                description = "";
            }
            if (buttonText == null) {
                buttonText = "";
            }
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("wittifiedXsfr", this.licenseCounter.getXsfrToken(req, res));
            context.put("title", title);
            context.put("id", id);
            context.put("formats", this.formatService.getFormats());
            context.put("format", format);
            context.put("contents", contents);
            context.put("description", description);
            context.put("type", type);
            context.put("allowAnonymous", allowAnonymous);
            context.put("targetGroup", group);
            context.put("allGroups", this.licenseCounter.getAllGroups(username));
            context.put("isActive", isActive);
            context.put("buttonText", buttonText);
            context.put("targetProject", targetProject);
            context.put("targetProjects", this.licenseCounter.getProjectString(targetProject));
            context.put("filterProject", filterProject);
            context.put("filterGroups", filterGroups);
            context.put("isRunIndefinitely", runIndefinitely);
            if ("JIRA".equals(this.licenseCounter.getApplicationType())) {
                context.put("filterProjectRole", filterProjectRole);
                context.put("targetProjectRole", targetProjectRole);
                context.put("allProjectRoles", this.licenseCounter.getAllProjectRoles());
            }
            context.put("delayButton", delayButton);
            context.put("resetButton", resetButton);
            context.put("availableProjects", this.licenseCounter.getAllProjects(username));
            context.put("allProjects", this.selectOptionFormatter(this.licenseCounter.getAllProjects(username)));
            context.put("helper", (Object)this);
            context.put("product", this.licenseCounter.getApplicationType());
            context.put("containerProjectName", this.licenseCounter.getProductContainerName());
            context.put("showButton", showButton);
            context.put("displayTypes", new DisplayTypeHolder().getDisplayTypes());
            context.put("displayType", displayType);
            context.put("flagsSupported", this.licenseCounter.areFlagsSupported());
            context.put("endTime", endTime);
            context.put("startTime", startTime);
            context.put("restrictByDate", restrictByDate);
            context.put("weeklyEndTime", weeklyEndTime);
            context.put("weeklyStartTime", weeklyStartTime);
            context.put("isRecurringWeeklyType", isRecurringWeeklyType);
            context.put("selectedDays", selectedDays);
            context.put("projectEdit", false);
            context.put("shouldFilterProject", shouldFilterProject);
            if (thisProjectOnly != null) {
                context.put("filterProject", true);
                context.put("projectEdit", true);
            }
            context.put("license", this.getCheckLicense());
            if ("CONFLUENCE".equals(this.licenseCounter.getApplicationType()) || "JIRA".equals(this.licenseCounter.getApplicationType())) {
                context.put("filterCategory", filterCategory);
                context.put("targetCategories", targetCategories);
                context.put("allCategories", this.licenseCounter.getAllCategories());
            }
            if ("CONFLUENCE".equals(this.licenseCounter.getApplicationType()) || "JIRA".equals(this.licenseCounter.getApplicationType())) {
                context.put("isNewUser", isNewUser);
            }
            context.put("isCustomRecurrence", isCustomRecurrence);
            context.put("isRecurringType", isRecurringType);
            context.put("isRunningType", isRunningType);
            context.put("recurringType", recurringType);
            context.put("runningType", runningType);
            context.put("runningFreq", runningFreq);
            context.put("recurringDay", recurringDay);
            context.put("filterUser", filterUser);
            context.put("targetUser", targetUser);
            context.put("allUsers", this.licenseCounter.getActiveUsers());
            this.render("/templates/admin-edit-updated.vm", context, res);
        } else {
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("message", "The user that you're currently logged in as is not an administrator. This page is limited to administrator access.");
            res.setContentType("text/html");
            this.render("/templates/security-breach.vm", context, res);
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String pKey;
        res.setContentType("text/html");
        String id = req.getParameter("id");
        String title = req.getParameter("title");
        String description = req.getParameter("description");
        String contents = req.getParameter("contents");
        UserProfile currentUser = this.userManager.getRemoteUser();
        String type = req.getParameter("type");
        String buttonText = req.getParameter("buttonText");
        String targetProject = req.getParameter("targetProject");
        String updatedTargetProject = "";
        if (("JIRA".equals(this.licenseCounter.getApplicationType()) || "CONFLUENCE".equals(this.licenseCounter.getApplicationType())) && StringUtils.isNoneBlank(targetProject)) {
            String[] stringArray = targetProject.split(WEEK_DAY_CRON_DELIMITER);
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String project;
                String pkey = project = stringArray[i];
                if (targetProject.contains("(")) {
                    pkey = project.substring(project.lastIndexOf("(") + 1, project.lastIndexOf(")"));
                }
                updatedTargetProject = updatedTargetProject + ":" + pkey + ":";
            }
            targetProject = updatedTargetProject;
        } else if (this.licenseCounter.getApplicationType().equals("BITBUCKET") && (targetProject = req.getParameter("targetProject")).indexOf(":") == -1) {
            targetProject = ":" + targetProject + ":";
        }
        String targetCategories = "";
        String targetProjectRole = null;
        if ("JIRA".equals(this.licenseCounter.getApplicationType())) {
            targetProjectRole = req.getParameter("targetProjectRole");
        }
        int format = 0;
        if (req.getParameter("format") != null) {
            format = Integer.parseInt(req.getParameter("format"));
        }
        String groupTarget = req.getParameter("targetGroup");
        boolean allowAnonymous = false;
        boolean isActive = false;
        boolean filterProject = false;
        boolean filterGroups = false;
        boolean filterCategory = false;
        boolean filterProjectRole = false;
        boolean filterUser = false;
        String targetUser = null;
        boolean delayButton = false;
        boolean showButton = false;
        boolean resetButton = false;
        boolean restrictByDate = false;
        boolean runIndefinitely = false;
        boolean isNewUser = false;
        boolean isCustomRecurrence = false;
        boolean isRunningType = false;
        boolean isRecurringType = false;
        int runningFreq = 1;
        String runningType = "days";
        String recurringType = "weekly";
        int recurringDay = 1;
        int displayType = 0;
        logger.debug(req.getParameter("allowAnonymous"));
        if (req.getParameter("runIndefinitely") != null) {
            runIndefinitely = Boolean.parseBoolean(req.getParameter("runIndefinitely"));
        }
        if (req.getParameter("timeRestrict") != null) {
            restrictByDate = Boolean.parseBoolean(req.getParameter("timeRestrict"));
        }
        long startTime = -1L;
        long endTime = -1L;
        boolean isRecurringWeeklyType = false;
        String selectedDays = "";
        String weeklyStartTime = "";
        String weeklyEndTime = "";
        Integer browserOffset = null;
        if (req.getParameter("end-time") != null) {
            endTime = Long.parseLong(req.getParameter("end-time"));
        }
        if (runIndefinitely) {
            endTime = Long.parseLong("253402108200000");
        }
        if (req.getParameter("start-time") != null) {
            startTime = Long.parseLong(req.getParameter("start-time"));
        }
        if (req.getParameter("isRecurringWeeklyType") != null) {
            isRecurringWeeklyType = Boolean.parseBoolean(req.getParameter("isRecurringWeeklyType"));
        }
        if (StringUtils.isNotBlank(req.getParameter("weeklyStartTime"))) {
            weeklyStartTime = req.getParameter("weeklyStartTime");
        }
        if (StringUtils.isNotBlank(req.getParameter("weeklyEndTime"))) {
            weeklyEndTime = req.getParameter("weeklyEndTime");
        }
        if (StringUtils.isNotBlank(req.getParameter("announcer_browser_offset"))) {
            browserOffset = Integer.parseInt(req.getParameter("announcer_browser_offset"));
        }
        if (StringUtils.isNotBlank(req.getParameter("selectedDays"))) {
            selectedDays = req.getParameter("selectedDays");
        }
        if (req.getParameter("showButton") != null) {
            showButton = Boolean.parseBoolean(req.getParameter("showButton"));
        }
        if (type.equalsIgnoreCase("intercept") || type.equalsIgnoreCase("dialog")) {
            showButton = true;
        }
        if (req.getParameter("displayType") != null && (displayType = Integer.parseInt(req.getParameter("displayType"))) != 0 && displayType != 2 && displayType != 1 && displayType != 3 && displayType != 4) {
            displayType = 0;
        }
        if (req.getParameter("isActive") != null) {
            isActive = Boolean.parseBoolean(req.getParameter("isActive"));
        }
        if (req.getParameter("filterProject") != null) {
            filterProject = Boolean.parseBoolean(req.getParameter("filterProject"));
        }
        if ("JIRA".equals(this.licenseCounter.getApplicationType()) && req.getParameter("filterProjectRole") != null) {
            filterProjectRole = Boolean.parseBoolean(req.getParameter("filterProjectRole"));
        }
        if (req.getParameter("format") != null) {
            format = Integer.parseInt(req.getParameter("format"));
        }
        if (req.getParameter("filterGroups") != null) {
            filterGroups = Boolean.parseBoolean(req.getParameter("filterGroups"));
        }
        if (req.getParameter("filterUser") != null && (filterUser = Boolean.parseBoolean(req.getParameter("filterUser")))) {
            targetUser = req.getParameter("targetUser");
        }
        if (req.getParameter("delayButton") != null) {
            delayButton = Boolean.parseBoolean(req.getParameter("delayButton"));
        }
        if (req.getParameter("resetButton") != null) {
            resetButton = Boolean.parseBoolean(req.getParameter("resetButton"));
        }
        if (req.getParameter("allowAnonymous") != null) {
            allowAnonymous = Boolean.parseBoolean(req.getParameter("allowAnonymous"));
        }
        if (groupTarget == null) {
            groupTarget = "";
        }
        if (title != null && title.equals("wittified-default")) {
            title = null;
        }
        if (description != null && description.equals("wittified-default")) {
            description = null;
        }
        if (contents != null && contents.equals("wittified-default")) {
            contents = null;
        }
        if (type != null && type.equals("wittified-default")) {
            type = null;
        }
        if (buttonText != null && buttonText.equals("")) {
            buttonText = null;
        }
        if ("CONFLUENCE".equals(this.licenseCounter.getApplicationType()) || "JIRA".equals(this.licenseCounter.getApplicationType())) {
            if (req.getParameter("filterCategory") != null) {
                filterCategory = Boolean.parseBoolean(req.getParameter("filterCategory"));
            }
            targetCategories = req.getParameter("targetCategory");
        }
        if (("CONFLUENCE".equals(this.licenseCounter.getApplicationType()) || "JIRA".equals(this.licenseCounter.getApplicationType())) && req.getParameter("newUserButton") != null) {
            isNewUser = Boolean.parseBoolean(req.getParameter("newUserButton"));
        }
        if (req.getParameter("customRecurrence") != null) {
            isCustomRecurrence = Boolean.parseBoolean(req.getParameter("customRecurrence"));
        }
        if (req.getParameter("isRunningType") != null) {
            isRunningType = Boolean.parseBoolean(req.getParameter("isRunningType"));
        }
        if (req.getParameter("isRecurringType") != null) {
            isRecurringType = Boolean.parseBoolean(req.getParameter("isRecurringType"));
        }
        if (req.getParameter("runningFreq") != null) {
            runningFreq = Integer.parseInt(req.getParameter("runningFreq"));
        }
        if (req.getParameter("recurringDaySelector") != null) {
            recurringDay = Integer.parseInt(req.getParameter("recurringDaySelector"));
        }
        if (req.getParameter("runningTypeSelector") != null) {
            runningType = req.getParameter("runningTypeSelector");
        }
        if (req.getParameter("recurringTypeSelector") != null) {
            recurringType = req.getParameter("recurringTypeSelector");
        }
        if (isRunningType) {
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(System.currentTimeMillis());
            if (runningType.equals("days")) {
                cal.add(5, runningFreq);
            }
            if (runningType.equals("weeks")) {
                cal.add(3, runningFreq);
            }
            if (runningType.equals("months")) {
                cal.add(2, runningFreq);
            }
            endTime = cal.getTimeInMillis();
        }
        logger.debug(String.format("Saving %s for %s with a description of %s and contents: %s", title, currentUser.getUsername(), description, contents));
        Notification notification = null;
        boolean block = true;
        if (!id.equals("-1")) {
            notification = this.notificationService.getThisNotification(Integer.parseInt(id));
        }
        boolean isAdmin = AnnouncerHelper.isAdminUser(this.userManager);
        if (currentUser != null && isAdmin) {
            block = false;
        } else if (!id.equals("-1")) {
            notification = this.notificationService.getThisNotification(Integer.parseInt(id));
            if (currentUser != null && !isAdmin && notification != null && notification.getFilterProject() && notification.getTargetProject() != null && (pKey = notification.getTargetProject()) != null) {
                pKey = pKey.replaceAll(":", "");
                if (notification.getTargetProject().contains(pKey) && this.licenseCounter.currentUserCanEdit(pKey)) {
                    block = false;
                }
            }
        } else if (currentUser != null && !isAdmin && filterProject && targetProject != null && (pKey = targetProject) != null && targetProject.contains(pKey = pKey.replaceAll(":", "")) && this.licenseCounter.currentUserCanEdit(pKey)) {
            block = false;
        }
        if (req.getParameter("wittifiedXsfr") == null) {
            block = true;
        } else if (!this.licenseCounter.validateXsfrToken(req, req.getParameter("wittifiedXsfr"))) {
            block = true;
        }
        if (!block) {
            if (id.equals("-1")) {
                notification = this.notificationService.createNewNotification();
            }
            if (contents != null) {
                notification.setHtml(contents);
            }
            if (type != null) {
                notification.setType(type);
            }
            if (description != null) {
                notification.setDescription(description);
            }
            if (title != null) {
                notification.setTitle(title);
            }
            if (buttonText != null) {
                notification.setButtonText(buttonText);
            } else {
                notification.setButtonText("");
            }
            notification.setStartDate(new Date(startTime));
            notification.setEndDate(new Date(endTime));
            notification.setDateRestrict(restrictByDate);
            notification.setFormat(format);
            notification.setAnonymous(allowAnonymous);
            notification.setActive(isActive);
            notification.setDelayButton(delayButton);
            notification.setResetButton(resetButton);
            notification.setFilterProject(filterProject);
            notification.setFilterGroups(filterGroups);
            notification.setFilterProjectRole(filterProjectRole);
            notification.setShowButton(showButton);
            notification.setDisplay(displayType);
            notification.setFilterCategory(filterCategory);
            notification.setTargetCategories(targetCategories);
            notification.setGroupTarget(StringUtils.isNoneBlank(groupTarget) ? groupTarget : "");
            notification.setTargetProject(StringUtils.isNoneBlank(targetProject) && !targetProject.equalsIgnoreCase(":null:") ? targetProject : "");
            notification.setTargetProjectRole(StringUtils.isNoneBlank(targetProjectRole) && !targetProjectRole.equalsIgnoreCase(":null:") ? targetProjectRole : "");
            notification.setNewUserOption(isNewUser);
            notification.setFilterUser(filterUser);
            notification.setTargetUser(StringUtils.isNoneBlank(targetUser) ? targetUser : null);
            notification.setCustomRecurrenceOption(isCustomRecurrence);
            notification.setRecurringTypeOption(isRecurringType);
            notification.setRunningTypeOption(isRunningType);
            notification.setRecurringType(recurringType);
            notification.setRunningFreq(runningFreq);
            notification.setRunningType(runningType);
            notification.setRecurringWeeklyType(isRecurringWeeklyType);
            if (StringUtils.isNoneBlank(recurringType) && recurringType.equals("weekly")) {
                notification.setDayOfWeek(recurringDay);
            } else if (StringUtils.isNoneBlank(recurringType) && recurringType.equals("monthly")) {
                notification.setDayOfMonth(recurringDay);
            }
            if (notification.getActive()) {
                if (BooleanUtils.isTrue(notification.getDateRestrict())) {
                    Date currentDate = new Date();
                    if (isRunningType) {
                        notification.setTempActive(currentDate.compareTo(notification.getStartDate()) > -1);
                    } else if (isRecurringType) {
                        boolean isTempActive = this.notificationService.isActiveNotification(notification, RecurrenceType.RECURRING, currentDate);
                        notification.setTempActive(isTempActive);
                    } else {
                        notification.setTempActive(currentDate.compareTo(notification.getStartDate()) > -1 && currentDate.compareTo(notification.getEndDate()) < 1);
                    }
                    this.tokenChangeService.updateToken();
                } else {
                    notification.setTempActive(true);
                }
            } else if (!notification.getActive()) {
                notification.setTempActive(false);
            }
            if (isCustomRecurrence) {
                if (isRecurringWeeklyType && StringUtils.isNotBlank(selectedDays)) {
                    notification.setSelectedDays(selectedDays);
                    notification.setWeeklyStartTime(weeklyStartTime);
                    notification.setWeeklyEndTime(weeklyEndTime);
                    notification.setBrowserOffset(browserOffset);
                }
                String cronExpression = AnnouncerHelper.generateCronExpression(notification, startTime);
                if (id.equals("-1")) {
                    logger.debug("** New notification is being created which is of custom recurrence type ** ");
                    logger.debug(String.format("** Scheduling a recurring job with cron %s ", cronExpression));
                    this.recurringAnnouncementScheduler.schedule(cronExpression, notification);
                    logger.debug("** Recurring Job Scheduled **");
                } else {
                    logger.debug("** Existing notification is being created which is of custom recurrence type ** ");
                    logger.debug(String.format("** Scheduling a recurring job with cron %s ", cronExpression));
                    this.recurringAnnouncementScheduler.reschedule(cronExpression, notification);
                    logger.debug("** Recurring Job Scheduled **");
                }
            }
            this.notificationService.saveNotification(notification);
            if (type.equals("login") || type.equals("intercept")) {
                this.tokenChangeService.updateToken();
            }
        } else {
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("message", "The user that you're currently logged in as is not an administrator. This page is limited to administrator access.");
            res.setContentType("text/html");
            this.render("/templates/security-breach.vm", context, res);
        }
    }

    protected void render(String template, Map<String, Object> context, HttpServletResponse response) throws IOException {
        this.templateRenderer.render(template, context, (Writer)response.getWriter());
    }

    public String getCheckLicense() {
        if (this.licenseStorageManager.getLicense().isDefined()) {
            PluginLicense pluginLicense = (PluginLicense)this.licenseStorageManager.getLicense().get();
            if (pluginLicense.getError().isDefined()) {
                if (((LicenseError)pluginLicense.getError().get()).name().equals("EXPIRED")) {
                    return "The evaluation license has expired. Please contact your System administrator";
                }
                return "An error occurred while validating your license for this plugin: " + ((LicenseError)pluginLicense.getError().get()).name();
            }
            return null;
        }
        return "Plugin is not licensed. In order to evaluate this plugin you need to create an evaluation license";
    }

    public boolean isTargetSelected(String val, String fullString) {
        if (fullString == null) {
            return false;
        }
        return fullString.contains(":" + val + ":");
    }

    public TreeMap<String, String> sortMap(Map<String, String> map) {
        ValueComparator bvc = new ValueComparator(map);
        TreeMap<String, String> retMap = new TreeMap<String, String>(bvc);
        retMap.putAll(map);
        return retMap;
    }

    private List<String> selectOptionFormatter(Map<String, String> options) {
        ArrayList<String> formattedOptions = new ArrayList<String>();
        for (Map.Entry<String, String> option : options.entrySet()) {
            formattedOptions.add(option.getValue() + " (" + option.getKey() + ")");
        }
        return formattedOptions;
    }

    class ValueComparator
    implements Comparator<String> {
        Map<String, String> base;

        public ValueComparator(Map<String, String> base) {
            this.base = base;
        }

        @Override
        public int compare(String a, String b) {
            return a.compareTo(b);
        }
    }
}

