/*
 * Decompiled with CFR 0.152.
 */
package com.wittified.rest;

import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.wittified.ao.statuspage.StatusPageConfig;
import com.wittified.rest.entities.FieldEntityMoveBean;
import com.wittified.services.statuspage.StatusPageService;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Path(value="statuspage")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class StatusPageResource {
    private final StatusPageService statusPageService;

    public StatusPageResource(StatusPageService statusPageService) {
        this.statusPageService = statusPageService;
    }

    @Path(value="/list")
    @GET
    @Produces(value={"application/json"})
    public Response all() {
        StatusPageConfig[] configLists = this.statusPageService.getAllStatusPageConfigs();
        JSONArray configs = new JSONArray();
        for (int i = 0; i < configLists.length; ++i) {
            StatusPageConfig config = configLists[i];
            try {
                configs.put((Object)this.buildJSONResponse(config));
                continue;
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return Response.ok((Object)configs.toString()).build();
    }

    private JSONObject buildJSONResponse(StatusPageConfig config) throws JSONException {
        JSONObject json = new JSONObject();
        json.put("id", config.getID());
        json.put("active", config.getActive());
        json.put("title", (Object)config.getTitle());
        json.put("description", (Object)config.getDescription());
        json.put("priority", (Object)config.getWeight());
        json.put("eol", (Object)config.getEOL());
        return json;
    }

    @AnonymousAllowed
    @GET
    @Path(value="{id}")
    public Response getConfig(@PathParam(value="id") String id) {
        return null;
    }

    @PUT
    @Path(value="{id}")
    public Response updateConfig(@PathParam(value="id") String id, StatusPageConfig config) {
        return null;
    }

    @POST
    public Response createConfig(StatusPageConfig bean) {
        return null;
    }

    @DELETE
    @Path(value="{id}")
    public Response delete(@PathParam(value="id") String id) {
        return null;
    }

    @POST
    @Path(value="/{id}/move")
    @Produces(value={"application/json"})
    public Response move(@PathParam(value="id") String id, FieldEntityMoveBean moveBean) {
        this.statusPageService.move(id, moveBean.getAfterItem());
        return this.all();
    }
}

