AJS.toInit(function() {
	//--------------------- statuspage.io activity page start -------------------------------
	if(AJS.$('#statuspage-bubble-list').length > 0){
		AJS.$('#statuspage-bubble-list tr td a.statuspage-bubble-view').on("click",function(event) {
			var key = AJS.$(this).attr("data-config");
			AJS.$.get(AJS.contextPath()+'/plugins/servlet/wittified/admin/statuspage/incident?key='+key, function(incident){
				var $dialog = AJS.$(aui.dialog.dialog2({'removeOnHide': true})).appendTo(document.body);
				var bubbleDialog = AJS.dialog2($dialog);
	            bubbleDialog.show();
				var contents = wittified.announcer.soy.incident.show({'incident':incident});
				$dialog.html(AJS.$(contents).html());
	            AJS.$(".aui-dialog2 #dialog-close-button1").on('click', function(e) {
				    e.preventDefault();
				    AJS.dialog2(".aui-dialog2").hide();
				});
	            AJS.$(".aui-dialog2 #dialog-disable-button").on("click",function(e) {
	            	AJS.$(this).attr('disabled','disabled');
	            	var status = 'true';
					AJS.$("#bubble-spinner").spin();
					AJS.$("#bubble-spinner div.spinner").css("left","-20px");
					if(incident.status){
						status = 'false';
					}
					e.preventDefault();
					var newForm = AJS.$('<form>', {
				        'action': AJS.contextPath()+"/plugins/servlet/wittified/admin/statuspage/bubbles/list",
				        'method': 'POST'
				    }).append(AJS.$('<input>', {
				        'name': 'incident-key',
				        'value': key,
				        'type': 'hidden'
				    })).append(AJS.$('<input>', {
				        'name': 'status',
				        'value': status,
				        'type': 'hidden'
				    })).appendTo("body");
					newForm.submit();
	            });
			});
		});
	}
	//--------------------- statuspage.io activity page end-------------------------------
	
	//--------------------- token configuration page start--------------------------------
	
	AJS.$("#wittified-token-config,#wittified-token-config1").click(function() {
		AJS.dialog2("#token-config-dialog").show();
		AJS.$("#pollingFreq").auiSelect2();
	});
	
	AJS.$("#dialog-token-submit").click(function(e) {
		e.preventDefault();
		var $form = AJS.$("#status-page-token-config")[0];
		if(validateTokenForm($form)){
			AJS.$.ajax({
		        url: AJS.contextPath()+'/plugins/servlet/wittified/admin/statuspage/token/configuration',
		        data: AJS.$(this.form).serialize(),
		        type: 'POST',
		        method: 'POST',
				success: function (data) {	
					window.location.reload(false);
		            AJS.dialog2("#token-config-dialog").hide();
				}
		    });
		}
	});
	
	AJS.dialog2("#token-config-dialog").on("show", function() {
		AJS.$("form#status-page-token-config").find('div.error-message').remove();
		AJS.$.get(AJS.contextPath()+'/plugins/servlet/wittified/admin/statuspage/token/configuration', function(res){
			if(res.baseUrl){
				AJS.$("#baseUrl").val(res.baseUrl)
			}
			AJS.$("#baseUrl").css('background-color','#f5f5f5').prop("readonly", true);
			AJS.$("#apiToken").val(res.apiToken)
			AJS.$("#announcementPrefix").val(res.announcementPrefix)
			if(res.pollingFreq!=null){
				AJS.$("#pollingFreq").select2('data', {id: res.pollingFreq, text:res.pollingFreq});
			}
		});
	});
	
	AJS.$("#dialog-token-close").click(function(e) {
		e.preventDefault();
		AJS.dialog2("#token-config-dialog").hide();
	});
	
	//--------------------- token configuration page end----------------------------------
	
	
	//--------------------- statuspage.io configuration update start-----------------------------
	
	AJS.$(".wittified-config-view").live("click",function() {
		var id = AJS.$(this).attr("data-config");
		AJS.$("#wittified-statuspage-dialog-view").attr('config-id',id);
		AJS.dialog2("#wittified-statuspage-dialog-view").show();
	});
	
	AJS.dialog2("#wittified-statuspage-dialog-view").on("show", function() {
		var $dialog = this;
		var $form = AJS.$("#wittified-statuspage-dialog-view > form#status-page-create")[0];
		clearForm();
		clearErrorOnChange($form);
		loadConfig(true);
		//AJS.$("#dialog-submit-update",$dialog).attr('disabled','disabled');
		initializeElements($dialog);
		initializePages($dialog);
		AJS.$("#dialog-submit-update",$form).on("click", function(e) {
			//AJS.$(this).attr('disabled','disabled');
			//AJS.$('.config-load-spinner').spin();
			window.onbeforeunload = null;
			submitSpinner(true,AJS.$(this));
			//e.preventDefault();
			doValidation($form,"UPDATE");
		});
		
	});
	
	function loadConfig(spin){
		if(spin){
			AJS.$('.config-load-spinner').spin();
			AJS.$.each(AJS.$("#wittified-statuspage-dialog-view :input").not("#dialog-close-button"), function(){
				AJS.$(this).attr('disabled','disabled');
			});
		}else{
			AJS.$('.config-load-spinner').spinStop();
			AJS.$.each(AJS.$("#wittified-statuspage-dialog-view :input").not("#dialog-close-button"), function(){
				AJS.$(this).removeAttr('disabled');
			});
		}
	}
	
	AJS.$("#wittified-statuspage-dialog-view #dialog-close-button").click(function(e) {
		e.preventDefault();
		AJS.dialog2("#wittified-statuspage-dialog-view").hide();
	});
	
	//--------------------- statuspage.io configuration update end-----------------------------
	
	function validateTokenForm($form){
		AJS.$("div.error-message",$form).remove();
		var errorMessage = "<div class='error-message'>This is a required field</div>";
		var $baseUrl = AJS.$("#baseUrl",$form)[0];
		var $apiToken = AJS.$("#apiToken",$form)[0];
		var $prefix = AJS.$("#announcementPrefix",$form)[0];
		var valid = true;
		if(AJS.$.trim($baseUrl.value).length==0){
			$baseUrl.parentNode.insertAdjacentHTML("beforeend",errorMessage);
			valid = false;
		}
		if(AJS.$.trim($apiToken.value).length==0){
			$apiToken.parentNode.insertAdjacentHTML("beforeend",errorMessage);
			valid = false;
		}
		if(AJS.$.trim($prefix.value).length==0){
			$prefix.parentNode.insertAdjacentHTML("beforeend",errorMessage);
			valid = false;
		}
		return valid;
	}
	
	//--------------------- statuspage.io configuration create start-----------------------------
	
	AJS.$("#wittified-dialog-show-button").click(function() {
		AJS.dialog2("#wittified-statuspage-dialog-create").show();
	});
	
	AJS.dialog2("#wittified-statuspage-dialog-create").on("show", function() {
		//reset the form as its keeping the selected values and we can't use .remove()
		//because of a bug in the dialog2.
		var $dialog = this;
		var $form = AJS.$("#wittified-statuspage-dialog-create > form#status-page-create")[0];
		clearForm();
		clearErrorOnChange($form);
		initializeElements($dialog);
		AJS.$('#status-spinner',$dialog).spinStop();
		AJS.$("#dialog-create-submit",$form).on("click", function(e) {
			window.onbeforeunload = null;
			submitSpinner(true,AJS.$(this));
			//e.preventDefault();
			doValidation($form,"CREATE");
		});
		AJS.$("#s2id_groups").select2("val","");
		AJS.$("#s2id_projects").select2("val","");
	});
	
	AJS.$("#wittified-statuspage-dialog-create #dialog-close-button").click(function(e) {
		e.preventDefault();
		AJS.dialog2("#wittified-statuspage-dialog-create").hide();
	});
	
	//--------------------- statuspage.io configuration create end-----------------------------
	
	//--------------------- statuspage.io common start-------------
	
	AJS.$(".groupsOne").change(function() {
		if(AJS.$(this).is(":checked")) {
			AJS.$(".ann-groups").show();
			AJS.$(".ann-groups").auiSelect2();
	   		return;
		}
		AJS.$("div[id=s2id_groups]").remove();
	});
	
	AJS.$(".projectsOne").change(function() {
		if(AJS.$(this).is(":checked")){
			AJS.$(".ann-projects").show();
			AJS.$(".ann-projects").auiSelect2();
	   		return;
		}
		AJS.$("div[id=s2id_projects]").remove();
	});
	
	function initializeElements($dialog){
		AJS.$("#status-pages,#eol,#announcementType,#notificationType,#statuses",$dialog).auiSelect2();
		AJS.$(".statuspage-tooltip").tooltip();
		AJS.$(".announcementType").on("change",function(e){
			if(AJS.$("#announcementType",$dialog).select2("val") == "intercept"){
				//empty the selection if any
				AJS.$("div[id=s2id_projects]").remove();
				//uncheck disable space/project filter
				AJS.$(".projectsOne").prop('checked', false);
				AJS.$(".projectsOne").attr('disabled','disabled');
			}else{
				AJS.$(".projectsOne").removeAttr('disabled');
			}
		});
	}

	function selectElements(configId,$dialog){
		AJS.$.get(AJS.contextPath()+'/plugins/servlet/wittified/admin/statuspage/config?ID='+configId, function(configData){
			var allProjects = [],
			selectedProjects = [],
			allGroups = [],
			selectedGroups = [];
			AJS.$("#active",$dialog).prop('checked', configData.active);
			AJS.$("#name",$dialog).val(configData.title);
			AJS.$("#description",$dialog).val(configData.description);
			AJS.$('#s2id_announcementType').select2('val',configData.announcementType).trigger('change');
			AJS.$('#s2id_notificationType').select2('val',configData.notificationType).trigger('change');
			AJS.$("#eol",$dialog).select2().val(configData.eol).trigger("change");
			AJS.$("#s2id_status-pages").select2('val',configData.pages).trigger("change");
			var existing_statuses = [];
			AJS.$.each(configData.statuses, function(){
				existing_statuses.push({id:this,text:this})
			});
			AJS.$(".statuses").select2("data", existing_statuses);
			AJS.$('#status-spinner',$dialog).spinStop();
			AJS.$('#status-pages-spinner',$dialog).spinStop();
			AJS.$('#configId',$dialog).val(configId);
			AJS.$('#type',$dialog).val("UPDATE");
			if(JSON.parse(configData["filter-projects"])){
				var projects = [];
				AJS.$('.projectsOne',$dialog).prop('checked', true).trigger('change');
				AJS.$.each(configData.projects, function(){
					projects.push({id:this,text:this.split("#")[1]})
				});
				AJS.$(".ann-projects").select2("data", projects);
			}
			if(JSON.parse(configData["filter-groups"])){
				AJS.$('.groupsOne',$dialog).prop('checked', true).trigger('change');
				AJS.$(".ann-groups").select2('val',configData.groups).trigger("change");
			}
			// enable the update button
	    	//AJS.$("#dialog-submit-update",$dialog).removeAttr('disabled');
	    	loadConfig(false);
		});
	}
	
	function initializePages($dialog){
		var configId = AJS.$("#wittified-statuspage-dialog-view").attr('config-id');
		selectElements(configId,$dialog);
	}
	
	function clearErrorOnChange($form){
		// clear error message on input
		AJS.$("#name",$form).on("change", function (e) {
	 		AJS.$(this).next("div.error-message").remove();
	 	});
		AJS.$("#status-pages",$form).on("select2-selecting", function(e) { 
			AJS.$("div.error-message",AJS.$(this).parent('div')).remove();
		});
		
	}
	
	function validateForm($form){
		AJS.$("div.error-message",$form).remove();
		var errorMessage = "<div class='error-message'>This is a required field</div>";
		var $name = AJS.$("#name",$form)[0];
		var $pages = AJS.$("#s2id_status-pages",$form);
		var $components = AJS.$("#s2id_components",$form);
		var valid = true;
		if(undefined || AJS.$.trim($name.value).length==0){
			$name.parentNode.insertAdjacentHTML("beforeend",errorMessage);
			valid = false;
		}
		var pages = $pages.select2("val");
		if(pages.length==0){
			$pages.closest('div')[0].insertAdjacentHTML("beforeend",errorMessage);
			valid = false;
		}
		return valid;
	}
	
	function doValidation($form,method){
		//console.log($form);
		AJS.$("div.head-error-message",$form).parent('div').remove();
		if(validateForm($form)){
			// server side validation
			AJS.$.ajax({
				url : AJS.contextPath()+'/plugins/servlet/wittified/admin/statuspage/validation?method='+method,
				type : 'get',
				method:"GET",
				data: AJS.$($form).serialize(),
				dataType : 'json',
				beforeSend : function(xhr) {
					//spin if any
				},
				success : function(results) {
					/*
					$form.append(AJS.$('<input>', {
				        'name': 'type',
				        'value': method,
				        'type': 'hidden'
				    }));
				    */
					$form.submit();
				},
				statusCode: {
					409: function() {
				        //name already exists
						var $name = AJS.$("#name",$form)[0];
						$name.parentNode.insertAdjacentHTML("beforeend","<div class='error-message'>The name you entered already exist. Please enter another name</div>");
						submitSpinner(false,AJS.$('button.aui-button-primary',$form));
					},
					500: function() {
				       // similar configuration like pages, components.
						var $ele = AJS.$("div.aui-dialog2-content",$form)[0];
						$ele.insertAdjacentHTML("afterbegin","<div class='field-group'><div class='head-error-message'A similar configuration already exist for this Statuspage</div></div>");
						submitSpinner(false,AJS.$('button.aui-button-primary',$form));
					}
				}
				
			});
		}else{
			submitSpinner(false,AJS.$('button.aui-button-primary',$form));
		}
		
	}
	
	function submitSpinner(spin,$element){
		if(spin){
			AJS.$('.config-load-spinner').spin();
			//$element.setAttribute('aria-disabled','true');
			$element.attr('disabled','disabled');
		}else{
			AJS.$('.config-load-spinner').spinStop();
			//$element.setAttribute('aria-disabled','false');
			$element.removeAttr('disabled');
		}
	}
	
	function clearForm(){
		//remove any previous validations
		AJS.$("form#status-page-create").find('div.error-message').remove();
		AJS.$("form#status-page-create").find('div.head-error-message').remove();
		AJS.$('div:empty').each(function(){
		    if(AJS.$.trim(AJS.$(this).html()).length == 0){
		    	AJS.$(this).remove();
		    }
		});
		//clear the fields
		AJS.$('form#status-page-create').find('input:text,textarea').val('');
		AJS.$('form#status-page-create').find('input:checkbox').prop('checked', false);
		AJS.$("#s2id_announcementType").select2("val","intercept").trigger('change');
		AJS.$("#s2id_notificationType").select2("val","0").trigger('change');
		AJS.$("#s2id_status-pages").select2("val","");
		AJS.$("div[id=s2id_groups]").remove();
		AJS.$("div[id=s2id_projects]").remove();
		AJS.$("#componentLables").html('');
		AJS.$("#s2id_statuses").select2("val",["Investigating", "Identified", "Monitoring","Resolved","Scheduled", "In progress", "Verifying","Completed"]).trigger('change');
		AJS.$("#s2id_eol").select2("val","15").trigger('change');
	}
	
	AJS.$(".wittified-config-delete").live("click",function(e) {
		if(confirm("Are you sure you want to delete this?")){
			//e.preventDefault();
			/*  make this a rest call
			AJS.$.get(AJS.contextPath()+'/plugins/servlet/wittified/admin/statuspage/incident?key='+key, function(incident){
				
			});
			*/
			var newForm = AJS.$('<form>', {
		        'action': AJS.contextPath()+"/plugins/servlet/wittified/admin/statuspage/config",
		        'method': 'POST'
		    }).append(jQuery('<input>', {
		        'name': 'configId',
		        'value': AJS.$(this).attr("data-config"),
		        'type': 'hidden'
		    })).append(jQuery('<input>', {
		        'name': 'type',
		        'value': "DELETE",
		        'type': 'hidden'
		    })).appendTo("body");
		    newForm.submit();
	    }
	    else{
	        return false;
	    }
	});
	
	//--------------------- statuspage.io common end-------------
	
	//--------------------- statuspage.io configuration rest full table start-------------
	
	var showStatusPageConfigStatus = AJS.RestfulTable.CustomReadView.extend({
        render: function (self) {
            //return self.value ? AJS.$('<span class="aui-icon aui-icon-small aui-iconfont-star"></span>') : AJS.$('<span class="aui-icon aui-icon-small aui-iconfont-unstar"></span>');
        	return self.value ? AJS.$('<span class="aui-icon aui-icon-small aui-iconfont-approve" style="color:green"></span>') : AJS.$('<span class="aui-icon aui-icon-small aui-iconfont-devtools-task-disabled" style="color:red"></span>');
        }
	});
	
	var showTheActions = AJS.RestfulTable.CustomReadView.extend({
		render: function (self) {
			var html = new Array();
			const theme = document.documentElement.getAttribute('data-color-mode');
			const textColor = theme === 'dark' ? '#DDD' : '#333';
			html.push('<a href="#" class="wittified-config-view" style="padding-right:15px; color: ' + textColor + '" data-config="'+self.value+'"><span class="aui-icon aui-icon-small aui-iconfont-edit wittified-actions-config-view">Edit</span></a>');
			html.push('<a href="#" class="wittified-config-delete" style="color: ' + textColor + '" data-config="'+self.value+'"><span class="aui-icon aui-icon-small aui-iconfont-delete wittified-actions-config-delete">Delete</span></a>');
			return AJS.$(html.join(''));
		}
	});


	//  restfull table
	var $configs = AJS.$("#statuspage-configs-table");
	new AJS.RestfulTable({
		id:$configs,
	    autoFocus: true,
	    allowReorder: true,
	    el:  $configs,
	    resources: {
	        all:  AJS.contextPath()+"/rest/announcer/1.0/statuspage/list",
	        self:  AJS.contextPath()+"/rest/announcer/1.0/statuspage"
	    },
	    columns: [
	        {
	            id: "active",
	            header: "Enabled",
	            allowEdit: false,
	            readView: showStatusPageConfigStatus
	        },
	        {
	            id: "title",
	            header: "Statuspage Integration Name",
	            allowEdit: false
	        },
	        {
	            id: "description",
	            header: "Description",
	            allowEdit: false
	        },
	       /*
	        {
	            id: "priority",
	            header: "Priority",
	            allowEdit: false
	        },*/
	        {
	            id: "eol",
	            header: "EOL",
	            allowEdit: false
	        },
	        {
	            id: "id",
	            header: "Actions",
	            allowEdit: false,
	            readView: showTheActions
	        }
	    ],
	    allowCreate:false,
	    allowEdit:false,
	    allowDelete:false
	});
	
	$configs.bind(AJS.RestfulTable.Events.INITIALIZED, function () {
		var footer = AJS.$("tr.sp-footer-info").detach();
		footer.appendTo(AJS.$("#statuspage-configs-table > tbody.ui-sortable"));
	});
	
	//--------------------- statuspage.io configuration rest full table end-------------
	
})