/*
 * Decompiled with CFR 0.152.
 */
package com.wittified.servlets;

import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.wittified.AnnouncerHelper;
import com.wittified.DisplayTypeHolder;
import com.wittified.ao.Notification;
import com.wittified.ao.NotificationService;
import com.wittified.cache.NotificationCacheEntry;
import com.wittified.format.FormatService;
import com.wittified.licensecounters.LicenseCounter;
import com.wittified.rest.NotificationBean;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class NotificationPreviewServlet
extends HttpServlet {
    private final TemplateRenderer templateRenderer;
    private final WebResourceManager webResourceManager;
    private final UserManager userManager;
    private final I18nResolver i18nResolver;
    private final NotificationService notificationService;
    private final PluginLicenseManager licenseStorageManager;
    private final LicenseCounter licenseCounter;
    private final PluginSettingsFactory pluginSettingsFactory;
    private final FormatService formatService;

    public NotificationPreviewServlet(TemplateRenderer templateRenderer, WebResourceManager webResourceManager, UserManager userManager, NotificationService notificationService, PluginLicenseManager licenseStorageManager, I18nResolver i18nResolver, LicenseCounter licenseCounter, PluginSettingsFactory pluginSettingsFactory, FormatService formatService) {
        this.licenseCounter = licenseCounter;
        this.templateRenderer = templateRenderer;
        this.webResourceManager = webResourceManager;
        this.userManager = userManager;
        this.notificationService = notificationService;
        this.licenseStorageManager = licenseStorageManager;
        this.i18nResolver = i18nResolver;
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.formatService = formatService;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.webResourceManager.requireResourcesForContext("atl-notifier");
        UserProfile user = this.userManager.getRemoteUser();
        boolean block = true;
        if (user != null) {
            if (AnnouncerHelper.isAdminUser(this.userManager)) {
                block = false;
            } else if (req.getParameter("project") != null && this.licenseCounter.currentUserCanEdit(req.getParameter("key"))) {
                block = false;
            }
        }
        if (req.getParameter("wittifiedXsfrToken") == null) {
            block = true;
        } else if (!this.licenseCounter.validateXsfrToken(req, req.getParameter("wittifiedXsfrToken"))) {
            block = true;
        }
        if (!block) {
            HashMap<String, Object> context = new HashMap<String, Object>();
            NotificationBean notification = new NotificationBean();
            notification.setFormat(Integer.parseInt(req.getParameter("format")));
            notification.setDescription(req.getParameter("description"));
            notification.setHtml(req.getParameter("htmlContents"));
            notification.setTitle(req.getParameter("messageTitle"));
            notification.setType(req.getParameter("type"));
            notification.setButtonText(req.getParameter("buttonText"));
            if (req.getParameter("displayType") != null) {
                context.put("displayTypeHtml", DisplayTypeHolder.getIconHtml(Integer.parseInt(req.getParameter("displayType"))));
                context.put("displayType", DisplayTypeHolder.getBannerType(Integer.parseInt(req.getParameter("displayType"))));
            } else {
                context.put("displayTypeHtml", DisplayTypeHolder.getIconHtml(0));
            }
            context.put("isAdmin", false);
            if ("CONFLUENCE".equals(this.licenseCounter.getApplicationType())) {
                context.put("displayHeader", false);
            } else {
                context.put("displayHeader", true);
            }
            context.put("helper", (Object)this);
            context.put("notification", notification);
            context.put("isPreview", true);
            context.put("context", req.getContextPath());
            if (notification.getType() != null && notification.getType().equals("flag")) {
                context.put("body", AnnouncerHelper.escapeEcmaScript(notification.html));
            } else {
                String contents = this.formatService.formatThis(notification.getFormat(), AnnouncerHelper.handleVars(this.licenseCounter, notification.html));
                context.put("body", contents);
                notification.setHtml(contents);
            }
            if (notification.getButtonText() == null || notification.getButtonText().equals("")) {
                if (req.getParameter("type") != null && req.getParameter("type").equals("banner")) {
                    context.put("buttonText", this.i18nResolver.getText("wittified.announcer.banner.dismiss"));
                } else if (req.getParameter("type") != null && req.getParameter("type").equals("dialog")) {
                    context.put("buttonText", this.i18nResolver.getText("wittified.announcer.dialog.dismiss"));
                } else {
                    context.put("buttonText", this.i18nResolver.getText("wittified.announcer.fullpage.acknowledge"));
                }
            } else {
                context.put("buttonText", notification.getButtonText());
            }
            res.setContentType("text/html");
            String template = "/templates/approve-item.vm";
            if (req.getParameter("type") != null && req.getParameter("type").equals("banner")) {
                template = "/templates/preview-banner.vm";
            }
            if (req.getParameter("type") != null && req.getParameter("type").equals("dialog")) {
                template = "/templates/preview-dialog.vm";
            }
            if (req.getParameter("type") != null && req.getParameter("type").equals("flag")) {
                template = "/templates/preview-flag.vm";
            }
            this.render(template, context, res);
        } else {
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("message", "The user that you're currently logged in as is not an administrator. This page is limited to administrator access.");
            res.setContentType("text/html");
            this.render("/templates/security-breach.vm", context, res);
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        HashMap<String, Object> context;
        this.webResourceManager.requireResourcesForContext("atl-notifier");
        UserProfile user = this.userManager.getRemoteUser();
        Notification notification = null;
        boolean block = true;
        notification = this.notificationService.getThisNotification(Integer.parseInt(req.getParameter("notification")));
        if (user != null && notification != null) {
            String pKey;
            if (AnnouncerHelper.isAdminUser(this.userManager)) {
                block = false;
            } else if (notification.getFilterProject() && notification.getTargetProject() != null && (pKey = notification.getTargetProject()) != null) {
                pKey = pKey.replaceAll(":", "");
                if (notification.getTargetProject().contains(pKey) && this.licenseCounter.currentUserCanEdit(pKey)) {
                    block = false;
                }
            }
        }
        if (req.getParameter("wittifiedXsfrToken") == null) {
            block = true;
        } else if (!this.licenseCounter.validateXsfrToken(req, req.getParameter("wittifiedXsfrToken"))) {
            block = true;
        }
        if (!block && notification != null) {
            context = new HashMap();
            NotificationBean notificationBean = new NotificationBean(notification);
            context.put("notification", notificationBean);
            context.put("isPreview", true);
            if (notification.getType() != null && notification.getType().equals("flag")) {
                context.put("body", AnnouncerHelper.escapeEcmaScript(AnnouncerHelper.handleVars(this.licenseCounter, this.format(notification))));
            } else {
                String contents = this.formatService.formatThis(notification.getFormat(), AnnouncerHelper.handleVars(this.licenseCounter, notificationBean.getContents()));
                context.put("body", contents);
                notificationBean.setHtml(contents);
            }
            context.put("helper", (Object)this);
            context.put("action", (Object)this);
            context.put("isAdmin", false);
            context.put("context", req.getContextPath());
            context.put("licenceCheck", this.getCheckLicense());
            res.setContentType("text/html");
            context.put("displayTypeHtml", DisplayTypeHolder.getIconHtml(notification.getDisplay()));
            context.put("displayType", DisplayTypeHolder.getBannerType(notification.getDisplay()));
            if (notification.getButtonText() == null || notification.getButtonText().equals("")) {
                if (notification.getType() != null && notification.getType().equals("banner")) {
                    context.put("buttonText", this.i18nResolver.getText("wittified.announcer.banner.dismiss"));
                } else if (req.getParameter("type") != null && req.getParameter("type").equals("dialog")) {
                    context.put("buttonText", this.i18nResolver.getText("wittified.announcer.dialog.dismiss"));
                } else {
                    context.put("buttonText", this.i18nResolver.getText("wittified.announcer.fullpage.acknowledge"));
                }
            } else {
                context.put("buttonText", notification.getButtonText());
            }
            String template = "/templates/approve-item.vm";
            if (notification.getType() != null && notification.getType().equals("banner")) {
                template = "/templates/preview-banner.vm";
            }
            if (notification.getType() != null && notification.getType().equals("dialog")) {
                template = "/templates/preview-dialog.vm";
            }
            if (notification.getType() != null && notification.getType().equals("flag")) {
                template = "/templates/preview-flag.vm";
            }
            this.render(template, context, res);
        } else {
            context = new HashMap<String, Object>();
            context.put("message", "The user that you're currently logged in as is not an administrator. This page is limited to administrator access.");
            res.setContentType("text/html");
            this.render("/templates/security-breach.vm", context, res);
        }
    }

    public String getBannerType(NotificationCacheEntry notificationCacheEntry) {
        return DisplayTypeHolder.getBannerType(notificationCacheEntry.getDisplayType());
    }

    public String format(Notification notification) {
        return this.formatService.formatThis(notification.getFormat(), AnnouncerHelper.handleVars(this.licenseCounter, notification.getHtml()));
    }

    public String format(NotificationBean notification) {
        return this.formatService.formatThis(notification.getFormat(), AnnouncerHelper.handleVars(this.licenseCounter, notification.getHtml()));
    }

    public String getCheckLicense() {
        if (this.licenseStorageManager.getLicense().isDefined()) {
            PluginLicense pluginLicense = (PluginLicense)this.licenseStorageManager.getLicense().get();
            if (pluginLicense.getError().isDefined()) {
                if (((LicenseError)pluginLicense.getError().get()).name().equals("EXPIRED")) {
                    return "The evaluation license has expired. Please contact your System administrator";
                }
                return "An error occurred while validating your license for this plugin: " + ((LicenseError)pluginLicense.getError().get()).name();
            }
            return null;
        }
        return "Plugin is not licensed. In order to evaluate this plugin you need to create an evaluation license";
    }

    protected void render(String template, Map<String, Object> context, HttpServletResponse response) throws IOException {
        this.templateRenderer.render(template, context, (Writer)response.getWriter());
    }

    public String getDialogHeight() {
        String value = (String)this.pluginSettingsFactory.createGlobalSettings().get("wittified.announcer.dialog.height");
        if (value == null) {
            return "500";
        }
        if (value.equals("")) {
            return "500";
        }
        return value;
    }

    public class PreviewNotification {
        private String displayType = "";
        private String buttonText = "";
        private String html = "";
        private String title = "";
        private String description = "";
        private int format = -1;
        private boolean isRequired = false;
        private String type;

        public void setButtonText(String buttonText) {
            this.buttonText = buttonText;
        }

        public String getButtonText() {
            return this.buttonText;
        }

        public String getHtml() {
            return this.html;
        }

        public void setHtml(String html) {
            this.html = html;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public int getFormat() {
            return this.format;
        }

        public void setFormat(int format) {
            this.format = format;
        }

        public boolean getIsRequired() {
            return this.isRequired;
        }

        public void setIsRequired(boolean required) {
            this.isRequired = required;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getDisplayType() {
            return this.displayType;
        }

        public void setDisplayType(String displayType) {
            this.displayType = displayType;
        }

        public boolean isRequired() {
            return this.isRequired;
        }

        public void setRequired(boolean isRequired) {
            this.isRequired = isRequired;
        }
    }
}

