/*
 * Decompiled with CFR 0.152.
 */
package com.wittified.rest;

import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.wittified.AnnouncerHelper;
import com.wittified.RecurrenceType;
import com.wittified.analytics.AnnouncerAnalytics;
import com.wittified.analytics.EventType;
import com.wittified.ao.AnnouncerDataService;
import com.wittified.ao.Notification;
import com.wittified.ao.NotificationService;
import com.wittified.job.RecurringAnnouncementScheduler;
import com.wittified.licensecounters.LicenseCounter;
import com.wittified.rest.dto.CustomRecurrenceDTO;
import com.wittified.rest.dto.CustomWeekRecurrenceDTO;
import com.wittified.rest.dto.DailyRecurrenceDTO;
import com.wittified.rest.dto.NotificationUpsertDTO;
import com.wittified.rest.dto.RecurrenceDTO;
import com.wittified.rest.dto.SelectiveWeekRecurrenceDTO;
import com.wittified.services.InvalidNotificationServiceImpl;
import com.wittified.services.TokenChangeService;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.DayOfWeek;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.WeakHashMap;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/admin")
public class NotificationEndPoint {
    private final NotificationService notificationService;
    private final UserManager userManager;
    private final LicenseCounter licenseCounter;
    private final Logger logger = LoggerFactory.getLogger(NotificationEndPoint.class);
    private final AnnouncerAnalytics announcerAnalytics;
    private final RecurringAnnouncementScheduler recurringAnnouncementScheduler;
    private final AnnouncerDataService announcerDataService;
    private final TokenChangeService tokenChangeService;
    private final InvalidNotificationServiceImpl invalidNotificationService;

    public NotificationEndPoint(NotificationService notificationService, UserManager userManager, LicenseCounter licenseCounter, AnnouncerAnalytics announcerAnalytics, RecurringAnnouncementScheduler recurringAnnouncementScheduler, AnnouncerDataService announcerDataService, TokenChangeService tokenChangeService, InvalidNotificationServiceImpl invalidNotificationService) {
        this.notificationService = notificationService;
        this.userManager = userManager;
        this.licenseCounter = licenseCounter;
        this.announcerAnalytics = announcerAnalytics;
        this.recurringAnnouncementScheduler = recurringAnnouncementScheduler;
        this.announcerDataService = announcerDataService;
        this.tokenChangeService = tokenChangeService;
        this.invalidNotificationService = invalidNotificationService;
    }

    @Path(value="/delete/{id}")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response deleteThisNotification(@PathParam(value="id") String idStr, Map<String, String> data) {
        this.logger.debug(String.format("Deleting notification %s", idStr));
        UserKey userkey = this.userManager.getRemoteUserKey();
        Notification notification = this.notificationService.getThisNotification(Integer.parseInt(idStr));
        if (notification != null) {
            if (!this.userManager.isAdmin(userkey)) {
                boolean blocked = true;
                if (notification.getFilterProject()) {
                    String pKey = notification.getTargetProject();
                    if (pKey != null) {
                        pKey = pKey.replaceAll(":", "");
                    }
                    if (notification.getTargetProject().contains(pKey) && this.licenseCounter.currentUserCanEdit(pKey)) {
                        blocked = false;
                    }
                }
                if (blocked) {
                    return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
                }
            }
            WeakHashMap<String, Object> eventDataMap = new WeakHashMap<String, Object>();
            eventDataMap.put("type", EventType.ANNOUNCEMENT_DELETED.toString());
            eventDataMap.put("Operation", EventType.ANNOUNCEMENT_DELETED.toString());
            this.announcerAnalytics.postEventInfo(EventType.ANNOUNCEMENT_DELETED, eventDataMap);
            this.notificationService.deleteNotification(notification);
            if (notification.getCustomRecurrenceOption()) {
                this.logger.debug(String.format("Stopping scheduled job for notification %s", notification.getTitle()));
                this.recurringAnnouncementScheduler.unscheduleJob(notification);
            }
        } else {
            this.logger.debug("This notification does not exist");
            return Response.ok().build();
        }
        return Response.ok(data).build();
    }

    @Path(value="/reset/{id}")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response resetThisNotification(@PathParam(value="id") Integer id, Map<String, String> data) {
        this.logger.debug(String.format("Resetting notification %s", id));
        UserKey userkey = this.userManager.getRemoteUserKey();
        Notification notification = this.notificationService.getThisNotification(id);
        if (!this.userManager.isAdmin(userkey)) {
            boolean blocked = true;
            if (notification.getFilterProject()) {
                String pKey = notification.getTargetProject();
                if (pKey != null) {
                    pKey = pKey.replaceAll(":", "");
                }
                if (notification.getTargetProject().contains(pKey) && this.licenseCounter.currentUserCanEdit(pKey)) {
                    blocked = false;
                }
            }
            if (blocked) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
        }
        this.notificationService.resetNotification(notification);
        return Response.ok(data).build();
    }

    @Path(value="/enable-all")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response enableAllNotification(Map<String, String> data) {
        this.logger.debug(String.format("Enabling all notifications", new Object[0]));
        UserKey userkey = this.userManager.getRemoteUserKey();
        if (!this.userManager.isAdmin(userkey)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        for (Notification notification : this.notificationService.getAllNotifications()) {
            notification.setActive(true);
            this.notificationService.saveNotification(notification);
        }
        return Response.ok(data).build();
    }

    @Path(value="/notifications/status")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateNotificationStatus(ArrayList<Map<String, Boolean>> data) {
        this.logger.debug(String.format("Enabling/Disabling specified notifications", new Object[0]));
        UserKey userkey = this.userManager.getRemoteUserKey();
        if (!this.userManager.isAdmin(userkey)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        for (Map<String, Boolean> notificationMap : data) {
            Set<String> notificationIds = notificationMap.keySet();
            for (String key : notificationIds) {
                Notification notification = this.notificationService.getThisNotification(Integer.parseInt(key));
                if (notification == null) continue;
                if (notificationMap.get(key).booleanValue()) {
                    notification.setActive(true);
                } else {
                    notification.setActive(false);
                }
                this.deriveTempActiveStatus(notification, notification.getRunningTypeOption(), notification.getRecurringTypeOption());
                this.notificationService.saveNotification(notification);
            }
        }
        return Response.ok(data).build();
    }

    @Path(value="/all-groups")
    @GET
    @Produces(value={"application/json"})
    public Response getAllGroups() {
        this.logger.debug(String.format("Getting all groups", new Object[0]));
        UserKey userKey = this.userManager.getRemoteUserKey();
        if (userKey == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        ArrayList<String> groups = new ArrayList<String>();
        if (this.userManager.isAdmin(userKey)) {
            for (String group : this.userManager.findGroupNamesByPrefix("", 0, 1000)) {
                groups.add(group);
            }
        } else {
            for (String group : this.userManager.findGroupNamesByPrefix("", 0, 1000)) {
                if (!this.userManager.isUserInGroup(userKey, group)) continue;
                groups.add(group);
            }
        }
        return Response.ok(groups).build();
    }

    @Path(value="/is-user-admin")
    @GET
    @Produces(value={"application/json"})
    public Response isCurrentUserAnAdmin() {
        UserKey userKey = this.userManager.getRemoteUserKey();
        HashMap<String, String> map = new HashMap<String, String>();
        if (userKey != null && this.userManager.isAdmin(userKey)) {
            map.put("isAdmin", "true");
        } else {
            map.put("isAdmin", "false");
        }
        return Response.ok(map).build();
    }

    @Path(value="/notifications/")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getAllNotifications() throws JSONException {
        this.logger.debug(String.format("getting all notifications using REST API", new Object[0]));
        UserKey userkey = this.userManager.getRemoteUserKey();
        if (!this.userManager.isAdmin(userkey)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        List<Notification> notificationsV2 = this.announcerDataService.getAllNotificationsV2();
        ArrayList notifications = new ArrayList();
        for (Notification notiff : notificationsV2) {
            HashMap<String, Object> notificationsMap = new HashMap<String, Object>();
            notificationsMap.put("active", String.valueOf(notiff.getActive()));
            notificationsMap.put("button_text", String.valueOf(notiff.getButtonText()));
            notificationsMap.put("delay_button", String.valueOf(notiff.getDelayButton()));
            notificationsMap.put("display", String.valueOf(notiff.getDisplay()));
            notificationsMap.put("format", String.valueOf(notiff.getFormat()));
            notificationsMap.put("contents", String.valueOf(notiff.getHtml()));
            notificationsMap.put("reset_button", String.valueOf(notiff.getResetButton()));
            notificationsMap.put("show_button", String.valueOf(notiff.getShowButton()));
            notificationsMap.put("title", String.valueOf(notiff.getTitle()));
            notificationsMap.put("type", String.valueOf(notiff.getType()));
            notificationsMap.put("anonymous", String.valueOf(notiff.getAnonymous()));
            notificationsMap.put("is_required", String.valueOf(notiff.getIsRequired()));
            notificationsMap.put("id", String.valueOf(notiff.getID()));
            notificationsMap.put("temp_active", String.valueOf(notiff.getTempActive()));
            notificationsMap.put("total_anon_dwell", String.valueOf(notiff.getTotalAnonDwell()));
            notificationsMap.put("num_anon", String.valueOf(notiff.getNumAnon()));
            notificationsMap.put("date_restrict", String.valueOf(notiff.getDateRestrict()));
            notificationsMap.put("description", String.valueOf(notiff.getDescription()));
            notificationsMap.put("filter_groups", String.valueOf(notiff.getFilterGroups()));
            notificationsMap.put("filter_project", String.valueOf(notiff.getFilterProject()));
            notificationsMap.put("target_project", Arrays.toString(this.convertProjectKeysToArray(notiff.getTargetProject())));
            notificationsMap.put("group_target", String.valueOf(notiff.getGroupTarget()));
            notificationsMap.put("filter_user", String.valueOf(notiff.getFilterUser()));
            notificationsMap.put("target_user", Arrays.toString(this.convertTargetedUsersToArray(notiff.getTargetUser())));
            try {
                if (notiff.getDateRestrict().booleanValue()) {
                    HashMap<String, Object> recurrenceMap = new HashMap<String, Object>();
                    DateTimeFormatter currentFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.S");
                    DateTimeFormatter requiredFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
                    LocalDateTime startDateTime = LocalDateTime.parse(notiff.getStartDate().toString(), currentFormat);
                    LocalDateTime endDateTime = LocalDateTime.parse(notiff.getEndDate().toString(), currentFormat);
                    String formattedStartDateTime = startDateTime.format(requiredFormat);
                    String formattedEndDateTime = endDateTime.format(requiredFormat);
                    recurrenceMap.put("fromDateTime", formattedStartDateTime);
                    recurrenceMap.put("toDateTime", formattedEndDateTime);
                    if (notiff.getCustomRecurrenceOption()) {
                        HashMap customRecurrenceMap = new HashMap();
                        if (notiff.getRunningTypeOption()) {
                            HashMap<String, Object> dailyRecurrenceMap = new HashMap<String, Object>();
                            dailyRecurrenceMap.put("frequencyType", notiff.getRunningType());
                            dailyRecurrenceMap.put("duration", notiff.getRunningFreq());
                            customRecurrenceMap.put("dailyRecurrence", dailyRecurrenceMap);
                        } else if (notiff.getRecurringTypeOption()) {
                            HashMap<String, Object> selectiveWeekRecurrenceMap = new HashMap<String, Object>();
                            selectiveWeekRecurrenceMap.put("recurrenceType", notiff.getRecurringType());
                            if (notiff.getRecurringType().equals("weekly")) {
                                selectiveWeekRecurrenceMap.put("recurrenceDay", this.convertNumericToDay(notiff.getDayOfWeek(), true));
                            } else if (notiff.getRecurringType().equals("monthly")) {
                                selectiveWeekRecurrenceMap.put("recurrenceDay", notiff.getDayOfMonth());
                            }
                            customRecurrenceMap.put("selectiveWeekRecurrence", selectiveWeekRecurrenceMap);
                        } else if (notiff.getRecurringWeeklyType().booleanValue()) {
                            HashMap<String, String> customWeekRecurrence = new HashMap<String, String>();
                            customWeekRecurrence.put("fromHours", notiff.getWeeklyStartTime());
                            customWeekRecurrence.put("toHours", notiff.getWeeklyEndTime());
                            customWeekRecurrence.put("weekdays", String.valueOf(this.convertNumericToDayFormat(notiff.getSelectedDays(), false)));
                            customRecurrenceMap.put("customWeekRecurrence", customWeekRecurrence);
                        }
                        recurrenceMap.put("customRecurrence", customRecurrenceMap);
                    }
                    notificationsMap.put("recurrence", recurrenceMap);
                }
            }
            catch (Exception e) {
                this.logger.debug("Error while populating notification data to JSON Response object for GET Request " + e.getMessage());
            }
            notifications.add(notificationsMap);
        }
        this.logger.debug("JSON Response created successfully for GET Request");
        return Response.ok(notifications).build();
    }

    @Path(value="/notifications/")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createNotification(List<NotificationUpsertDTO> notificationDTOArray) {
        this.logger.debug(String.format("Creating notifications using REST API", new Object[0]));
        LocalDateTime currentDateTime = LocalDateTime.now();
        if (!AnnouncerHelper.isAdminUser(this.userManager)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        this.logger.debug("Calling Validation function...");
        for (NotificationUpsertDTO notificationDTO : notificationDTOArray) {
            try {
                this.validateRequestData(notificationDTO, currentDateTime);
            }
            catch (RuntimeException e) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
            }
        }
        this.logger.debug("Building notification for Create Notification POST Request...");
        for (NotificationUpsertDTO notificationDTO : notificationDTOArray) {
            try {
                Notification notification = this.notificationService.createNewNotification();
                this.buildNotification(notification, notificationDTO);
                this.notificationService.saveNotification(notification);
                notificationDTO.setId(String.valueOf(notification.getID()));
            }
            catch (Exception e) {
                this.logger.debug("Error while building and saving notification " + e.getMessage());
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
            }
        }
        return Response.ok(notificationDTOArray).build();
    }

    @Path(value="/notifications/{id}")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateNotification(@PathParam(value="id") String id, NotificationUpsertDTO notificationDTO) {
        this.logger.debug(String.format("updating notification: %s", id));
        LocalDateTime currentDateTime = LocalDateTime.now();
        UserKey userkey = this.userManager.getRemoteUserKey();
        if (!this.userManager.isAdmin(userkey)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        Notification notification = this.notificationService.getThisNotification(Integer.parseInt(id));
        if (notification == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        this.logger.debug("Calling Validation function...");
        try {
            this.validateRequestData(notificationDTO, currentDateTime);
        }
        catch (RuntimeException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
        try {
            this.logger.debug("Building and saving notification for REST PUT Request...");
            this.buildNotification(notification, notificationDTO);
            this.notificationService.saveNotification(notification);
        }
        catch (Exception e) {
            this.logger.debug("Error while saving and building notification " + e.getMessage());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
        this.logger.debug(String.format("updated notification: %s", id));
        notificationDTO.setId(id);
        return Response.ok((Object)notificationDTO).build();
    }

    private void buildNotification(Notification notification, NotificationUpsertDTO notificationDTO) throws Exception {
        this.logger.debug("Building notification...");
        notification.setTitle(notificationDTO.getTitle());
        notification.setDescription(notificationDTO.getDescription());
        notification.setType(notificationDTO.getType());
        notification.setButtonText(notificationDTO.getButtonText());
        notification.setDisplay(Integer.parseInt(notificationDTO.getDisplayType()));
        notification.setActive(Boolean.parseBoolean(notificationDTO.getIsActive()));
        notification.setTempActive(notification.getActive());
        notification.setHtml(notificationDTO.getContents());
        notification.setDelayButton(Boolean.parseBoolean(notificationDTO.getDelayButton()));
        notification.setAnonymous(Boolean.parseBoolean(notificationDTO.getAnonymous()));
        notification.setShowButton(Boolean.valueOf(notificationDTO.getShowButton()));
        notification.setFormat(Integer.parseInt(notificationDTO.getFormat()));
        notification.setFilterGroups(Boolean.parseBoolean(notificationDTO.getFilterGroups()) && StringUtils.isNotBlank(notificationDTO.getTargetGroup()));
        notification.setGroupTarget(notification.getFilterGroups() && StringUtils.isNotEmpty(notificationDTO.getTargetGroup()) ? notificationDTO.getTargetGroup().replace(" ", "") : null);
        notification.setFilterProject(notificationDTO.getFilterProjects() && notificationDTO.getTargetProject() != null && !notificationDTO.getTargetProject().isEmpty());
        notification.setTargetProject(notificationDTO.getTargetProject() != null && !notificationDTO.getTargetProject().isEmpty() ? this.formatProjectKeys(notificationDTO.getTargetProject()) : null);
        notification.setFilterUser(notificationDTO.getFilterUser() && CollectionUtils.isNotEmpty(notificationDTO.getTargetUser()));
        notification.setTargetUser(notification.getFilterUser() && CollectionUtils.isNotEmpty(notificationDTO.getTargetUser()) ? this.formatTargetedUser(notificationDTO.getTargetUser()) : null);
        boolean isDateRestrict = false;
        long startTime = -1L;
        long endTime = -1L;
        boolean isCustomRecurrence = false;
        boolean isRunningType = false;
        String runningType = "";
        int runningFreq = 1;
        boolean isRecurringType = false;
        String recurringType = "";
        int recurringDay = 1;
        boolean isRecurringWeeklyType = false;
        String selectedDays = "";
        String weeklyStartTime = "";
        String weeklyEndTime = "";
        if (notificationDTO.getRecurrence() != null) {
            isDateRestrict = true;
            RecurrenceDTO recurrenceDTO = notificationDTO.getRecurrence();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
            dateFormat.setTimeZone(TimeZone.getDefault());
            try {
                startTime = dateFormat.parse(recurrenceDTO.getFromDateTime()).getTime();
            }
            catch (ParseException e) {
                throw new Exception(e.getMessage());
            }
            if (recurrenceDTO.isRunIndefinitely()) {
                endTime = Long.parseLong("253402108200000");
            } else {
                try {
                    endTime = dateFormat.parse(recurrenceDTO.getToDateTime()).getTime();
                }
                catch (ParseException e) {
                    throw new Exception(e.getMessage());
                }
            }
            if (recurrenceDTO.getCustomRecurrence() != null) {
                isCustomRecurrence = true;
                CustomRecurrenceDTO customRecurrenceDTO = recurrenceDTO.getCustomRecurrence();
                if (customRecurrenceDTO.getDailyRecurrence() != null) {
                    isRunningType = true;
                    DailyRecurrenceDTO dailyRecurrenceDTO = customRecurrenceDTO.getDailyRecurrence();
                    runningType = dailyRecurrenceDTO.getFrequencyType();
                    runningFreq = dailyRecurrenceDTO.getDuration();
                } else if (customRecurrenceDTO.getSelectiveWeekRecurrence() != null) {
                    isRecurringType = true;
                    SelectiveWeekRecurrenceDTO selectiveWeekRecurrenceDTO = customRecurrenceDTO.getSelectiveWeekRecurrence();
                    recurringType = selectiveWeekRecurrenceDTO.getRecurrenceType();
                    if (StringUtils.equals(recurringType, "weekly")) {
                        recurringDay = this.convertDayToNumeric(selectiveWeekRecurrenceDTO.getRecurrenceDay(), true);
                    } else if (StringUtils.equals(recurringType, "monthly")) {
                        recurringDay = Integer.parseInt(selectiveWeekRecurrenceDTO.getRecurrenceDay());
                    } else if (StringUtils.equals(recurringType.toLowerCase(), "lastDayOfMonth".toLowerCase())) {
                        recurringType = "lastDayOfMonth";
                    }
                } else if (customRecurrenceDTO.getCustomWeekRecurrence() != null) {
                    isRecurringWeeklyType = true;
                    CustomWeekRecurrenceDTO customWeekRecurrenceDTO = customRecurrenceDTO.getCustomWeekRecurrence();
                    selectedDays = this.convertDayToNumericFormat(customWeekRecurrenceDTO.getWeekdays(), false);
                    weeklyStartTime = customWeekRecurrenceDTO.getFromHours();
                    weeklyEndTime = customWeekRecurrenceDTO.getToHours();
                }
            }
        }
        notification.setDateRestrict(isDateRestrict);
        notification.setStartDate(new Date(startTime));
        notification.setEndDate(new Date(endTime));
        notification.setCustomRecurrenceOption(isCustomRecurrence);
        notification.setRunningTypeOption(isRunningType);
        notification.setRunningType(runningType);
        notification.setRunningFreq(runningFreq);
        notification.setRecurringTypeOption(isRecurringType);
        notification.setRecurringType(recurringType);
        notification.setDayOfWeek(recurringDay);
        notification.setDayOfMonth(recurringDay);
        notification.setRecurringWeeklyType(isRecurringWeeklyType);
        notification.setWeeklyStartTime(weeklyStartTime);
        notification.setWeeklyEndTime(weeklyEndTime);
        notification.setSelectedDays(selectedDays);
        this.deriveTempActiveStatus(notification, isRunningType, isRecurringType);
        if (isCustomRecurrence) {
            String id = String.valueOf(notification.getID());
            String cronExpression = AnnouncerHelper.generateCronExpression(notification, startTime);
            System.out.println("cron expression in API " + cronExpression);
            if (id.equals("-1")) {
                this.logger.debug("** New notification is being created from REST API which is of custom recurrence type ** ");
                this.logger.debug(String.format("** Scheduling a recurring job with cron %s ", cronExpression));
                this.recurringAnnouncementScheduler.schedule(cronExpression, notification);
                System.out.println("scheduled new job in API");
                this.logger.debug("** Recurring Job Scheduled **");
            } else {
                this.logger.debug("** Existing notification is being created from REST API which is of custom recurrence type ** ");
                this.logger.debug(String.format("** Scheduling a recurring job with cron %s ", cronExpression));
                this.recurringAnnouncementScheduler.reschedule(cronExpression, notification);
                System.out.println("scheduled old job in API");
                this.logger.debug("** Recurring Job Scheduled **");
            }
        }
        this.logger.debug("Notification successfully build...");
    }

    @Path(value="/notifications/{id}")
    @DELETE
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response deleteNotification(@PathParam(value="id") String idStr) {
        this.logger.debug(String.format("Deleting notification %s", idStr));
        UserKey userkey = this.userManager.getRemoteUserKey();
        Notification notification = this.notificationService.getThisNotification(Integer.parseInt(idStr));
        if (notification != null) {
            if (!this.userManager.isAdmin(userkey)) {
                boolean blocked = true;
                if (notification.getFilterProject()) {
                    String pKey = notification.getTargetProject();
                    if (pKey != null) {
                        pKey = pKey.replaceAll(":", "");
                    }
                    if (notification.getTargetProject().contains(pKey) && this.licenseCounter.currentUserCanEdit(pKey)) {
                        blocked = false;
                    }
                }
                if (blocked) {
                    return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
                }
            }
            WeakHashMap<String, Object> eventDataMap = new WeakHashMap<String, Object>();
            eventDataMap.put("type", EventType.ANNOUNCEMENT_DELETED.toString());
            eventDataMap.put("Operation", EventType.ANNOUNCEMENT_DELETED.toString());
            this.announcerAnalytics.postEventInfo(EventType.ANNOUNCEMENT_DELETED, eventDataMap);
            this.notificationService.deleteNotification(notification);
            if (notification.getCustomRecurrenceOption()) {
                this.logger.debug(String.format("Stopping scheduled job for notification %s", notification.getTitle()));
                this.recurringAnnouncementScheduler.unscheduleJob(notification);
            }
        } else {
            this.logger.debug("This notification does not exist");
            return Response.ok((Object)Response.Status.NOT_FOUND).build();
        }
        return Response.ok((Object)String.format("Deleted notification %s", idStr)).build();
    }

    private String formatProjectKeys(List<String> projectKeys) {
        if (projectKeys == null || projectKeys.isEmpty()) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String key : projectKeys) {
            stringBuilder.append(":");
            stringBuilder.append(key);
            stringBuilder.append(":");
        }
        return stringBuilder.toString();
    }

    private String[] convertProjectKeysToArray(String projectKeys) {
        if (projectKeys == null || StringUtils.isEmpty(projectKeys)) {
            return null;
        }
        String keys = projectKeys.replaceAll("^:|:$", "");
        return keys.split("::");
    }

    private void validateRequestData(NotificationUpsertDTO notificationDTO, LocalDateTime currentDateTime) throws RuntimeException {
        String invalidProjectsGroups;
        String notificationTitle = notificationDTO.getTitle();
        if (notificationDTO.getFilterUser()) {
            if (Boolean.parseBoolean(notificationDTO.getAnonymous()) || Boolean.parseBoolean(notificationDTO.getFilterGroups()) || notificationDTO.getFilterProjects()) {
                throw new RuntimeException("Validation failed for notification '" + notificationTitle + "': Additional filters cannot be applied when filtering users.");
            }
            String invalidUser = this.getInvalidUser(notificationDTO.getTargetUser());
            if (invalidUser != null) {
                throw new RuntimeException("Validation failed for notification '" + notificationTitle + "': The specified target user '" + invalidUser + "' does not exist.");
            }
        }
        if ((invalidProjectsGroups = this.invalidNotificationService.getMissedTargetGroups(Boolean.parseBoolean(notificationDTO.getFilterGroups()), notificationDTO.getTargetGroup())) != null && StringUtils.isNoneBlank(invalidProjectsGroups)) {
            throw new RuntimeException("Validation failed for notification '" + notificationTitle + "': '" + invalidProjectsGroups + "' are not valid groups.");
        }
        invalidProjectsGroups = this.invalidNotificationService.getMissedTargetProjects(notificationDTO.getFilterProjects(), this.formatProjectKeys(notificationDTO.getTargetProject()));
        if (invalidProjectsGroups != null && StringUtils.isNoneBlank(invalidProjectsGroups)) {
            throw new RuntimeException("Validation failed for notification '" + notificationTitle + "': '" + invalidProjectsGroups + "' are not valid project keys.");
        }
        if (notificationDTO.getRecurrence() == null) {
            return;
        }
        RecurrenceDTO recurrenceDTO = notificationDTO.getRecurrence();
        LocalDateTime startDateTime = null;
        LocalDateTime endDateTime = null;
        boolean isRunIndefinitely = recurrenceDTO.isRunIndefinitely();
        if (recurrenceDTO.getFromDateTime() == null) {
            throw new RuntimeException("Validation failed for notification '" + notificationTitle + "': fromDateTime field is required.");
        }
        if (BooleanUtils.isNotTrue(isRunIndefinitely) && recurrenceDTO.getToDateTime() == null) {
            throw new RuntimeException("Validation failed for notification '" + notificationTitle + "': toDateTime field is required.");
        }
        try {
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
            startDateTime = LocalDateTime.parse(recurrenceDTO.getFromDateTime(), dateTimeFormatter);
            if (BooleanUtils.isNotTrue(isRunIndefinitely)) {
                endDateTime = LocalDateTime.parse(recurrenceDTO.getToDateTime(), dateTimeFormatter);
            }
        }
        catch (DateTimeParseException e) {
            throw new RuntimeException("Validation failed for notification '" + notificationTitle + "': Please enter date in correct format e.g. 'yyyy-MM-dd HH:mm'");
        }
        if (startDateTime.isBefore(currentDateTime)) {
            throw new RuntimeException("Validation failed for notification '" + notificationTitle + "': Start date and time cannot be in the past.");
        }
        if (BooleanUtils.isNotTrue(isRunIndefinitely) && (endDateTime == null || endDateTime.isBefore(startDateTime))) {
            throw new RuntimeException("Validation failed for notification '" + notificationTitle + "': End date and time cannot be before Start date and time.");
        }
        if (recurrenceDTO.getCustomRecurrence() != null) {
            CustomRecurrenceDTO customRecurrenceDTO = recurrenceDTO.getCustomRecurrence();
            DailyRecurrenceDTO dailyRecurrenceDTO = customRecurrenceDTO.getDailyRecurrence();
            SelectiveWeekRecurrenceDTO selectiveWeekRecurrenceDTO = customRecurrenceDTO.getSelectiveWeekRecurrence();
            CustomWeekRecurrenceDTO customWeekRecurrenceDTO = customRecurrenceDTO.getCustomWeekRecurrence();
            if (dailyRecurrenceDTO != null && selectiveWeekRecurrenceDTO != null || selectiveWeekRecurrenceDTO != null && customWeekRecurrenceDTO != null || dailyRecurrenceDTO != null && customWeekRecurrenceDTO != null) {
                throw new RuntimeException("Validation failed for notification '" + notificationTitle + "': Only one or none of the custom recurrence options should be selected.");
            }
            if (dailyRecurrenceDTO != null) {
                String frequencyType = dailyRecurrenceDTO.getFrequencyType();
                int duration = dailyRecurrenceDTO.getDuration();
                if (duration <= 0) {
                    throw new RuntimeException("Validation failed for notification '" + notificationTitle + "': Daily Recurrence duration must be a number greater than 0.");
                }
                if (!(StringUtils.equalsIgnoreCase(frequencyType, "days") || StringUtils.equalsIgnoreCase(frequencyType, "weeks") || StringUtils.equalsIgnoreCase(frequencyType, "months"))) {
                    throw new RuntimeException("Validation failed for notification '" + notificationTitle + "': Daily Recurrence frequency type must be either 'days', 'weeks', or 'months'.");
                }
            } else if (selectiveWeekRecurrenceDTO != null) {
                String recurrenceType = selectiveWeekRecurrenceDTO.getRecurrenceType();
                String recurrenceDay = selectiveWeekRecurrenceDTO.getRecurrenceDay();
                switch (recurrenceType.toLowerCase()) {
                    case "weekly": {
                        try {
                            DayOfWeek.valueOf(recurrenceDay.toUpperCase());
                            break;
                        }
                        catch (IllegalArgumentException e) {
                            throw new RuntimeException("Validation failed for notification '" + notificationTitle + "': Invalid day for weekly recurrence.");
                        }
                    }
                    case "monthly": {
                        try {
                            int dayOfMonth = Integer.parseInt(recurrenceDay);
                            if (dayOfMonth < 1 || dayOfMonth > 31) {
                                throw new RuntimeException("Validation failed for notification '" + notificationTitle + "': Invalid day for monthly recurrence: must be between 1 and 31.");
                            }
                            break;
                        }
                        catch (NumberFormatException e) {
                            throw new RuntimeException("Validation failed for notification '" + notificationTitle + "': Invalid day format for monthly recurrence: must be a number.");
                        }
                    }
                    case "lastdayofmonth": {
                        break;
                    }
                    default: {
                        throw new RuntimeException("Validation failed for notification '" + notificationTitle + "': Invalid recurrence type.");
                    }
                }
            } else if (customWeekRecurrenceDTO != null) {
                String weeklyStartTime = customWeekRecurrenceDTO.getFromHours();
                String weeklyEndTime = customWeekRecurrenceDTO.getToHours();
                List<String> weekDays = customWeekRecurrenceDTO.getWeekdays();
                if (weeklyStartTime == null || weeklyEndTime == null) {
                    throw new RuntimeException("Validation failed for notification '" + notificationTitle + "': fromHours and toHours fields are required.");
                }
                if (weekDays == null || weekDays.isEmpty()) {
                    throw new RuntimeException("Validation failed for notification '" + notificationTitle + "': weekdays field cannot be empty.");
                }
                DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("HH:mm");
                try {
                    LocalTime.parse(weeklyStartTime, dateTimeFormatter);
                    LocalTime.parse(weeklyEndTime, dateTimeFormatter);
                }
                catch (DateTimeParseException e) {
                    throw new RuntimeException("Validation failed for notification '" + notificationTitle + "': Please enter time in correct format e.g. 'HH:mm'");
                }
                for (String day : weekDays) {
                    try {
                        DayOfWeek.valueOf(day.toUpperCase());
                    }
                    catch (IllegalArgumentException e) {
                        throw new RuntimeException("Validation failed for notification '" + notificationTitle + "': Invalid week day for custom weekly recurrence.");
                    }
                }
            }
        }
    }

    private String convertDayToNumericFormat(List<String> days, boolean isSelective) {
        StringBuilder formattedWeekDays = new StringBuilder();
        for (String day : days) {
            int index = this.convertDayToNumeric(day, isSelective);
            formattedWeekDays.append(index).append("#");
        }
        if (formattedWeekDays.length() > 0) {
            formattedWeekDays.setLength(formattedWeekDays.length() - 1);
        }
        return formattedWeekDays.toString();
    }

    private int convertDayToNumeric(String day, boolean isSelective) {
        switch (day.toLowerCase()) {
            case "sunday": {
                return isSelective ? 7 : 1;
            }
            case "monday": {
                return isSelective ? 1 : 2;
            }
            case "tuesday": {
                return isSelective ? 2 : 3;
            }
            case "wednesday": {
                return isSelective ? 3 : 4;
            }
            case "thursday": {
                return isSelective ? 4 : 5;
            }
            case "friday": {
                return isSelective ? 5 : 6;
            }
            case "saturday": {
                return isSelective ? 6 : 7;
            }
        }
        return 1;
    }

    private List<String> convertNumericToDayFormat(String weekDays, boolean isSelective) {
        String[] dayArray = weekDays.split("#");
        ArrayList<String> weekDaysArray = new ArrayList<String>();
        for (String dayIndex : dayArray) {
            weekDaysArray.add(this.convertNumericToDay(Integer.parseInt(dayIndex), isSelective));
        }
        return weekDaysArray;
    }

    private String convertNumericToDay(int dayIndex, boolean isSelective) {
        String[] week = new String[]{"sunday", "monday", "tuesday", "wednesday", "thursday", "friday", "saturday"};
        if (isSelective) {
            return dayIndex == 7 ? week[0] : week[dayIndex];
        }
        return week[dayIndex - 1];
    }

    public String getInvalidUser(List<String> usernames) {
        String invalidUser = null;
        for (String username : usernames) {
            if (this.userManager.getUserProfile(username) != null) continue;
            this.logger.debug("REST: No such user with username '" + username + "' exists.");
            invalidUser = username;
            break;
        }
        return invalidUser;
    }

    public String formatTargetedUser(List<String> usernames) {
        StringBuilder targetedUsers = new StringBuilder();
        for (String username : usernames) {
            UserProfile user = this.userManager.getUserProfile(username);
            if (user == null) continue;
            targetedUsers.append(user.getUserKey().getStringValue()).append(":").append(username).append(",");
        }
        if (targetedUsers.length() > 0) {
            targetedUsers.setLength(targetedUsers.length() - 1);
        }
        return targetedUsers.toString();
    }

    public String[] convertTargetedUsersToArray(String targetedUsers) {
        if (StringUtils.isBlank(targetedUsers)) {
            return null;
        }
        String[] users = targetedUsers.split(",");
        String[] usernames = new String[users.length];
        for (int i = 0; i < users.length; ++i) {
            String username;
            String[] userParts = users[i].split(":");
            if (userParts.length <= 1) continue;
            usernames[i] = username = userParts[1].trim();
        }
        return usernames;
    }

    public void deriveTempActiveStatus(Notification notification, boolean isRunningType, boolean isRecurringType) {
        if (notification == null) {
            return;
        }
        if (notification.getActive()) {
            if (BooleanUtils.isTrue(notification.getDateRestrict())) {
                Date currentDate = new Date();
                if (isRunningType) {
                    notification.setTempActive(currentDate.compareTo(notification.getStartDate()) > -1);
                } else if (isRecurringType) {
                    boolean isTempActive = this.notificationService.isActiveNotification(notification, RecurrenceType.RECURRING, currentDate);
                    notification.setTempActive(isTempActive);
                } else {
                    notification.setTempActive(currentDate.compareTo(notification.getStartDate()) > -1 && currentDate.compareTo(notification.getEndDate()) < 1);
                }
                this.tokenChangeService.updateToken();
            } else {
                notification.setTempActive(true);
            }
        } else if (!notification.getActive()) {
            notification.setTempActive(false);
        }
    }
}

