/*
 * Decompiled with CFR 0.152.
 */
package com.wittified.xwork;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.jira.web.action.ProjectActionSupport;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.wittified.ao.NotificationService;
import com.wittified.general.support.SupportBarService;
import com.wittified.licensecounters.LicenseCounter;
import com.wittified.rest.dto.NotificationCount;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SupportedMethods(value={RequestMethod.GET})
public class JiraProjectAction
extends ProjectActionSupport {
    private static final Logger logger = LoggerFactory.getLogger(JiraProjectAction.class);
    private final ProjectManager projectManager;
    private WebResourceManager webResourceManager;
    private LicenseCounter licenseCounter;
    private PluginLicenseManager licenseStorageManager;
    private NotificationService notificationService;
    private final SupportBarService supportBarService;
    private String projectKey;
    private Map<String, Object> context = null;

    public JiraProjectAction(ProjectManager projectManager, WebResourceManager webResourceManager, LicenseCounter licenseCounter, PluginLicenseManager licenseStorageManager, NotificationService notificationService, SupportBarService supportBarService) {
        this.projectManager = projectManager;
        this.webResourceManager = webResourceManager;
        this.licenseStorageManager = licenseStorageManager;
        this.licenseCounter = licenseCounter;
        this.notificationService = notificationService;
        this.supportBarService = supportBarService;
    }

    public void setProjectKey(String key) {
        this.projectKey = key;
    }

    public String getProjectKey() {
        return this.projectKey;
    }

    public Project getProject() {
        return this.projectManager.getProjectObjByKey(this.projectKey);
    }

    public String getSupportbarHtml() {
        PluginLicense license = (PluginLicense)this.licenseStorageManager.getLicense().getOrElse((Object)null);
        return this.supportBarService.getHtml();
    }

    public String doDefault() throws Exception {
        this.context = new HashMap<String, Object>();
        HttpServletRequest request = ExecutingHttpRequest.get();
        this.webResourceManager.requireResourcesForContext("atl-notifier");
        String projectKey = this.getProjectKey();
        boolean filterProject = projectKey != null;
        boolean currentUserCanEdit = this.licenseCounter.currentUserCanEdit(projectKey);
        logger.debug(currentUserCanEdit + " they can edit?");
        if (currentUserCanEdit) {
            NotificationCount notificationCount = this.notificationService.getNotificationCount(projectKey);
            this.context.put("notificationCount", notificationCount);
            this.context.put("license", this.getCheckLicense());
            this.context.put("product", this.licenseCounter.getApplicationType());
            this.context.put("contextPath", request.getContextPath());
            this.context.put("filterProject", filterProject);
            this.context.put("projectKey", projectKey);
            this.context.put("wittifiedXsfrToken", this.licenseCounter.getXsfrToken(request, this.getHttpResponse()));
        }
        return "input";
    }

    public String getWittifiedXsfrToken() {
        return this.licenseCounter.getXsfrToken(this.getHttpRequest(), this.getHttpResponse());
    }

    public NotificationCount getNotificationCount() {
        return (NotificationCount)this.context.get("notificationCount");
    }

    public String getProduct() {
        return (String)this.context.get("product");
    }

    public String getLicense() {
        return (String)this.context.get("license");
    }

    public String getContextPath() {
        return (String)this.context.get("contextPath");
    }

    public boolean getFilterProject() {
        return true;
    }

    public String getCheckLicense() {
        if (this.licenseStorageManager.getLicense().isDefined()) {
            PluginLicense pluginLicense = (PluginLicense)this.licenseStorageManager.getLicense().get();
            if (pluginLicense.getError().isDefined()) {
                if (((LicenseError)pluginLicense.getError().get()).name().equals("EXPIRED")) {
                    return "The evaluation license has expired. Please contact your System administrator";
                }
                return "An error occurred while validating your license for this plugin: " + ((LicenseError)pluginLicense.getError().get()).name();
            }
            return null;
        }
        return "Plugin is not licensed. In order to evaluate this plugin you need to create an evaluation license";
    }
}

