/*
 * Decompiled with CFR 0.152.
 */
package com.wittified.upgrades;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.tx.Transactional;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.wittified.ao.NotificationService;
import com.wittified.ao.NotificationToNotificationUser;
import com.wittified.ao.NotificationUser;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationUserUpgradeTask2
implements PluginUpgradeTask {
    private final NotificationService notificationService;
    private final UserManager userManager;
    private final ActiveObjects activeObjects;
    private static Logger logger = LoggerFactory.getLogger(NotificationUserUpgradeTask2.class);

    public NotificationUserUpgradeTask2(NotificationService notificationService, UserManager userManager, ActiveObjects activeObjects) {
        this.notificationService = notificationService;
        this.userManager = userManager;
        this.activeObjects = activeObjects;
    }

    public int getBuildNumber() {
        return 5;
    }

    public String getShortDescription() {
        return "Store Userkey in the NOTIFICATION_USER table";
    }

    @Transactional
    public Collection<Message> doUpgrade() throws Exception {
        LogManager.getLogger((String)"com.wittified").setLevel(Level.INFO);
        List<NotificationUser> notificationUsers = this.notificationService.getAllNotificationUsersWithKeyNull();
        int totalSize = notificationUsers.size();
        int count = 0;
        for (NotificationUser notificationUser : notificationUsers) {
            UserProfile userProfile = this.userManager.getUserProfile(notificationUser.getUser());
            if (userProfile != null) {
                notificationUser.setUserKey(userProfile.getUserKey().getStringValue());
                notificationUser.save();
                logger.info("Updating notification user : " + ++count + "of " + totalSize);
                continue;
            }
            logger.info("User does not exist in the system with username : " + notificationUser.getUser());
            for (NotificationToNotificationUser notificationToNotificationUser : (NotificationToNotificationUser[])this.activeObjects.find(NotificationToNotificationUser.class, Query.select().where(" NOTIFICATION_USER_ID = ? ", new Object[]{notificationUser.getID()}))) {
                this.activeObjects.delete(new RawEntity[]{notificationToNotificationUser});
            }
            this.activeObjects.delete(new RawEntity[]{notificationUser});
        }
        LogManager.getLogger((String)"com.wittified").setLevel(null);
        return Collections.emptySet();
    }

    public String getPluginKey() {
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("announcer-project.properties");
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return "com.wittified.atl-announcer-" + properties.getProperty("wittified-app-key");
    }
}

