/*
 * Decompiled with CFR 0.152.
 */
package com.wittified.ao;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.tx.Transactional;
import com.wittified.ao.AnnouncerDataService;
import com.wittified.ao.Notification;
import com.wittified.ao.NotificationToNotificationUser;
import com.wittified.ao.NotificationUser;
import com.wittified.format.Format;
import com.wittified.format.FormatService;
import com.wittified.services.GlobalConfigurationService;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.java.ao.Query;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnouncerDataServiceImpl
implements AnnouncerDataService {
    public static final String JIRA_DISPLAY_NAME = "jira.displayName/";
    private final ActiveObjects activeObjects;
    private static GlobalConfigurationService globalConfigurationService;
    private final FormatService formatService;
    private final Logger logger = LoggerFactory.getLogger(AnnouncerDataServiceImpl.class);

    public AnnouncerDataServiceImpl(ActiveObjects activeObjects, GlobalConfigurationService globalConfigurationService, FormatService formatService) {
        this.activeObjects = activeObjects;
        AnnouncerDataServiceImpl.globalConfigurationService = globalConfigurationService;
        this.formatService = formatService;
    }

    @Override
    @Transactional
    public void saveNotificationExportStatus(Notification notification, boolean status) {
        notification.setActiveExportCsv(status);
        notification.save();
    }

    @Override
    @Transactional
    public Collection<JSONObject> getAllNotifications(String pluginKey, Map<String, String> users) {
        ArrayList<JSONObject> notifications = new ArrayList<JSONObject>();
        String notificationFields = "ACTIVE, ANONYMOUS, BUTTON_TEXT, DELAY_BUTTON, DESCRIPTION,FORMAT, GROUP_TARGET, ID, SHOW_BUTTON,FILTER_GROUPS, FILTER_PROJECT, TARGET_PROJECT, TARGET_PROJECT_ROLE, TITLE, TYPE, CONTENTS,FORMAT,HTML";
        this.activeObjects.stream(Notification.class, Query.select((String)notificationFields), notification -> {
            JSONObject notificationObj = this.buildNotificationJSONObject((Notification)notification, pluginKey, users);
            notifications.add(notificationObj);
        });
        return notifications;
    }

    private JSONObject buildNotificationJSONObject(Notification notification, String pluginKey, Map<String, String> users) {
        JSONObject notificationObj = new JSONObject();
        try {
            try {
                Map<Object, Object> ackUsersMap = new HashMap();
                NotificationToNotificationUser[] notificationToNotificationUsers = (NotificationToNotificationUser[])this.activeObjects.find(NotificationToNotificationUser.class, Query.select((String)"NOTIFICATION_USER_ID, DWELL_TIME").alias(NotificationUser.class, "noticationUser").alias(Notification.class, "notification").alias(NotificationToNotificationUser.class, "notifyUser").join(NotificationUser.class, "notifyUser.NOTIFICATION_USER_ID = noticationUser.ID").join(Notification.class, "notifyUser.NOTIFICATION_ID = notification.ID").where("notification.id=?", new Object[]{notification.getID()}));
                if (notificationToNotificationUsers != null && notificationToNotificationUsers.length > 0) {
                    ackUsersMap = Arrays.stream(notificationToNotificationUsers).filter(notificationToNotificationUser -> notificationToNotificationUser.getNotificationUser() != null && notificationToNotificationUser.getNotificationUser().getID() != 0).collect(Collectors.toMap(notificationToNotificationUser -> String.valueOf(users.get(JIRA_DISPLAY_NAME + notificationToNotificationUser.getNotificationUser().getUserKey())), notificationToNotificationUser -> notificationToNotificationUser.getDwellTime().toString()));
                }
                notificationObj.put("ackUsers", ackUsersMap);
            }
            catch (Exception e) {
                this.logger.error("An error occurred at fetching notification users : {}", (Object)e.getMessage(), (Object)e);
            }
            notificationObj.put("title", (Object)notification.getTitle());
            notificationObj.put("description", (Object)notification.getDescription());
            Format filterFormat = this.formatService.getFormats().stream().filter(format -> format.getType() == notification.getFormat()).findFirst().get();
            String result = Arrays.stream(filterFormat.getLabel().toLowerCase().split(" ")).collect(Collectors.joining(""));
            notificationObj.put("format", (Object)(result.equals("plaintext") ? "text" : result));
            if (pluginKey.equals("com.wittified.atl-announcer-jira")) {
                notificationObj.put("type", (Object)(notification.getType().equals("banner") ? "dialog" : notification.getType()));
            } else {
                notificationObj.put("type", (Object)notification.getType());
            }
            notificationObj.put("contents", (Object)notification.getHtml());
            notificationObj.put("active", notification.getActive());
            notificationObj.put("anonymous", notification.getAnonymous());
            notificationObj.put("delayButton", notification.getDelayButton());
            notificationObj.put("buttonText", (Object)notification.getButtonText());
            notificationObj.put("targetProject", (Object)notification.getTargetProject());
            notificationObj.put("filterProject", notification.getFilterProject());
            notificationObj.put("filterGroups", notification.getFilterGroups());
            notificationObj.put("targetGroup", (Object)notification.getGroupTarget());
            LocalDateTime dateTime = LocalDateTime.now();
            String formattedDateTime = DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(dateTime);
            notificationObj.put("createdAt", (Object)formattedDateTime);
            notificationObj.put("updatedAt", (Object)formattedDateTime);
            notificationObj.put("ackButton", (Object)notification.getShowButton());
            notificationObj.put("id", notification.getID());
        }
        catch (JSONException e) {
            this.logger.error("An error occurred at buildNotificationJSONObject : {}", (Object)e.getMessage(), (Object)e);
            e.printStackTrace();
        }
        return this.wrapAsDefaultObject(notificationObj, "notification#id#" + notification.getID());
    }

    @Override
    @Transactional
    public List<Notification> getAllNotificationsV2() {
        ArrayList<Notification> notifications = new ArrayList<Notification>();
        this.activeObjects.stream(Notification.class, Query.select((String)"ACTIVE, ANONYMOUS, BUTTON_TEXT, DATE_RESTRICT, DELAY_BUTTON, DESCRIPTION, DISPLAY, END_DATE, FILTER_GROUPS, FILTER_PROJECT, FILTER_CATEGORY, FILTER_PROJECT_ROLE, FORMAT, GROUP_TARGET, HTML, ID, IS_REQUIRED, NUM_ANON, RESET_BUTTON, SHOW_BUTTON, START_DATE, TARGET_CATEGORIES, TARGET_PROJECT, TARGET_PROJECT_ROLE, TEMP_ACTIVE, TITLE, TOTAL_ANON_DWELL, TYPE, CUSTOM_RECURRENCE_OPTION, RUNNING_TYPE_OPTION, RUNNING_TYPE, RUNNING_FREQ, RECURRING_TYPE_OPTION, RECURRING_TYPE, DAY_OF_WEEK, DAY_OF_MONTH, RECURRING_WEEKLY_TYPE, WEEKLY_START_TIME, WEEKLY_END_TIME, SELECTED_DAYS"), notification -> notifications.add((Notification)notification));
        return notifications;
    }

    @Override
    @Transactional
    public Collection<JSONObject> getAllNotificationUsers() {
        ArrayList<JSONObject> notificationUsers = new ArrayList<JSONObject>();
        this.activeObjects.stream(NotificationUser.class, Query.select((String)"ID, USER, USER_KEY"), notificationUser -> {
            JSONObject jsonObject = new JSONObject();
            try {
                jsonObject.put("notifications", (Object)notificationUser.getNotifications());
                jsonObject.put("user", (Object)notificationUser.getUser());
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            notificationUsers.add(jsonObject);
        });
        return notificationUsers;
    }

    @Override
    public JSONObject getGlobalConfiguration() {
        JSONObject globalConfig = new JSONObject();
        try {
            String dialogHeight = "small";
            if (globalConfigurationService.getDialogHeight().equals("400")) {
                dialogHeight = "medium";
            } else if (globalConfigurationService.getDialogHeight().equals("500")) {
                dialogHeight = "large";
            } else if (globalConfigurationService.getDialogHeight().equals("600")) {
                dialogHeight = "xlarge";
            }
            globalConfig.put("explainerText", (Object)globalConfigurationService.getRemindMeLaterExplainerText());
            globalConfig.put("dialogHeight", (Object)dialogHeight);
            globalConfig.put("isRemindMeLaterChecked", globalConfigurationService.getRemindMeLaterEnabled());
            globalConfig.put("remindMeLaterText", (Object)globalConfigurationService.getRemindMeLaterText());
            globalConfig.put("mutePeriod", (Object)globalConfigurationService.getRemindMeLaterTime());
            globalConfig.put("usageAnalytics", globalConfigurationService.getUsageAnalytics());
            globalConfig.put("userAgent", (Object)globalConfigurationService.getUserAgent());
            globalConfig.put("whitelistHTMLTags", (Object)globalConfigurationService.getValidHTMLTagsAndAttributes());
            globalConfig.put("projectConfigEnabled", globalConfigurationService.getProjectConfigEnabled());
            globalConfig.put("isEnableDelegationChecked", globalConfigurationService.getGlobalConfiguration().getDelegationConfig());
        }
        catch (JSONException e) {
            this.logger.error("Error occurred while building global configuration: {}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException("Failed to retrieve global configuration.", e);
        }
        return this.wrapAsDefaultObject(globalConfig, "configuration");
    }

    private JSONObject wrapAsDefaultObject(JSONObject jsonObject, String type) {
        JSONObject defaultObj = new JSONObject();
        try {
            defaultObj.put("defaultObj", (Object)jsonObject);
            defaultObj.put("recordtype", (Object)type);
        }
        catch (JSONException e) {
            this.logger.error("Error occurred while wrapping JSONObject: {}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException("Failed to wrap JSONObject.", e);
        }
        return defaultObj;
    }
}

