/*
 * Decompiled with CFR 0.152.
 */
package com.wittified.servlets.statuspage;

import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import com.wittified.ao.statuspage.Incident;
import com.wittified.ao.statuspage.IncidentUpdate;
import com.wittified.licensecounters.LicenseCounter;
import com.wittified.services.statuspage.StatusPageService;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusPageIncidentServlet
extends HttpServlet {
    private static final long serialVersionUID = -5888852654369617648L;
    private static Logger logger = LoggerFactory.getLogger(StatusPageIncidentServlet.class);
    private final StatusPageService statusPageService;
    private final WebResourceManager webResourceManager;
    private final LicenseCounter licenseCounter;
    private final PluginSettings settings;

    public StatusPageIncidentServlet(StatusPageService statusPageService, TemplateRenderer templateRenderer, WebResourceManager webResourceManager, LicenseCounter licenseCounter, UserManager userManager, PluginSettingsFactory settingsFactory) {
        this.statusPageService = statusPageService;
        this.webResourceManager = webResourceManager;
        this.licenseCounter = licenseCounter;
        this.settings = settingsFactory.createSettingsForKey("com.wittified.atl-announcer:atl-announcer");
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        PrintWriter out;
        this.webResourceManager.requireResourcesForContext("atl-statuspage-announcer");
        this.webResourceManager.requireResourcesForContext("atl-notifier");
        boolean badResponse = false;
        JSONObject json = new JSONObject();
        if (StringUtils.isNotBlank(req.getParameter("key"))) {
            JSONArray jsonUpdates = new JSONArray();
            String key = req.getParameter("key");
            Incident incident = this.statusPageService.getIncident(key);
            Properties props = (Properties)this.settings.get("com.wittified.atl-announcer:atl-announcer:token-config");
            if (props == null) {
                badResponse = true;
            } else {
                String baseUrl = props.getProperty("baseUrl");
                String apiToken = props.getProperty("apiToken");
                try {
                    IncidentUpdate[] updates;
                    JSONArray pages = this.getPages(baseUrl, apiToken);
                    JSONObject pageObject = this.getPageObject(incident.getStatusPageConfig().getPage(), pages);
                    json.put("page", (Object)pageObject.getString("name"));
                    json.put("id", incident.getID());
                    json.put("config", (Object)incident.getStatusPageConfig().getTitle());
                    json.put("status", incident.getStatus());
                    json.put("startDate", (Object)this.licenseCounter.parseDate(incident.getStartDate()));
                    json.put("updatedDate", (Object)this.licenseCounter.parseDate(incident.getUpdatedDate()));
                    json.put("tittle", (Object)incident.getTitle());
                    for (IncidentUpdate update : updates = incident.getUpdates()) {
                        JSONObject jsonUpdate = new JSONObject();
                        jsonUpdate.put("status", (Object)StringUtils.capitalize(update.getStatus()));
                        jsonUpdate.put("key", (Object)update.getKey());
                        jsonUpdate.put("updateDate", (Object)this.licenseCounter.parseDate(update.getUpdateDate()));
                        jsonUpdate.put("message", (Object)update.getMessage());
                        jsonUpdates.put((Object)jsonUpdate);
                    }
                    json.put("updates", (Object)jsonUpdates);
                }
                catch (ClientHandlerException | UniformInterfaceException | JSONException e) {
                    badResponse = true;
                }
            }
        } else {
            badResponse = true;
        }
        if (badResponse) {
            res.setContentType("application/json");
            res.setCharacterEncoding("UTF-8");
            out = res.getWriter();
            out.print("Error while fetching Incident");
        } else {
            res.setContentType("application/json");
            res.setCharacterEncoding("UTF-8");
            out = res.getWriter();
            out.print(json);
        }
    }

    private ClientResponse getResponse(String apiToken, String url) {
        Client client = Client.create();
        WebResource webResource = client.resource(url);
        ClientResponse clientResponse = (ClientResponse)((WebResource.Builder)((WebResource.Builder)webResource.header("Authorization", (Object)("OAuth " + apiToken)).type("application/json")).accept(new String[]{"application/json"})).get(ClientResponse.class);
        int statusCode = clientResponse.getStatus();
        if (statusCode == 401) {
            logger.error("Authentication Error");
            return null;
        }
        return clientResponse;
    }

    private JSONArray getPages(String baseUrl, String apiToken) throws ClientHandlerException, UniformInterfaceException, JSONException {
        JSONArray pages = new JSONArray((String)this.getResponse(apiToken, baseUrl).getEntity(String.class));
        return pages;
    }

    private JSONObject getPageObject(String pageKey, JSONArray pages) throws JSONException {
        JSONObject pageObject = null;
        for (int n = 0; n < pages.length(); ++n) {
            JSONObject object = pages.getJSONObject(n);
            if (!object.getString("id").equalsIgnoreCase(pageKey)) continue;
            pageObject = object;
            break;
        }
        return pageObject;
    }
}

