/*
 * Decompiled with CFR 0.152.
 */
package com.wittified.licensecounters;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.core.DateFormatter;
import com.atlassian.confluence.core.FormatSettingsManager;
import com.atlassian.confluence.core.datetime.FriendlyDateFormatter;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.labels.Namespace;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.mail.template.ConfluenceMailQueueItem;
import com.atlassian.confluence.mail.template.VelocityMailBuilder;
import com.atlassian.confluence.schedule.ScheduledJobKey;
import com.atlassian.confluence.schedule.managers.ScheduledJobManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.login.LoginInfo;
import com.atlassian.confluence.security.login.LoginManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.spaces.SpaceType;
import com.atlassian.confluence.spaces.SpacesQuery;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.ConfluenceUserPreferences;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.LicenseCalculator;
import com.atlassian.confluence.web.context.HttpContext;
import com.atlassian.core.task.MultiQueueTaskManager;
import com.atlassian.mail.queue.MailQueueItem;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.User;
import com.atlassian.xwork.SimpleXsrfTokenGenerator;
import com.google.common.collect.Lists;
import com.wittified.ao.Notification;
import com.wittified.cache.NotificationCacheEntry;
import com.wittified.licensecounters.LicenseCounter;
import com.wittified.services.GlobalConfigurationService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluenceLicenseCounter
implements LicenseCounter {
    private final LicenseCalculator licenseCalculator = (LicenseCalculator)ContainerManager.getComponent((String)"readOnlyLicenseCalculator");
    private final WebResourceManager webResourceManager = (WebResourceManager)ContainerManager.getComponent((String)"webResourceManager");
    private final UserAccessor userAccessor = (UserAccessor)ContainerManager.getComponent((String)"userAccessor");
    private final UserManager salUserManager;
    private final com.atlassian.user.UserManager userManager;
    private final PermissionManager permissionManager = (PermissionManager)ContainerManager.getComponent((String)"permissionManager");
    private final SpaceManager spaceManager = (SpaceManager)ContainerManager.getComponent((String)"spaceManager");
    private final PluginSettingsFactory pluginSettingsFactory;
    private final ApplicationProperties applicationProperties;
    private final HttpContext httpContext;
    private final FormatSettingsManager formatSettingsManager;
    private final LocaleManager localeManager;
    private final GlobalConfigurationService configService;
    private final LabelManager labelManager;
    private final ScheduledJobManager scheduledJobManager;
    private final I18nResolver i18nResolver;
    private final MultiQueueTaskManager taskManager;
    private final LoginManager loginManager;
    private static Logger logger = LoggerFactory.getLogger(ConfluenceLicenseCounter.class);

    public ConfluenceLicenseCounter(UserManager salUserManager, PluginSettingsFactory pluginSettingsFactory, HttpContext httpContext, ApplicationProperties applicationProperties, FormatSettingsManager formatSettingsManager, LocaleManager localeManager, GlobalConfigurationService configService, LabelManager labelManager, I18nResolver i18nResolver, MultiQueueTaskManager taskManager, LoginManager loginManager) {
        this.salUserManager = salUserManager;
        this.userManager = (com.atlassian.user.UserManager)ContainerManager.getComponent((String)"userManager");
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.httpContext = httpContext;
        this.applicationProperties = applicationProperties;
        this.formatSettingsManager = formatSettingsManager;
        this.localeManager = localeManager;
        this.configService = configService;
        this.labelManager = labelManager;
        this.scheduledJobManager = (ScheduledJobManager)ContainerManager.getComponent((String)"scheduledJobManager");
        this.i18nResolver = i18nResolver;
        this.taskManager = taskManager;
        this.loginManager = loginManager;
    }

    @Override
    public int getNumberOfUsers() {
        return this.licenseCalculator.getNumberOfLicensedUsers();
    }

    @Override
    public String getApplicationType() {
        return "CONFLUENCE";
    }

    @Override
    public String getAvatarURL(String username) {
        return "";
    }

    @Override
    public List<String> getActiveUsers() {
        return ((UserAccessor)ContainerManager.getComponent((String)"userAccessor")).getUserNamesWithConfluenceAccess();
    }

    @Override
    public Map<String, String> getAllProjects(String username) {
        User user;
        try {
            user = this.userManager.getUser(username);
        }
        catch (Exception e) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> retMap = new HashMap<String, String>();
        for (Space space : ((SpaceManager)ContainerManager.getComponent((String)"spaceManager")).getAllSpaces(SpacesQuery.newQuery().forUser(user).withSpaceType(SpaceType.GLOBAL).build())) {
            retMap.put(space.getKey(), space.getName());
        }
        return retMap;
    }

    @Override
    public String getProjectKey(Object action) {
        ConfluenceActionSupport cas = (ConfluenceActionSupport)action;
        Space space = cas.getWebInterfaceContext().getSpace();
        if (space == null) {
            return null;
        }
        return space.getKey();
    }

    @Override
    public String getProductContainerName() {
        return "space";
    }

    @Override
    public int getNumUsersInGroup(String groupName) {
        Group group = this.userAccessor.getGroup(groupName);
        if (group != null) {
            return this.userAccessor.getMemberNamesAsList(group).size();
        }
        return -2;
    }

    @Override
    public List<String> getUserNamesInGroup(String groupName) {
        ArrayList list = new ArrayList();
        Group group = this.userAccessor.getGroup(groupName);
        if (group != null) {
            return this.userAccessor.getMemberNamesAsList(group);
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public boolean currentUserCanEdit(String key) {
        String enabledProjectConfig = (String)this.pluginSettingsFactory.createGlobalSettings().get("wittified.announcer.projects");
        if (enabledProjectConfig == null) {
            enabledProjectConfig = "false";
        }
        if (enabledProjectConfig.equals("false")) {
            return false;
        }
        Space space = this.spaceManager.getSpace(key);
        if (space == null) {
            return false;
        }
        String userKey = this.salUserManager.getRemoteUsername();
        if (userKey == null) {
            return false;
        }
        User user = null;
        try {
            user = this.userManager.getUser(userKey);
        }
        catch (EntityException e) {
            return false;
        }
        return this.permissionManager.hasPermission(user, Permission.ADMINISTER, (Object)space);
    }

    @Override
    public String getXsfrToken(HttpServletRequest request, HttpServletResponse response) {
        return new SimpleXsrfTokenGenerator().generateToken(request);
    }

    @Override
    public boolean validateXsfrToken(HttpServletRequest request, String token) {
        return new SimpleXsrfTokenGenerator().validateToken(request, token);
    }

    @Override
    public HttpServletRequest getRequestObject() {
        return this.httpContext.getRequest();
    }

    @Override
    public HttpServletResponse getResponseObject() {
        return this.httpContext.getResponse();
    }

    @Override
    public Map<String, String> getVarData() {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("EMAIL", "");
        data.put("FULL_NAME", "Anonymous");
        data.put("USER_NAME", "anonymous");
        UserProfile currentUser = this.salUserManager.getRemoteUser();
        if (currentUser != null) {
            data.put("EMAIL", currentUser.getEmail());
            data.put("FULL_NAME", currentUser.getFullName());
            data.put("USER_NAME", currentUser.getUsername());
        }
        return data;
    }

    @Override
    public String getSkippedPaths() {
        return "/plugins/servlet/oauth|/authenticate.action|/login.action|/plugins/servlet/applinks/|/plugins/servlet/streams|/rpc/|/rest/|/plugins/servlet/upm|/plugins/servlet/wittified/admin/notifications|/styles/";
    }

    @Override
    public boolean areFlagsSupported() {
        return true;
    }

    @Override
    public String getPluginKey() {
        return "com.wittified.atl-announcer-confluence";
    }

    @Override
    public JSONObject getGroupsStartingWith(String startString, String excludeGroup) throws JSONException {
        return this.findGroupsAsBean(startString, excludeGroup);
    }

    public JSONObject findGroupsAsBean(String startString, String excludeGroups) throws JSONException {
        ArrayList groupNames = Lists.newArrayList();
        JSONObject groupsContainer = new JSONObject();
        ArrayList groups = Lists.newArrayList((Iterable)this.salUserManager.findGroupNamesByPrefix(startString, 0, 20));
        int total = this.limitGroupResults(groups, excludeGroups, groupNames, startString);
        groupsContainer.put("groups", (Collection)groupNames);
        groupsContainer.put("total", total);
        return groupsContainer;
    }

    private int limitGroupResults(List<String> groups, String excludeGroups, List<String> groupNames, String startString) {
        int limit = 20;
        int i = 0;
        int total = groups.size();
        for (String group : groups) {
            if (i >= limit) break;
            if (!excludeGroups.equalsIgnoreCase(group)) {
                groupNames.add(group);
                ++i;
                continue;
            }
            --total;
        }
        return total;
    }

    @Override
    public String getProjectString(String spaceKeys) {
        logger.debug("spaceKeys:" + spaceKeys);
        ArrayList projectStrings = Lists.newArrayList();
        if (StringUtils.isEmpty(spaceKeys)) {
            spaceKeys = "";
        }
        List<String> keys = Arrays.asList(spaceKeys.split("::"));
        ListIterator<String> i = keys.listIterator();
        while (i.hasNext()) {
            i.set(i.next().replace(":", ""));
        }
        for (String key : keys) {
            if (key == "") continue;
            String projectString = "";
            Space space = this.spaceManager.getSpace(key);
            if (space == null) continue;
            projectString = space.getName() + " (" + key + ")";
            projectStrings.add(projectString);
        }
        return String.join((CharSequence)",", projectStrings);
    }

    @Override
    public String parseDate(Date date) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        ConfluenceUserPreferences preferences = this.userAccessor.getConfluenceUserPreferences((User)user);
        this.formatSettingsManager.setDateFormat("MMM dd, yyyy HH:mm");
        DateFormatter dateFormatter = preferences.getDateFormatter(this.formatSettingsManager, this.localeManager);
        FriendlyDateFormatter friendlyDateFormatter = new FriendlyDateFormatter(new Date(), dateFormatter);
        return GeneralUtil.getI18n().getText(friendlyDateFormatter.getFormatMessage(date).getKey(), friendlyDateFormatter.getFormatMessage(date).getArguments());
    }

    @Override
    public JSONObject getProjectsStartingWith(String startString, String excludeProject) throws JSONException {
        return null;
    }

    @Override
    public boolean isProjInCategory(String[] categories, String projectKey) {
        ArrayList labels = Lists.newArrayList();
        for (String category : categories) {
            List tempLabels = this.labelManager.getLabelsByDetail(category, Namespace.TEAM.toString(), projectKey, "");
            if (tempLabels.isEmpty()) continue;
            labels.addAll(tempLabels);
        }
        return !labels.isEmpty();
    }

    @Override
    public JSONObject getCategoriesStartingWith(String startString, String excludedProjectCategory) throws JSONException {
        return this.findCategoriesAsBean(startString, excludedProjectCategory);
    }

    private JSONObject findCategoriesAsBean(String startString, String excludedProjectCategory) throws JSONException {
        ArrayList projectCategoryNames = Lists.newArrayList();
        JSONObject projectCategoriesContainer = new JSONObject();
        List categories = this.labelManager.getTeamLabels();
        int total = this.limitProjectCategoryResults(categories, excludedProjectCategory, projectCategoryNames, startString);
        projectCategoriesContainer.put("categories", (Collection)projectCategoryNames);
        projectCategoriesContainer.put("total", total);
        return projectCategoriesContainer;
    }

    private int limitProjectCategoryResults(List<Label> categories, String excludedProjectCategory, List<String> projectCategoryNames, String startString) {
        int limit = 20;
        int i = 0;
        int total = categories.size();
        for (Label label : categories) {
            if (i >= limit) break;
            if (!excludedProjectCategory.equalsIgnoreCase(label.getName())) {
                if (!label.getName().toLowerCase().startsWith(startString.toLowerCase())) continue;
                projectCategoryNames.add(label.getName());
                ++i;
                continue;
            }
            --total;
        }
        return total;
    }

    @Override
    public JSONObject getProjectRolesStartingWith(String startString, String excludedProject) throws JSONException {
        return null;
    }

    @Override
    public List<String> getAllProjectRoles() {
        return null;
    }

    @Override
    public List<String> getAllCategories() {
        List categories = this.labelManager.getTeamLabels();
        return categories.stream().map(label -> label.getName()).collect(Collectors.toList());
    }

    @Override
    public boolean isGroupExists(String groupName) {
        return this.userAccessor.getGroup(groupName) != null;
    }

    @Override
    public boolean isNewUser(UserProfile user) {
        if (user == null) {
            return false;
        }
        LoginInfo loginInfo = this.loginManager.getLoginInfo(user.getUsername());
        return loginInfo != null && loginInfo.getPreviousSuccessfulLoginDate() == null;
    }

    @Override
    public boolean projectDoesNotExist(String key) {
        logger.debug("Check if Confluence license counter for space key:" + key + ":spaceManager.getSpace(key):" + this.spaceManager.getSpace(key));
        return this.spaceManager.getSpace(key) == null;
    }

    @Override
    public boolean doesUserHasBrowsePermissionOnProject(String key) {
        return false;
    }

    @Override
    public boolean isUserInProjectRole(UserProfile user, String targetedProjectRoles, String projectKey) {
        return false;
    }

    @Override
    public String getCurrentUserKey() {
        return AuthenticatedUserThreadLocal.get().getKey().getStringValue();
    }

    @Override
    public void sendEmail(Notification theNotification, String toUserKey, String exportedFilePath) {
        String subject = this.i18nResolver.getText("wittified.announcer.admin.report.mail.subject", new Serializable[]{this.getApplicationType(), theNotification.getTitle()});
        UserProfile user = this.salUserManager.getUserProfile(new UserKey(toUserKey));
        VelocityMailBuilder velocityMailBuilder = new VelocityMailBuilder("templates/", "activity-report-email-body.vm");
        velocityMailBuilder.setSubject(subject);
        velocityMailBuilder.addContextItem("firstname", (Object)user.getFullName());
        velocityMailBuilder.addContextItem("reportName", (Object)theNotification.getTitle());
        velocityMailBuilder.addContextItem("exportedFilePath", (Object)exportedFilePath);
        velocityMailBuilder.setToEmail(user.getEmail());
        velocityMailBuilder.setMimeType("text/html");
        ConfluenceMailQueueItem mailQueueItem = velocityMailBuilder.getRenderedMailQueueItem();
        this.taskManager.addTask("mail", () -> ConfluenceLicenseCounter.lambda$sendEmail$828332a4$1((MailQueueItem)mailQueueItem));
    }

    @Override
    public void scheduleAnnouncerReportJob(int notificationId) {
        Map<String, String> reportParams = new HashMap<String, Integer>();
        if (this.pluginSettingsFactory.createGlobalSettings().get("wittified-announcer.reportParams") != null) {
            reportParams = (Map)this.pluginSettingsFactory.createGlobalSettings().get("wittified-announcer.reportParams");
        }
        reportParams.put("announcerNotifId", (String)((Object)Integer.valueOf(notificationId)));
        reportParams.put("announcerNotifEmail", this.getCurrentUserKey());
        this.pluginSettingsFactory.createGlobalSettings().put("wittified-announcer.reportParams", reportParams);
        try {
            logger.debug("Executing :: scheduledJobManager.runNow(jobid)");
            JobId jobid = JobId.of((String)"announcer-report-confluence-job");
            this.scheduledJobManager.runNow(jobid);
        }
        catch (NoSuchMethodError | RuntimeException e) {
            logger.debug("Announcer-report-job : Error while scheduling the job", e);
            logger.debug("Executing :: scheduledJobManager.runNow(scheduledJobKey)");
            this.scheduledJobManager.runNow(new ScheduledJobKey("com.wittified.atl-announcer-confluence", "announcer-report-confluence"));
        }
    }

    @Override
    public boolean displayNotification(NotificationCacheEntry notification, String projectKey) {
        return false;
    }

    @Override
    public List<String> getAllGroups(String user) {
        Iterable groups = this.salUserManager.findGroupNamesByPrefix("", 0, 100000);
        ArrayList<String> allGroups = new ArrayList<String>();
        for (String group : groups) {
            allGroups.add(group);
        }
        return allGroups;
    }

    private static /* synthetic */ void lambda$sendEmail$828332a4$1(MailQueueItem mailQueueItem) throws Exception {
        mailQueueItem.send();
    }
}

