/*
 * Decompiled with CFR 0.152.
 */
package com.wittified.licensecounters;

import com.atlassian.bitbucket.AuthorisationException;
import com.atlassian.bitbucket.avatar.AvatarRequest;
import com.atlassian.bitbucket.avatar.AvatarService;
import com.atlassian.bitbucket.i18n.I18nKey;
import com.atlassian.bitbucket.license.LicenseService;
import com.atlassian.bitbucket.mail.MailService;
import com.atlassian.bitbucket.mail.SoyMailBuilder;
import com.atlassian.bitbucket.mail.SoyMailMessageRequest;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.project.ProjectService;
import com.atlassian.bitbucket.request.RequestManager;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.Person;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.bitbucket.util.DateFormatter;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageRequestImpl;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.sal.api.xsrf.XsrfTokenAccessor;
import com.google.common.collect.Lists;
import com.wittified.ao.Notification;
import com.wittified.bbserver.BitBucketTokenGenerator;
import com.wittified.cache.NotificationCacheEntry;
import com.wittified.licensecounters.LicenseCounter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitBucketLicenseCounter
implements LicenseCounter {
    private final Logger logger = LoggerFactory.getLogger(BitBucketLicenseCounter.class);
    private final LicenseService licenseService;
    private static final int RESULTS_PER_REQUEST = 1000;
    private final AvatarService avatarService;
    private final UserService userService;
    private final PermissionService permissionService;
    private final PermissionValidationService permissionValidationService;
    private final ProjectService projectService;
    private final PluginSettingsFactory pluginSettingsFactory;
    private final XsrfTokenAccessor xsrfTokenAccessor;
    private final RequestManager requestManager;
    private final UserManager salUserManager;
    private final DateFormatter formatter;
    private final MailService mailService;
    private final SoyMailBuilder soyMailBuilder;

    public BitBucketLicenseCounter(LicenseService licenseService, AvatarService avatarService, UserService userService, PermissionService permissionService, ProjectService projectService, PermissionValidationService permissionValidationService, PluginSettingsFactory pluginSettingsFactory, XsrfTokenAccessor xsrfTokenAccessor, RequestManager requestManager, UserManager salUserManager, DateFormatter formatter, MailService mailService, SoyMailBuilder soyMailBuilder) {
        this.licenseService = licenseService;
        this.avatarService = avatarService;
        this.userService = userService;
        this.permissionService = permissionService;
        this.projectService = projectService;
        this.permissionValidationService = permissionValidationService;
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.xsrfTokenAccessor = xsrfTokenAccessor;
        this.requestManager = requestManager;
        this.salUserManager = salUserManager;
        this.formatter = formatter;
        this.mailService = mailService;
        this.soyMailBuilder = soyMailBuilder;
    }

    @Override
    public int getNumberOfUsers() {
        return this.licenseService.getLicensedUsersCount();
    }

    @Override
    public String getApplicationType() {
        return "BITBUCKET";
    }

    @Override
    public String getAvatarURL(String username) {
        AvatarRequest avatarRequest = new AvatarRequest(false, 45);
        return this.avatarService.getUrlForPerson((Person)this.userService.getUserByName(username), avatarRequest);
    }

    @Override
    public List<String> getActiveUsers() {
        PageRequestImpl pageRequest = new PageRequestImpl(0, 100000);
        HashMap<String, String> userMap = new HashMap<String, String>();
        for (ApplicationUser stashUser : this.permissionService.getGrantedUsers(Permission.LICENSED_USER, (PageRequest)pageRequest).getValues()) {
            userMap.put(stashUser.getName(), stashUser.getName());
        }
        for (String groupName : this.permissionService.getGrantedGroups(Permission.LICENSED_USER, (PageRequest)pageRequest).getValues()) {
            for (ApplicationUser stashUser : this.userService.findUsersByGroup(groupName, (PageRequest)pageRequest).getValues()) {
                userMap.put(stashUser.getName(), stashUser.getName());
            }
        }
        ArrayList<String> items = new ArrayList<String>();
        for (String user : userMap.values()) {
            items.add(user);
        }
        return items;
    }

    @Override
    public Map<String, String> getAllProjects(String username) {
        HashMap<String, String> retMap = new HashMap<String, String>();
        for (String k : this.projectService.findAllKeys()) {
            Project project = this.projectService.getByKey(k);
            retMap.put(k, project.getName());
        }
        return retMap;
    }

    @Override
    public String getProjectKey(Object obj) {
        HttpServletRequest request = (HttpServletRequest)obj;
        if (request.getRequestURI() == null || request.getRequestURI().isEmpty()) {
            return null;
        }
        String projectKey = null;
        String mvcStartPath = request.getContextPath() + "/mvc/projects/";
        String nonmvcStartPath = request.getContextPath() + "/projects/";
        String manipulationPath = null;
        if (request.getRequestURI().startsWith(mvcStartPath)) {
            manipulationPath = request.getRequestURI().substring(mvcStartPath.length());
        } else if (request.getRequestURI().startsWith(nonmvcStartPath)) {
            manipulationPath = request.getRequestURI().substring(nonmvcStartPath.length());
        } else {
            return null;
        }
        this.logger.debug("Manip path: " + manipulationPath);
        if (!manipulationPath.isEmpty()) {
            projectKey = manipulationPath.contains("/") ? manipulationPath.substring(0, manipulationPath.indexOf("/")) : manipulationPath;
            this.logger.debug("projectKey: " + projectKey);
            if (this.projectService.getByKey(projectKey) != null) {
                return projectKey;
            }
        }
        return null;
    }

    @Override
    public HttpServletResponse getResponseObject() {
        return (HttpServletResponse)this.requestManager.getRequestContext().getRawResponse();
    }

    @Override
    public HttpServletRequest getRequestObject() {
        return (HttpServletRequest)this.requestManager.getRequestContext().getRawRequest();
    }

    @Override
    public String getProductContainerName() {
        return "project";
    }

    @Override
    public int getNumUsersInGroup(String groupName) {
        if (!this.userService.existsGroup(groupName)) {
            return -2;
        }
        PageRequestImpl pageRequest = new PageRequestImpl(0, 0x100000);
        int c = 0;
        for (ApplicationUser stashUser : this.userService.findUsersByGroup(groupName, (PageRequest)pageRequest).getValues()) {
            ++c;
        }
        return c;
    }

    @Override
    public List<String> getUserNamesInGroup(String groupName) {
        ArrayList users = Lists.newArrayList();
        ArrayList results = Lists.newArrayList((Iterable)this.userService.findUsersByGroup(groupName, (PageRequest)new PageRequestImpl(0, 1000)).getValues());
        int i = 1;
        while (results.size() > 0) {
            users.addAll(results.stream().map(ApplicationUser::getSlug).collect(Collectors.toList()));
            results = Lists.newArrayList((Iterable)this.userService.findUsersByGroup(groupName, (PageRequest)new PageRequestImpl(i * 1000, 1000)).getValues());
            ++i;
        }
        return users;
    }

    @Override
    public boolean currentUserCanEdit(String key) {
        String enabledProjectConfig = (String)this.pluginSettingsFactory.createGlobalSettings().get("wittified.announcer.projects");
        if (enabledProjectConfig == null) {
            enabledProjectConfig = "false";
        }
        if (enabledProjectConfig.equals("false")) {
            return false;
        }
        Project project = this.projectService.getByKey(key);
        if (project == null) {
            return false;
        }
        try {
            this.permissionValidationService.validateForProject(project, Permission.PROJECT_ADMIN);
        }
        catch (AuthorisationException e) {
            return false;
        }
        return true;
    }

    @Override
    public String getXsfrToken(HttpServletRequest request, HttpServletResponse response) {
        return BitBucketTokenGenerator.generateToken(request);
    }

    @Override
    public boolean validateXsfrToken(HttpServletRequest request, String token) {
        return BitBucketTokenGenerator.validateToken(request, token);
    }

    @Override
    public Map<String, String> getVarData() {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("EMAIL", "");
        data.put("FULL_NAME", "Anonymous");
        data.put("USER_NAME", "anonymous");
        UserProfile currentUser = this.salUserManager.getRemoteUser();
        if (currentUser != null) {
            data.put("EMAIL", currentUser.getEmail());
            data.put("FULL_NAME", currentUser.getFullName());
            data.put("USER_NAME", currentUser.getUsername());
        }
        return data;
    }

    @Override
    public String getSkippedPaths() {
        return "/scm/|/plugins/servlet/upm|/plugins/servlet/wittified/admin/notifications|/admin/backups|/mvc/maintenance|/unavailable/|/login|/rest/keys|/plugins/servlet/autounapprove|/plugins/servlet/applinks";
    }

    @Override
    public boolean areFlagsSupported() {
        return true;
    }

    @Override
    public String getPluginKey() {
        return "com.wittified.atl-announcer-stash";
    }

    @Override
    public JSONObject getGroupsStartingWith(String startString, String excludeGroup) throws JSONException {
        return this.findGroupsAsBean(startString, excludeGroup);
    }

    public JSONObject findGroupsAsBean(String startString, String excludeGroups) throws JSONException {
        ArrayList groupNames = Lists.newArrayList();
        JSONObject groupsContainer = new JSONObject();
        ArrayList groups = Lists.newArrayList((Iterable)this.salUserManager.findGroupNamesByPrefix(startString, 0, 20));
        int total = this.limitGroupResults(groups, excludeGroups, groupNames);
        groupsContainer.put("groups", (Collection)groupNames);
        groupsContainer.put("total", total);
        return groupsContainer;
    }

    private int limitGroupResults(List<String> groups, String excludeGroups, List<String> groupNames) {
        int limit = 20;
        int i = 0;
        int total = groups.size();
        for (String group : groups) {
            if (i >= limit) break;
            if (!excludeGroups.equalsIgnoreCase(group)) {
                groupNames.add(group);
                ++i;
                continue;
            }
            --total;
        }
        return total;
    }

    @Override
    public String getProjectString(String targetProject) {
        return null;
    }

    @Override
    public String parseDate(Date date) {
        return this.formatter.formatDate(date, DateFormatter.FormatType.LONGAGE);
    }

    @Override
    public JSONObject getProjectsStartingWith(String startString, String excludeProject) throws JSONException {
        return null;
    }

    @Override
    public boolean isProjInCategory(String[] categories, String projectKey) {
        return false;
    }

    @Override
    public JSONObject getCategoriesStartingWith(String startString, String excludedProject) throws JSONException {
        return null;
    }

    @Override
    public JSONObject getProjectRolesStartingWith(String startString, String excludedProject) throws JSONException {
        return null;
    }

    @Override
    public List<String> getAllProjectRoles() {
        return null;
    }

    @Override
    public List<String> getAllCategories() {
        return null;
    }

    @Override
    public boolean isGroupExists(String groupName) {
        return this.userService.existsGroup(groupName);
    }

    @Override
    public boolean isNewUser(UserProfile remoteUser) {
        return false;
    }

    @Override
    public boolean projectDoesNotExist(String key) {
        this.logger.debug("Check if Bitbucket license counter for project key:" + key + ":projectService.getByKey(key):" + this.projectService.getByKey(key));
        return this.projectService.getByKey(key) == null;
    }

    @Override
    public boolean doesUserHasBrowsePermissionOnProject(String key) {
        return false;
    }

    @Override
    public boolean isUserInProjectRole(UserProfile user, String targetedProjectRoles, String projectKey) {
        return false;
    }

    @Override
    public String getCurrentUserKey() {
        UserKey userKey = this.salUserManager.getRemoteUserKey();
        if (userKey != null) {
            return userKey.getStringValue();
        }
        return "";
    }

    @Override
    public void sendEmail(Notification theNotification, String toUserKey, String exportedFilePath) {
        UserProfile user = this.salUserManager.getUserProfile(new UserKey(toUserKey));
        WeakHashMap<String, String> context = new WeakHashMap<String, String>();
        context.put("firstname", user.getFullName());
        context.put("reportName", theNotification.getTitle());
        context.put("exportedFilePath", exportedFilePath);
        Iterable messages = this.soyMailBuilder.build(new SoyMailMessageRequest.Builder().context(context).cssModuleKey(this.getPluginKey() + ":atl-announcements-resources").messageEffector(null).recipients(Collections.singleton(this.userService.getUserByName(user.getUsername()))).soyTemplateModuleKey(this.getPluginKey() + ":atl-announcements-resources").soyTemplateName("wittified.announcer.soy.email.body").subjectKey(new I18nKey("wittified.announcer.admin.report.mail.subject", new Object[]{this.getApplicationType(), theNotification.getTitle()})).build());
        messages.forEach(arg_0 -> ((MailService)this.mailService).submit(arg_0));
    }

    @Override
    public void scheduleAnnouncerReportJob(int id) {
    }

    @Override
    public boolean displayNotification(NotificationCacheEntry notification, String projectKey) {
        return false;
    }

    @Override
    public List<String> getAllGroups(String user) {
        Iterable groupNames = this.salUserManager.findGroupNamesByPrefix("", 0, 100000);
        ArrayList<String> groups = new ArrayList<String>();
        for (String group : groupNames) {
            groups.add(group);
        }
        return groups;
    }
}

