/*
 * Decompiled with CFR 0.152.
 */
package com.wittified.job;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.compat.CompatibilityPluginScheduler;
import com.wittified.job.AnnouncerReportJobRunner;
import com.wittified.job.AnonUserCleanJobHandler;
import com.wittified.job.StatuspageJobHandler;
import com.wittified.job.TemporalAnnouncementActivationJobHandler;
import com.wittified.job.WittifiedJobScheduler;
import java.util.EnumSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class WittifiedSchedulerStartup
implements LifecycleAware,
InitializingBean,
DisposableBean {
    private final EventPublisher eventPublisher;
    private final CompatibilityPluginScheduler compatibilityPluginScheduler;
    private final WittifiedJobScheduler wittifiedJobScheduler;
    private final ActiveObjects activeObjects;
    private final TemporalAnnouncementActivationJobHandler temporalAnnouncementActivationJobHandler;
    private final AnonUserCleanJobHandler anonUserCleanJobHandler;
    private final StatuspageJobHandler statusPageJobHandler;
    private final AnnouncerReportJobRunner announcerReportJobRunner;
    private final SchedulerService schedulerService;
    private final Logger logger = LoggerFactory.getLogger(WittifiedSchedulerStartup.class);
    private final Set<LifecycleEvent> lifecycleEvents = EnumSet.noneOf(LifecycleEvent.class);

    public WittifiedSchedulerStartup(EventPublisher eventPublisher, CompatibilityPluginScheduler compatibilityPluginScheduler, WittifiedJobScheduler wittifiedJobScheduler, ActiveObjects activeObjects, TemporalAnnouncementActivationJobHandler temporalAnnouncementActivationJobHandler, AnonUserCleanJobHandler anonUserCleanJobHandler, StatuspageJobHandler statusPageJobHandler, AnnouncerReportJobRunner announcerReportJobRunner, SchedulerService schedulerService) {
        this.eventPublisher = eventPublisher;
        this.compatibilityPluginScheduler = compatibilityPluginScheduler;
        this.wittifiedJobScheduler = wittifiedJobScheduler;
        this.activeObjects = activeObjects;
        this.temporalAnnouncementActivationJobHandler = temporalAnnouncementActivationJobHandler;
        this.anonUserCleanJobHandler = anonUserCleanJobHandler;
        this.statusPageJobHandler = statusPageJobHandler;
        this.schedulerService = schedulerService;
        this.announcerReportJobRunner = announcerReportJobRunner;
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
        this.wittifiedJobScheduler.stop();
        this.compatibilityPluginScheduler.unregisterJobHandler(TemporalAnnouncementActivationJobHandler.TEMPORAL_ANNOUNCEMENT_ACTIVATION_KEY);
        this.compatibilityPluginScheduler.unregisterJobHandler(AnonUserCleanJobHandler.CLEAN_UP_JOB);
        this.compatibilityPluginScheduler.unregisterJobHandler(StatuspageJobHandler.STATUS_PAGE_JOB);
        this.schedulerService.unregisterJobRunner(AnnouncerReportJobRunner.ANNOUNCER_JOB);
    }

    public void afterPropertiesSet() throws Exception {
        this.eventPublisher.register((Object)this);
        this.onLifecycleEvent(LifecycleEvent.AFTER_PROPERTIES_SET);
    }

    public void onStop() {
    }

    public void onStart() {
        this.onLifecycleEvent(LifecycleEvent.LIFECYCLE_AWARE_ON_START);
    }

    @EventListener
    public void onPluginEnabled(PluginEnabledEvent event) {
        if (event.getPlugin().getKey().startsWith("com.wittified.atl-announcer-")) {
            this.onLifecycleEvent(LifecycleEvent.PLUGIN_ENABLED);
        }
    }

    private synchronized boolean isLifecycleReady(LifecycleEvent event) {
        return this.lifecycleEvents.add(event) && this.lifecycleEvents.size() == LifecycleEvent.values().length;
    }

    private void onLifecycleEvent(LifecycleEvent event) {
        if (this.isLifecycleReady(event)) {
            this.eventPublisher.unregister((Object)this);
            try {
                this.compatibilityPluginScheduler.registerJobHandler(TemporalAnnouncementActivationJobHandler.TEMPORAL_ANNOUNCEMENT_ACTIVATION_KEY, this.temporalAnnouncementActivationJobHandler);
                this.compatibilityPluginScheduler.registerJobHandler(AnonUserCleanJobHandler.CLEAN_UP_JOB, this.anonUserCleanJobHandler);
                this.compatibilityPluginScheduler.registerJobHandler(StatuspageJobHandler.STATUS_PAGE_JOB, this.statusPageJobHandler);
                this.schedulerService.registerJobRunner(AnnouncerReportJobRunner.ANNOUNCER_JOB, (JobRunner)this.announcerReportJobRunner);
                this.wittifiedJobScheduler.reschedule();
            }
            catch (Exception ex) {
                this.logger.error("Error encountered while registering items");
            }
        }
    }

    private void initActiveObjects() {
        this.activeObjects.flushAll();
    }

    static enum LifecycleEvent {
        AFTER_PROPERTIES_SET,
        PLUGIN_ENABLED,
        LIFECYCLE_AWARE_ON_START;

    }
}

