/*
 * Decompiled with CFR 0.152.
 */
package com.wittified.job;

import com.atlassian.scheduler.compat.JobInfo;
import com.wittified.ao.Notification;
import com.wittified.ao.NotificationService;
import com.wittified.job.TemporalAnnouncementActivationJobHandler;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemporalAnnouncementActivationJobHandlerImpl
implements TemporalAnnouncementActivationJobHandler {
    private final Logger logger = LoggerFactory.getLogger(TemporalAnnouncementActivationJobHandlerImpl.class);
    private final NotificationService notificationService;
    private boolean devMode = false;

    public TemporalAnnouncementActivationJobHandlerImpl(NotificationService notificationService) {
        this.notificationService = notificationService;
        this.devMode = false;
    }

    @Override
    public void execute(JobInfo jobInfo) {
        this.logger.info("Executing of temporal activation job for Announcer ");
        Date now = new Date();
        List<Notification> notifications = this.notificationService.getAllNotifications();
        if (CollectionUtils.isEmpty(notifications)) {
            return;
        }
        for (Notification notification : notifications) {
            if (notification == null) continue;
            this.notificationService.handleNotificationStatus(notification, now);
        }
    }
}

