/*
 * Decompiled with CFR 0.152.
 */
package com.appfire.common.analytics.core;

import com.appfire.common.analytics.bean.EventDetails;
import com.appfire.common.analytics.bean.GlobalEventData;
import com.appfire.common.analytics.core.AnalyticsClientCallback;
import com.appfire.common.analytics.core.AnalyticsService;
import com.appfire.common.analytics.util.AnalyticsUtil;
import io.keen.client.java.JavaKeenClientBuilder;
import io.keen.client.java.KeenClient;
import io.keen.client.java.KeenProject;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalyticsServiceImpl
implements AnalyticsService {
    private static final Logger log = LoggerFactory.getLogger(AnalyticsServiceImpl.class);
    private KeenClient keenClient;
    private final String projectKey;
    private final String writeKey;
    private final GlobalEventData globalData;

    public AnalyticsServiceImpl(String projectKey, String writeKey, GlobalEventData globalData) {
        this.projectKey = projectKey;
        this.writeKey = writeKey;
        this.globalData = globalData;
        this.keenClient = new JavaKeenClientBuilder().build();
        this.initializeKeenClient();
    }

    public KeenClient getKeenClient() {
        return this.keenClient;
    }

    @Override
    public void addEvent(EventDetails eventDetails) {
        this.postEvent(eventDetails);
    }

    @Override
    public void addEvent(String eventType, Map<String, Object> eventData) {
        this.postEvent(eventType, eventData);
    }

    @Override
    public void addEvents(Collection<EventDetails> eventDetailsList) {
        this.postEvents(eventDetailsList);
    }

    private void postEvent(EventDetails eventDetails) {
        if (eventDetails != null && StringUtils.isNotBlank(eventDetails.getCollectionName())) {
            this.postEvent(eventDetails.getCollectionName(), eventDetails.getEventData());
        }
    }

    private void postEvent(final String eventType, final Map<String, Object> eventData) {
        try {
            ExecutorService executor = Executors.newSingleThreadExecutor();
            executor.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        Map<String, Object> eventDataMap = AnalyticsUtil.buildEventDataMap(eventData);
                        AnalyticsClientCallback callback = new AnalyticsClientCallback(eventDataMap);
                        log.debug("Posting analytics with collection name : " + eventType);
                        AnalyticsServiceImpl.this.keenClient.addEventAsync(null, eventType, eventDataMap, null, callback);
                    }
                    catch (Exception e) {
                        log.debug("Error while posting event", (Throwable)e);
                    }
                }
            });
            executor.shutdown();
        }
        catch (Exception e) {
            log.debug("Error with executor service which is used for posting event", (Throwable)e);
        }
    }

    private void postEvents(final Collection<EventDetails> eventDetailsList) {
        if (eventDetailsList != null && eventDetailsList.size() > 0) {
            log.debug("Events count:" + eventDetailsList.size());
            try {
                ExecutorService executor = Executors.newSingleThreadExecutor();
                executor.submit(new Runnable(){

                    @Override
                    public void run() {
                        eventDetailsList.forEach(eventDetails -> {
                            Map<String, Object> eventDataMap = AnalyticsUtil.buildEventDataMap(eventDetails);
                            AnalyticsClientCallback callback = new AnalyticsClientCallback(eventDataMap);
                            log.debug("Posting analytics with collection name : " + eventDetails.getCollectionName());
                            AnalyticsServiceImpl.this.keenClient.addEventAsync(null, eventDetails.getCollectionName(), eventDataMap, null, callback);
                        });
                    }
                });
                executor.shutdown();
            }
            catch (Exception e) {
                log.debug("Error while posting analytics data", (Throwable)e);
            }
        }
    }

    private void initializeKeenClient() {
        try {
            KeenClient.initialize(this.keenClient);
            log.debug("initialized client.");
            KeenProject keenProject = new KeenProject(this.projectKey, this.writeKey, null);
            this.keenClient.setDefaultProject(keenProject);
            this.keenClient.setGlobalProperties(AnalyticsUtil.buildGlobalProps(this.globalData));
        }
        catch (Throwable e) {
            log.debug("Error while initializing keen client", e);
        }
    }
}

