/*
 * Decompiled with CFR 0.152.
 */
package com.wittified.servlets.statuspage;

import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.google.common.collect.Lists;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.wittified.ao.statuspage.StatusPageConfig;
import com.wittified.licensecounters.LicenseCounter;
import com.wittified.services.statuspage.StatusPageService;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusPageServlet
extends HttpServlet {
    private static final long serialVersionUID = -2936136143008640936L;
    private static Logger logger = LoggerFactory.getLogger(StatusPageServlet.class);
    private final TemplateRenderer templateRenderer;
    private final WebResourceManager webResourceManager;
    private final UserManager userManager;
    private final StatusPageService statusPageService;
    private final LicenseCounter licenseCounter;
    private final PluginSettings settings;

    public StatusPageServlet(TemplateRenderer templateRenderer, WebResourceManager webResourceManager, UserManager userManager, PluginSettingsFactory pluginSettingsFactory, WebSudoManager webSudoManager, StatusPageService statusPageService, LicenseCounter licenseCounter, PluginSettingsFactory settingsFactory) {
        this.templateRenderer = templateRenderer;
        this.webResourceManager = webResourceManager;
        this.userManager = userManager;
        this.statusPageService = statusPageService;
        this.licenseCounter = licenseCounter;
        this.settings = settingsFactory.createSettingsForKey("com.wittified.atl-announcer:atl-announcer");
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.webResourceManager.requireResourcesForContext("atl-statuspage-announcer");
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("product", this.licenseCounter.getApplicationType());
        UserKey userKey = this.userManager.getRemoteUserKey();
        if (userKey != null && this.userManager.isAdmin(userKey)) {
            Properties props = (Properties)this.settings.get("com.wittified.atl-announcer:atl-announcer:token-config");
            if (props != null && props.getProperty("apiToken") != null) {
                StatusPageConfig[] configLists = this.statusPageService.getAllStatusPageConfigs();
                List<JSONObject> pages = null;
                context.put("configs", Arrays.asList(configLists));
                context.put("token", props);
                context.put("req", req);
                context.put("product", this.licenseCounter.getApplicationType());
                context.put("projects", this.licenseCounter.getAllProjects(this.userManager.getRemoteUser().getUsername()));
                context.put("groups", this.userManager.findGroupNamesByPrefix("", 0, 1000));
                context.put("action", (Object)this);
                try {
                    pages = this.statusPageService.getPages(props.getProperty("baseUrl"), props.getProperty("apiToken"));
                }
                catch (ClientHandlerException | UniformInterfaceException | JSONException e) {
                    logger.error("Error while contacting StatusPage.io.: " + e.getMessage());
                    context.put("message", "Error while contacting StatusPage.io.");
                }
                ArrayList filteredPages = Lists.newArrayList();
                for (StatusPageConfig existing : configLists) {
                    for (JSONObject page : pages) {
                        try {
                            if (existing.getPage().equalsIgnoreCase(page.getString("name"))) continue;
                            filteredPages.add(page);
                        }
                        catch (JSONException e) {
                            logger.error("error  while filtering pages" + e.getMessage());
                        }
                    }
                }
                context.put("pages", pages);
                context.put("license", this.statusPageService.getCheckLicense());
                context.put("contextPath", req.getContextPath());
            } else {
                context.put("message", "Authentication token in not configured properly. please check this");
            }
            res.setContentType("text/html");
            this.render("/templates/statuspage/statuspage-list.vm", context, res);
        } else {
            context.put("message", "The user that you're currently logged in as is not an administrator. This page is limited to administrator access.");
            res.setContentType("text/html");
            this.render("/templates/security-breach.vm", context, res);
        }
    }

    protected void render(String template, Map<String, Object> context, HttpServletResponse response) throws IOException {
        this.templateRenderer.render(template, context, (Writer)response.getWriter());
    }
}

