/*
 * Decompiled with CFR 0.152.
 */
package com.wittified.servlets.statuspage;

import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import com.wittified.ao.statuspage.Incident;
import com.wittified.licensecounters.LicenseCounter;
import com.wittified.services.statuspage.StatusPageService;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusPageBubblesServlet
extends HttpServlet {
    private static final long serialVersionUID = -4654725919931941042L;
    private static Logger logger = LoggerFactory.getLogger(StatusPageBubblesServlet.class);
    private final TemplateRenderer templateRenderer;
    private final WebResourceManager webResourceManager;
    private final UserManager userManager;
    private final StatusPageService statusPageService;
    private final PluginSettings settings;
    private final LicenseCounter licenseCounter;

    public StatusPageBubblesServlet(TemplateRenderer templateRenderer, WebResourceManager webResourceManager, UserManager userManager, PluginSettingsFactory pluginSettingsFactory, WebSudoManager webSudoManager, StatusPageService statusPageService, PluginSettingsFactory settingsFactory, LicenseCounter licenseCounter) {
        this.templateRenderer = templateRenderer;
        this.webResourceManager = webResourceManager;
        this.userManager = userManager;
        this.statusPageService = statusPageService;
        this.settings = settingsFactory.createSettingsForKey("com.wittified.atl-announcer:atl-announcer");
        this.licenseCounter = licenseCounter;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.webResourceManager.requireResourcesForContext("atl-statuspage-announcer");
        HashMap<String, Object> context = new HashMap<String, Object>();
        res.setContentType("text/html");
        UserKey userKey = this.userManager.getRemoteUserKey();
        if (userKey != null && this.userManager.isAdmin(userKey)) {
            Properties props = (Properties)this.settings.get("com.wittified.atl-announcer:atl-announcer:token-config");
            HashMap<String, JSONObject> activeIncidents = new HashMap<String, JSONObject>();
            if (props != null) {
                Incident[] incidents = this.statusPageService.getAllIncidents();
                try {
                    for (int i = 0; i < incidents.length; ++i) {
                        JSONObject incidentObject = this.getIncidentObject(incidents[i]);
                        activeIncidents.put(incidents[i].getKey(), incidentObject);
                    }
                }
                catch (ClientHandlerException | UniformInterfaceException | JSONException e) {
                    context.put("message", "Error while retrieving status page data : " + e.getMessage());
                    this.render("/templates/security-breach.vm", context, res);
                }
            }
            context.put("dateFormatter", this.licenseCounter);
            context.put("req", req);
            context.put("product", this.licenseCounter.getApplicationType());
            context.put("license", this.statusPageService.getCheckLicense());
            context.put("contextPath", req.getContextPath());
            context.put("activeIncidents", activeIncidents);
            this.render("/templates/statuspage/statuspage-bubbles-list.vm", context, res);
        } else {
            context.put("message", "The user that you're currently logged in as is not an administrator. This page is limited to administrator access.");
            this.render("/templates/security-breach.vm", context, res);
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String key = req.getParameter("incident-key");
        boolean status = Boolean.valueOf(req.getParameter("status"));
        this.statusPageService.updateStatus(key, status);
        res.sendRedirect(req.getContextPath() + "/plugins/servlet/wittified/admin/statuspage/bubbles/list");
    }

    private JSONObject getPageObject(String pageKey, JSONArray pages) throws JSONException {
        JSONObject pageObject = null;
        for (int n = 0; n < pages.length(); ++n) {
            JSONObject object = pages.getJSONObject(n);
            if (!object.getString("id").equalsIgnoreCase(pageKey)) continue;
            pageObject = object;
            break;
        }
        return pageObject;
    }

    protected void render(String template, Map<String, Object> context, HttpServletResponse response) throws IOException {
        this.templateRenderer.render(template, context, (Writer)response.getWriter());
    }

    private ClientResponse getResponse(String apiToken, String url) {
        Client client = Client.create();
        WebResource webResource = client.resource(url);
        ClientResponse clientResponse = (ClientResponse)((WebResource.Builder)((WebResource.Builder)webResource.header("Authorization", (Object)("OAuth " + apiToken)).type("application/json")).accept(new String[]{"application/json"})).get(ClientResponse.class);
        int statusCode = clientResponse.getStatus();
        if (statusCode == 401) {
            logger.error("Authentication Error");
            return null;
        }
        return clientResponse;
    }

    private JSONArray getPages(String baseUrl, String apiToken) throws ClientHandlerException, UniformInterfaceException, JSONException {
        JSONArray pages = new JSONArray((String)this.getResponse(apiToken, baseUrl).getEntity(String.class));
        return pages;
    }

    private JSONObject getIncidentObject(Incident incident) throws JSONException {
        JSONObject incidentObj = new JSONObject();
        incidentObj.put("status", incident.getStatus());
        incidentObj.put("title", (Object)incident.getTitle());
        incidentObj.put("startDate", (Object)incident.getStartDate());
        incidentObj.put("updatedDate", (Object)incident.getUpdatedDate());
        incidentObj.put("key", (Object)incident.getKey());
        return incidentObj;
    }
}

