/*
 * Decompiled with CFR 0.152.
 */
package com.wittified.services;

import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.wittified.rest.entities.GlobalConfiguration;
import com.wittified.services.GlobalConfigurationService;

public class GlobalConfigurationServiceImpl
implements GlobalConfigurationService {
    private final PluginSettingsFactory pluginSettingsFactory;

    public GlobalConfigurationServiceImpl(PluginSettingsFactory pluginSettingsFactory) {
        this.pluginSettingsFactory = pluginSettingsFactory;
    }

    @Override
    public GlobalConfiguration getGlobalConfiguration() {
        GlobalConfiguration config = new GlobalConfiguration();
        config.setUserAgent(this.getUserAgent());
        config.setDialogHeight(this.getDialogHeight());
        config.setDelegationConfig(this.getProjectConfigEnabled());
        config.setExplainerText(this.getRemindMeLaterExplainerText());
        config.setRemindMeLater(this.getRemindMeLaterEnabled());
        config.setRemindMeLaterText(this.getRemindMeLaterText());
        config.setRemindMeLaterTime(this.getRemindMeLaterTime());
        config.setValidHTMLTagsAndAttributes(this.getValidHTMLTagsAndAttributes());
        config.setUsageAnalytics(this.getUsageAnalytics());
        config.setIgnoreUrls(this.getIgnoreUrls());
        return config;
    }

    @Override
    public boolean getProjectConfigEnabled() {
        String value = (String)this.pluginSettingsFactory.createGlobalSettings().get("wittified.announcer.projects");
        if (value == null) {
            return false;
        }
        return Boolean.parseBoolean(value);
    }

    @Override
    public String getUserAgent() {
        String value = (String)this.pluginSettingsFactory.createGlobalSettings().get("wittified.announcer.ignored.userAgents");
        if (value == null) {
            return "";
        }
        return value;
    }

    @Override
    public String getDialogHeight() {
        String value = (String)this.pluginSettingsFactory.createGlobalSettings().get("wittified.announcer.dialog.height");
        if (value == null) {
            return "500";
        }
        return value;
    }

    @Override
    public boolean getRemindMeLaterEnabled() {
        String value = (String)this.pluginSettingsFactory.createGlobalSettings().get("wittified.announcer.remindmelater");
        if (value == null) {
            return false;
        }
        return Boolean.parseBoolean(value);
    }

    @Override
    public String getRemindMeLaterText() {
        String value = (String)this.pluginSettingsFactory.createGlobalSettings().get("wittified.announcer.remindmelater.text");
        if (value == null) {
            return "Remind Me Later";
        }
        return value;
    }

    @Override
    public Integer getRemindMeLaterTime() {
        Integer value;
        try {
            value = Integer.parseInt((String)this.pluginSettingsFactory.createGlobalSettings().get("wittified.announcer.remindmelater.time"));
        }
        catch (NumberFormatException e) {
            return 240;
        }
        if (value == null) {
            return 240;
        }
        return value;
    }

    @Override
    public String getRemindMeLaterExplainerText() {
        String value = (String)this.pluginSettingsFactory.createGlobalSettings().get("wittified.announcer.remindmelater.explainer.text");
        if (value == null) {
            return "By selecting %CONFIRM% you will no longer be prompted by this announcement unless you revoke the acknowledgment \nby going to your user profile. \n%REMIND% will temporarily dismiss this announcement without submitting your acknowledgement.";
        }
        return value;
    }

    @Override
    public String getValidHTMLTagsAndAttributes() {
        String value = (String)this.pluginSettingsFactory.createGlobalSettings().get("wittified.announcer.html.whitelist.tags");
        if (value == null) {
            return "tags=a, b, i, u, h1, h2, h3, h4, h5, h6, div, font, strong, style\na.attributes=href, target\nfont.attributes=size, color\ndiv.attributes=class, style";
        }
        return value;
    }

    @Override
    public boolean getUsageAnalytics() {
        String value = (String)this.pluginSettingsFactory.createGlobalSettings().get("wittified.announcer.analytics");
        if (value == null) {
            return true;
        }
        return Boolean.parseBoolean(value);
    }

    private String getIgnoreUrls() {
        String value = (String)this.pluginSettingsFactory.createGlobalSettings().get("wittified.announcer.ignored.urls");
        if (value == null) {
            return "";
        }
        return value;
    }
}

