/*
 * Decompiled with CFR 0.152.
 */
package com.wittified.job;

import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.scheduler.compat.CompatibilityPluginScheduler;
import com.wittified.job.AnonUserCleanJobHandler;
import com.wittified.job.StatuspageJobHandler;
import com.wittified.job.TemporalAnnouncementActivationJobHandler;
import com.wittified.job.WittifiedJobScheduler;
import java.util.Calendar;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WittifiedJobSchedulerImpl
implements WittifiedJobScheduler {
    Logger logger = LoggerFactory.getLogger(WittifiedJobSchedulerImpl.class);
    private final CompatibilityPluginScheduler pluginScheduler;
    private final PluginSettings pluginSettings;

    public WittifiedJobSchedulerImpl(CompatibilityPluginScheduler pluginScheduler, PluginSettingsFactory settingsFactory) {
        this.pluginScheduler = pluginScheduler;
        this.pluginSettings = settingsFactory.createSettingsForKey("com.wittified.atl-announcer:atl-announcer");
    }

    public void onStart() {
        this.reschedule();
    }

    @Override
    public void reschedule() {
        Calendar cal = Calendar.getInstance();
        cal.add(12, 5);
        this.logger.info("Scheduling temporal announcement activation to run every 5 minutes starting at" + cal.getTime());
        this.pluginScheduler.scheduleClusteredJob("Temporal announcement activation job for id=", TemporalAnnouncementActivationJobHandler.TEMPORAL_ANNOUNCEMENT_ACTIVATION_KEY, cal.getTime(), 300000L);
        cal.add(12, 5);
        this.logger.info("Scheduling clean up anonymous usersto run every 15 minutes starting at" + cal.getTime());
        this.pluginScheduler.scheduleClusteredJob("Anonymous user clean job", AnonUserCleanJobHandler.CLEAN_UP_JOB, cal.getTime(), 900000L);
        this.logger.info("Scheduling Status page job ");
        Properties props = (Properties)this.pluginSettings.get("com.wittified.atl-announcer:atl-announcer:token-config");
        if (props != null) {
            int schedule = Integer.parseInt(props.getProperty("pollingFreq"));
            this.pluginScheduler.scheduleClusteredJob("STATUS_PAGE : ", StatuspageJobHandler.STATUS_PAGE_JOB, cal.getTime(), schedule * 60 * 1000);
        } else {
            this.logger.warn("failed to Scheduling Status page job as there is no token configuration");
        }
    }

    @Override
    public void stop() {
        this.pluginScheduler.unscheduleClusteredJob("Temporal announcement activation job for id=");
        this.pluginScheduler.unscheduleClusteredJob("Anonymous user clean job");
        this.pluginScheduler.unscheduleClusteredJob("STATUS_PAGE : ");
    }
}

