/*
 * Decompiled with CFR 0.152.
 */
package com.wittified.servlets.statuspage;

import com.atlassian.confluence.schedule.ScheduledJobKey;
import com.atlassian.confluence.schedule.managers.ScheduledJobManager;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.scheduler.compat.CompatibilityPluginScheduler;
import com.atlassian.spring.container.ContainerManager;
import com.google.gson.JsonObject;
import com.wittified.AnnouncerHelper;
import com.wittified.job.StatuspageJobHandler;
import com.wittified.licensecounters.ConfluenceLicenseCounter;
import com.wittified.licensecounters.LicenseCounter;
import com.wittified.services.ReflectionHelper;
import com.wittified.services.statuspage.StatusPageCron;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Calendar;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;

public class TokenConfigServlet
extends HttpServlet {
    private static final long serialVersionUID = 1143970687556917286L;
    private final PluginSettings pluginSettings;
    public static final String TOKEN_CONFIG = "com.wittified.atl-announcer:atl-announcer:token-config";
    public static final String PLUGIN_TOKEN_CONFIG = "com.wittified.atl-announcer:atl-announcer";
    public static final String BASE_URL = "baseUrl";
    public static final String API_TOKEN = "apiToken";
    public static final String POLLING_FREQ = "pollingFreq";
    public static final String ANNOUNCEMENT_PREFIX = "announcementPrefix";
    private final LicenseCounter counter;
    private final CompatibilityPluginScheduler pluginScheduler;
    private final UserManager userManager;
    private final String STATUSPAGE_URL = "https://api.statuspage.io";
    private final String DEFAULT_STATUSPAGE_URI = "/v1/pages/";

    public TokenConfigServlet(PluginSettingsFactory pluginSettingsFactory, WebSudoManager webSudoManager, CompatibilityPluginScheduler pluginScheduler, WebResourceManager webResourceManager, LicenseCounter counter, UserManager userManager) {
        this.pluginSettings = pluginSettingsFactory.createSettingsForKey(PLUGIN_TOKEN_CONFIG);
        this.pluginScheduler = pluginScheduler;
        webResourceManager.requireResourcesForContext("atl-statuspage-announcer");
        this.counter = counter;
        this.userManager = userManager;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        if (!AnnouncerHelper.isAdminUser(this.userManager)) {
            return;
        }
        String baseUrl = this.getStatuspageUrl(req.getParameter(BASE_URL));
        String apiToken = req.getParameter(API_TOKEN);
        String pollingFreq = req.getParameter(POLLING_FREQ);
        String announcementPrefix = req.getParameter(ANNOUNCEMENT_PREFIX);
        Properties map = new Properties();
        map.put(BASE_URL, baseUrl);
        map.put(API_TOKEN, apiToken);
        map.put(POLLING_FREQ, pollingFreq);
        map.put(ANNOUNCEMENT_PREFIX, announcementPrefix);
        this.pluginSettings.put(TOKEN_CONFIG, (Object)map);
        ScheduledJobManager manager = null;
        if (this.counter instanceof ConfluenceLicenseCounter) {
            Object scheduledJobManagerObject = ContainerManager.getComponent((String)"scheduledJobManager");
            if (scheduledJobManagerObject instanceof ScheduledJobManager) {
                manager = (ScheduledJobManager)scheduledJobManagerObject;
            }
            String cronString = StatusPageCron.cronString(pollingFreq);
            ReflectionHelper.updateSchedule(manager, new ScheduledJobKey("com.wittified.atl-announcer-confluence", "status-page-Confluence"), cronString);
        } else {
            Calendar cal = Calendar.getInstance();
            cal.add(12, 1);
            this.pluginScheduler.scheduleClusteredJob("STATUS_PAGE : ", StatuspageJobHandler.STATUS_PAGE_JOB, cal.getTime(), Integer.parseInt(pollingFreq) * 60 * 1000);
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        if (!AnnouncerHelper.isAdminUser(this.userManager)) {
            return;
        }
        Properties map = null;
        JsonObject json = new JsonObject();
        map = (Properties)this.pluginSettings.get(TOKEN_CONFIG);
        if (map == null) {
            map = new Properties();
        }
        json.addProperty(BASE_URL, map.getProperty(BASE_URL));
        json.addProperty(API_TOKEN, map.getProperty(API_TOKEN));
        json.addProperty(POLLING_FREQ, map.getProperty(POLLING_FREQ));
        json.addProperty(ANNOUNCEMENT_PREFIX, map.getProperty(ANNOUNCEMENT_PREFIX));
        res.setContentType("application/json");
        res.setCharacterEncoding("UTF-8");
        PrintWriter out = res.getWriter();
        out.print(json.toString());
    }

    private String getStatuspageUrl(String baseUrl) {
        if (StringUtils.isNoneBlank(baseUrl) && baseUrl.toLowerCase().startsWith("https://api.statuspage.io")) {
            return baseUrl;
        }
        return "https://api.statuspage.io/v1/pages/";
    }
}

