/*
 * Decompiled with CFR 0.152.
 */
package com.wittified.servlets.statuspage;

import com.wittified.ao.statuspage.StatusPageConfig;
import com.wittified.services.statuspage.StatusPageService;
import java.io.IOException;
import java.util.Arrays;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusPageValidationServlet
extends HttpServlet {
    private static final long serialVersionUID = 8517238029401635583L;
    private static Logger logger = LoggerFactory.getLogger(StatusPageValidationServlet.class);
    private final StatusPageService statusPageService;

    public StatusPageValidationServlet(StatusPageService statusPageService) {
        this.statusPageService = statusPageService;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String name = req.getParameter("name");
        String[] pages = req.getParameter("status-pages").split(",");
        String method = req.getParameter("method");
        boolean nameExists = false;
        boolean pageExists = false;
        StatusPageConfig[] configs = this.statusPageService.getAllStatusPageConfigs();
        if (method != null && method.equalsIgnoreCase("UPDATE")) {
            int id = Integer.parseInt(req.getParameter("configId"));
            nameExists = Arrays.asList(configs).stream().anyMatch(config -> config.getTitle().equalsIgnoreCase(name) && config.getID() != id);
            pageExists = Arrays.asList(configs).stream().anyMatch(config -> config.getPage().equalsIgnoreCase(pages[0]) && config.getID() != id);
        } else {
            nameExists = Arrays.asList(configs).stream().anyMatch(config -> config.getTitle().equalsIgnoreCase(name));
            pageExists = Arrays.asList(configs).stream().anyMatch(config -> config.getPage().equalsIgnoreCase(pages[0]));
        }
        if (nameExists) {
            logger.warn("name already exists. choose different name.");
            res.sendError(409, "name:name already exists. choose different name");
        }
        if (pageExists) {
            logger.warn("Statuspage:configuration already exists for this status page.");
            res.sendError(500, "Statuspage:configuration already exists for this status page.");
        }
    }
}

