/*
 * Decompiled with CFR 0.152.
 */
package com.wittified.listeners;

import com.atlassian.bitbucket.auth.AuthenticationResult;
import com.atlassian.bitbucket.auth.HttpAuthenticationContext;
import com.atlassian.bitbucket.auth.HttpAuthenticationHandler;
import com.atlassian.bitbucket.auth.HttpLogoutHandler;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.sal.api.user.UserManager;
import com.wittified.ao.Notification;
import com.wittified.ao.NotificationService;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class BitbucketHttpLogoutHandler
implements HttpAuthenticationHandler,
HttpLogoutHandler {
    private static final Logger logger = Logger.getLogger(BitbucketHttpLogoutHandler.class);
    private final NotificationService notificationService;
    private final UserManager userManager;

    public BitbucketHttpLogoutHandler(NotificationService notificationService, UserManager userManager) {
        this.notificationService = notificationService;
        this.userManager = userManager;
    }

    public void logout(@Nonnull ApplicationUser applicationUser, @Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse) {
        String username = applicationUser.getName();
        logger.debug((Object)String.format("Logout called for user %s, Userprofile %s ", username, this.userManager.getUserProfile(username)));
        List<Notification> notifications = this.notificationService.getAllResetEnabledNotifications();
        notifications.forEach(notification -> this.notificationService.unConfirmThisNotificationForUser(notification.getID(), this.userManager.getUserProfile(username)));
    }

    public void validateAuthentication(@Nonnull HttpAuthenticationContext httpAuthenticationContext) {
    }

    @Nullable
    public ApplicationUser authenticate(@Nonnull HttpAuthenticationContext httpAuthenticationContext) {
        return null;
    }

    @Nullable
    public AuthenticationResult performAuthentication(@Nonnull HttpAuthenticationContext httpAuthenticationContext) {
        return null;
    }
}

