/*
 * Decompiled with CFR 0.152.
 */
package com.wittified.job;

import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.wittified.ao.Notification;
import com.wittified.ao.NotificationService;
import com.wittified.job.AnnouncerReportJobRunner;
import com.wittified.licensecounters.LicenseCounter;
import com.wittified.services.ReportService;
import java.io.File;
import java.io.FileWriter;
import org.apache.commons.csv.CSVPrinter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnouncerReportJobRunnerImpl
implements AnnouncerReportJobRunner {
    private static final Logger logger = LoggerFactory.getLogger(AnnouncerReportJobRunnerImpl.class);
    private final ReportService reportService;
    private final NotificationService notificationService;
    private final LicenseCounter licensecounter;

    public AnnouncerReportJobRunnerImpl(ReportService reportService, NotificationService notificationService, LicenseCounter licensecounter) {
        this.reportService = reportService;
        this.notificationService = notificationService;
        this.licensecounter = licensecounter;
    }

    public JobRunnerResponse runJob(JobRunnerRequest request) {
        Integer notificationId = (Integer)request.getJobConfig().getParameters().get("notificationId");
        String toUserKey = (String)request.getJobConfig().getParameters().get("currentUserKey");
        if (notificationId == null) {
            return JobRunnerResponse.failed((String)("Tried to run job " + request.getJobId() + " without an awesomeId parameter?!"));
        }
        Notification theNotification = this.notificationService.getThisNotification(notificationId);
        if (theNotification == null) {
            return JobRunnerResponse.failed((String)("The notification with id=" + notificationId + " no longer exists!"));
        }
        try {
            this.notificationService.saveNotificationExportStatus(theNotification, true);
            String exportedFilePath = this.reportService.fetchExportFilePath(theNotification);
            File file = new File(exportedFilePath);
            FileWriter fw = new FileWriter(file);
            CSVPrinter csvFilePrinter = this.reportService.exportCSV(theNotification, fw);
            if (csvFilePrinter != null) {
                csvFilePrinter.flush();
                csvFilePrinter.close();
            }
            logger.debug("Announcer - Preparing to send mail");
            this.licensecounter.sendEmail(theNotification, toUserKey, exportedFilePath);
            this.notificationService.saveNotificationExportStatus(theNotification, false);
            return JobRunnerResponse.success();
        }
        catch (Exception e) {
            this.notificationService.saveNotificationExportStatus(theNotification, false);
            e.printStackTrace();
            logger.error("Email cannot be sent due to this error : " + e.getMessage() + "-" + e.getCause());
            return JobRunnerResponse.failed((Throwable)e);
        }
    }
}

