/*
 * Decompiled with CFR 0.152.
 */
package com.wittified.job;

import com.atlassian.scheduler.compat.JobInfo;
import com.wittified.ao.AnonUser;
import com.wittified.ao.Notification;
import com.wittified.ao.NotificationService;
import com.wittified.job.AnonUserCleanJobHandler;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnonUserCleanJobHandlerImpl
implements AnonUserCleanJobHandler {
    private final Logger logger = LoggerFactory.getLogger(AnonUserCleanJobHandlerImpl.class);
    private final NotificationService notificationService;

    public AnonUserCleanJobHandlerImpl(NotificationService notificationService) {
        this.notificationService = notificationService;
    }

    @Override
    public void execute(JobInfo jobInfo) {
        this.logger.info("Executing of clean up job for Announcer ");
        int numDays = -30;
        Calendar cal = Calendar.getInstance();
        cal.add(5, numDays);
        Date cutOffDate = cal.getTime();
        for (Notification notification : this.getAllNotificationsWithAnon()) {
            long dwellTime = 0L;
            int count = 0;
            for (AnonUser anonUser : notification.getAnonUsers()) {
                if (anonUser.getCreated() == null) {
                    this.setCreatedDate(anonUser);
                    continue;
                }
                if (!anonUser.getCreated().before(cutOffDate)) continue;
                dwellTime += this.getDwellTimeForUser(notification, anonUser.getID());
                ++count;
                this.removeAnonUser(notification, anonUser);
                this.logger.debug("Cleaning up " + anonUser.getAnonId());
            }
            this.updateNotificationCount(notification, count, dwellTime);
        }
    }

    public List<Notification> getAllNotificationsWithAnon() {
        ArrayList<Notification> notifications = new ArrayList<Notification>();
        for (Notification notification : this.notificationService.getAllNotifications()) {
            if (!notification.getAnonymous()) continue;
            notifications.add(notification);
        }
        return notifications;
    }

    public long getDwellTimeForUser(Notification notification, int anonId) {
        return this.notificationService.getAnonDwellTime(notification.getID(), anonId);
    }

    public void updateNotificationCount(Notification notification, int num, long dwell) {
        Integer currNumber = notification.getNumAnon();
        if (currNumber == null) {
            currNumber = 0;
        }
        currNumber = currNumber + num;
        Long dwellTime = notification.getTotalAnonDwell();
        if (dwellTime == null) {
            dwellTime = 0L;
        }
        dwellTime = dwellTime + dwell;
        notification.setNumAnon(currNumber);
        notification.setTotalAnonDwell(dwellTime);
        this.notificationService.saveNotification(notification);
    }

    public void removeAnonUser(Notification notification, AnonUser anonUser) {
        this.notificationService.deleteAnonUser(notification.getID(), anonUser.getAnonId());
    }

    public void setCreatedDate(AnonUser anonUser) {
        this.notificationService.getNotificationAnon(anonUser.getAnonId());
    }
}

