/*
 * Decompiled with CFR 0.152.
 */
package com.wittified.format;

import com.atlassian.cache.CacheLoader;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.wittified.AnnouncerHelper;
import com.wittified.format.NotificationFormat;
import javax.validation.constraints.NotNull;
import org.pegdown.PegDownProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormattedCacheLoader
implements CacheLoader<NotificationFormat, String> {
    private final PluginSettingsFactory pluginSettingsFactory;
    private static final Logger logger = LoggerFactory.getLogger(FormattedCacheLoader.class);

    public FormattedCacheLoader(PluginSettingsFactory pluginSettingsFactory) {
        this.pluginSettingsFactory = pluginSettingsFactory;
    }

    public String load(@NotNull NotificationFormat entry) {
        return this.format(entry);
    }

    public String format(NotificationFormat entry) {
        logger.debug("Generating new entry " + entry.getContent());
        String contents = entry.getContent();
        if (entry.getFormat() == 0) {
            contents = entry.getContent();
        } else if (entry.getFormat() == 2) {
            contents = "<p>" + entry.getContent().replaceAll("\n", "</p><p>") + "</p>";
        } else if (entry.getFormat() == 1) {
            PegDownProcessor processor = new PegDownProcessor();
            contents = processor.markdownToHtml(entry.getContent());
        }
        logger.debug("Returning " + contents);
        return AnnouncerHelper.getContentWithWhitelistedTagsOnly(this.pluginSettingsFactory, contents);
    }
}

