/*
 * Decompiled with CFR 0.152.
 */
package com.wittified.listeners;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.event.user.LoginEvent;
import com.atlassian.jira.event.user.UserEvent;
import com.atlassian.sal.api.user.UserManager;
import com.wittified.ao.Notification;
import com.wittified.ao.NotificationService;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class JiraUserEventListener
implements InitializingBean,
DisposableBean {
    private static final Logger logger = Logger.getLogger(JiraUserEventListener.class);
    private final NotificationService notificationService;
    private EventPublisher eventPublisher;
    private Class[] handledClasses = new Class[]{LoginEvent.class};
    private final UserManager userManager;

    public JiraUserEventListener(EventPublisher eventPublisher, NotificationService notificationService, UserManager userManager) {
        this.eventPublisher = eventPublisher;
        this.notificationService = notificationService;
        this.userManager = userManager;
    }

    @EventListener
    public void handleEvent(UserEvent event) {
        if (event instanceof LoginEvent) {
            String username = event.getUser().getUsername();
            logger.debug((Object)String.format("LoginEvent fired for username %s, Userprofile %s ", username, this.userManager.getUserProfile(username)));
            List<Notification> notifications = this.notificationService.getAllResetEnabledNotifications();
            notifications.forEach(notification -> this.notificationService.unConfirmThisNotificationForUser(notification.getID(), this.userManager.getUserProfile(username)));
        }
    }

    public Class[] getHandledEventClasses() {
        return this.handledClasses;
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }

    public void afterPropertiesSet() throws Exception {
        this.eventPublisher.register((Object)this);
    }
}

