/*
 * Decompiled with CFR 0.152.
 */
package com.wittified.services;

import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.wittified.services.TokenChangeService;
import java.util.UUID;

public class TokenChangeServiceImpl
implements TokenChangeService {
    private final PluginSettingsFactory pluginSettingsFactory;
    private String currentToken;
    private long invalidateTime;

    public TokenChangeServiceImpl(PluginSettingsFactory pluginSettingsFactory) {
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.currentToken = null;
        this.invalidateTime = -1L;
    }

    @Override
    public String updateToken() {
        long currentTime = System.currentTimeMillis();
        String newToken = UUID.randomUUID().toString();
        newToken = newToken + "-" + currentTime;
        this.pluginSettingsFactory.createGlobalSettings().put("wittified.announcer.changeToken", (Object)newToken);
        this.currentToken = newToken;
        return this.currentToken;
    }

    @Override
    public String getToken() {
        long currentTime = System.currentTimeMillis();
        if (currentTime > this.invalidateTime) {
            this.currentToken = null;
            this.invalidateTime += 60000L;
        }
        if (this.currentToken != null) {
            return this.currentToken;
        }
        String token = (String)this.pluginSettingsFactory.createGlobalSettings().get("wittified.announcer.changeToken");
        if (token == null) {
            return this.updateToken();
        }
        return token;
    }

    @Override
    public void clearToken() {
        this.currentToken = null;
    }
}

