/*
 * Decompiled with CFR 0.152.
 */
package com.wittified.services;

import com.atlassian.migration.app.AccessScope;
import com.atlassian.migration.app.gateway.AppCloudMigrationGateway;
import com.atlassian.migration.app.gateway.MigrationDetailsV1;
import com.atlassian.migration.app.listener.DiscoverableListener;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.wittified.ao.AnnouncerDataService;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class MigrationAssistantServiceImpl
implements DiscoverableListener,
InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(MigrationAssistantServiceImpl.class);
    private PluginLicenseManager licenseManager;
    private static AnnouncerDataService announcerDataService;

    public MigrationAssistantServiceImpl(PluginLicenseManager pluginLicenseManager, AnnouncerDataService announcerDataService) {
        System.out.println("In MigrationAssistantServiceImpl constructor....");
        this.licenseManager = pluginLicenseManager;
        MigrationAssistantServiceImpl.announcerDataService = announcerDataService;
    }

    @Override
    public void onStartAppMigration(AppCloudMigrationGateway gateway, String transferId, MigrationDetailsV1 migrationDetailsV1) {
        JSONObject announcerData = new JSONObject();
        System.out.println("Starting Announcer app migration");
        log.info("Starting Announcer app migration");
        try {
            List notificationsList = announcerDataService.getAllNotifications().stream().collect(Collectors.toList());
            List notificationUserList = announcerDataService.getAllNotificationUsers().stream().collect(Collectors.toList());
            List anonUserList = announcerDataService.getAllAnonUsers().stream().collect(Collectors.toList());
            List notificationToAnonUsersList = announcerDataService.getAllNotificationToAnonUsers().stream().collect(Collectors.toList());
            List notificationToNotificationUsersList = announcerDataService.getAllNotificationToNotificationUsers().stream().collect(Collectors.toList());
            announcerData.put("notifications", notificationsList);
            announcerData.put("notificationUser", notificationUserList);
            announcerData.put("notificationToNotificationUsersList", notificationToNotificationUsersList);
            announcerData.put("notificationToAnonUsersList", notificationToAnonUsersList);
            announcerData.put("anonUserList", anonUserList);
            announcerData.put("globalConfiguration", (Object)announcerDataService.getGlobalConfiguration());
            log.info("Announcer Migration Data: " + announcerData.toString());
            System.out.println("Announcer Migration Data: " + announcerData.toString());
            gateway.getCloudFeedbackIfPresent(transferId).ifPresent(it -> log.info("Cloud feedback found"));
            OutputStream appData = gateway.createAppData(transferId);
            appData.write(announcerData.toString().getBytes());
            appData.close();
        }
        catch (Exception e) {
            try {
                JSONObject announcerMigrationException = new JSONObject().put("message", (Object)e.getMessage());
                announcerMigrationException.append("stacktrace", (Object)e.getStackTrace());
                log.error("Migration Exception: " + e.getMessage(), (Throwable)e);
                System.out.println("Migration Exception: " + e.getMessage());
            }
            catch (JSONException ex) {
                ex.printStackTrace();
            }
        }
        log.info("Announcer app migration ends");
        System.out.println("Announcer app migration ends");
    }

    @Override
    public String getCloudAppKey() {
        return this.licenseManager.getPluginKey();
    }

    @Override
    public String getServerAppKey() {
        return this.licenseManager.getPluginKey();
    }

    @Override
    public Set<AccessScope> getDataAccessScopes() {
        return Stream.of(AccessScope.APP_DATA_OTHER, AccessScope.PRODUCT_DATA_OTHER, AccessScope.MIGRATION_TRACING_IDENTITY, AccessScope.MIGRATION_TRACING_PRODUCT).collect(Collectors.toCollection(HashSet::new));
    }

    public void destroy() throws Exception {
        log.debug("destroying the migration assistance service instance");
    }

    public void afterPropertiesSet() throws Exception {
    }
}

