/*
 * Decompiled with CFR 0.152.
 */
package com.wittified.services;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.wittified.services.ConfigurationService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationServiceImpl
implements ConfigurationService,
LifecycleAware {
    private final ApplicationProperties applicationProperties;
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationServiceImpl.class);
    private String[] tags = null;

    public ConfigurationServiceImpl(ApplicationProperties applicationProperties) {
        this.applicationProperties = applicationProperties;
    }

    @Override
    public String[] getValidTags() {
        return this.tags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onStart() {
        File configFile = new File(this.applicationProperties.getHomeDirectory(), "wittified-announcer.properties");
        if (configFile.exists()) {
            InputStream inputStream = null;
            try {
                Properties properties = new Properties();
                inputStream = new FileInputStream(configFile);
                properties.load(inputStream);
                if (properties.containsKey("validtags")) {
                    String validTags = properties.getProperty("validtags").toLowerCase();
                    validTags = validTags.replaceAll("[^a-z,]", "");
                    this.tags = validTags.split(",");
                } else {
                    this.tags = null;
                }
            }
            catch (FileNotFoundException fnfe) {
                logger.info("No configuration file available - Announcer is using default configuration");
            }
            catch (IOException ioExeption) {
                logger.error("Encountered error while reading Announcer's configuration file: " + ioExeption.getMessage());
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Exception e) {
                        logger.error("Error encountered closing file " + e.getMessage());
                    }
                    inputStream = null;
                }
            }
        }
    }

    public void onStop() {
    }
}

