/*
 * Decompiled with CFR 0.152.
 */
package com.wittified.rest;

import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.status.JobDetails;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.wittified.ao.Notification;
import com.wittified.ao.NotificationService;
import com.wittified.job.AnnouncerReportJobRunner;
import com.wittified.licensecounters.LicenseCounter;
import com.wittified.rest.entities.report.NotificationReport;
import com.wittified.rest.entities.report.UserReport;
import com.wittified.services.ReportService;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/admin/report")
public class ReportEndPoint {
    private static final Logger logger = LoggerFactory.getLogger(ReportEndPoint.class);
    private final int EXPORT_USER_SIZE = 2000;
    private static final String JOB_ID_PREFIX = "AnnouncerJob for id=";
    private final NotificationService notificationService;
    private final LicenseCounter licenseCounter;
    private final ReportService reportService;
    private final SchedulerService schedulerService;

    public ReportEndPoint(NotificationService notificationService, LicenseCounter licenseCounter, ReportService reportService, SchedulerService schedulerService) {
        this.notificationService = notificationService;
        this.licenseCounter = licenseCounter;
        this.reportService = reportService;
        this.schedulerService = schedulerService;
    }

    @Path(value="/{id}/export-csv/status")
    @Produces(value={"application/json"})
    @GET
    public Response checkExportProgress(@PathParam(value="id") Integer id, @Context HttpServletResponse response) {
        Notification theNotification = this.notificationService.getThisNotification(id);
        if (theNotification == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)String.format("This notification with ID: %s has not been found. Skipping report generation.", String.valueOf(id))).build();
        }
        WeakHashMap<String, Boolean> result = new WeakHashMap<String, Boolean>();
        result.put("isExportCsv", theNotification.getActiveExportCsv());
        return Response.ok(result).build();
    }

    @Path(value="/{id}/export-csv")
    @Produces(value={"application/octet-stream"})
    @GET
    public Response exportReportAsCSV(@PathParam(value="id") Integer id, @Context HttpServletResponse response) {
        block9: {
            Notification theNotification = this.notificationService.getThisNotification(id);
            int totalUsers = 0;
            if (theNotification == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)String.format("This notification with ID: %s has not been found. Skipping report generation.", String.valueOf(id))).build();
            }
            totalUsers = theNotification.getFilterGroups() && StringUtils.isNotBlank((String)theNotification.getGroupTarget()) ? this.reportService.getUsersFromGroups(theNotification.getGroupTarget()).size() : this.reportService.getTotalUsers("").size();
            try {
                if (totalUsers > 2000) {
                    if ("CONFLUENCE".equals(this.licenseCounter.getApplicationType())) {
                        this.licenseCounter.scheduleAnnouncerReportJob(id);
                        break block9;
                    }
                    ImmutableMap parameters = ImmutableMap.of((Object)"notificationId", (Object)theNotification.getID(), (Object)"currentUserKey", (Object)this.licenseCounter.getCurrentUserKey());
                    JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)AnnouncerReportJobRunner.ANNOUNCER_JOB).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withParameters((Map)parameters);
                    logger.debug("Scheduling job with the job config =" + jobConfig);
                    try {
                        JobId jobId = this.toJobId(theNotification);
                        JobDetails existing = this.schedulerService.getJobDetails(jobId);
                        if (existing != null) {
                            logger.debug("We will be replacing an existing job with jobId=" + jobId + ": " + existing);
                        }
                        this.schedulerService.scheduleJob(jobId, jobConfig);
                        logger.debug("Successfully scheduled jobId=" + jobId);
                        break block9;
                    }
                    catch (SchedulerServiceException sse) {
                        logger.error(sse.getLocalizedMessage());
                        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)String.format("Unable to create job for  the announcement with '%s'. Skipping report generation.", theNotification.getTitle())).build();
                    }
                }
                OutputStreamWriter osw = new OutputStreamWriter((OutputStream)response.getOutputStream(), "UTF-8");
                CSVPrinter csvFilePrinter = this.reportService.exportCSV(theNotification, osw);
                if (csvFilePrinter != null) {
                    response.setHeader("Content-Disposition", "attachment; filename=announcer_report_" + System.currentTimeMillis() + ".csv");
                    response.setContentType("text/csv");
                    csvFilePrinter.flush();
                }
            }
            catch (Exception e) {
                logger.error("Announcer-report-export : Exception while export", (Throwable)e);
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)String.format("Unable to create job for the announcement with '%s'. Skipping report generation.", theNotification.getTitle())).build();
            }
        }
        return Response.ok().build();
    }

    private JobId toJobId(Notification theNotification) {
        return JobId.of((String)(JOB_ID_PREFIX + theNotification.getID()));
    }

    @Path(value="/{id}/{page}")
    @GET
    @Produces(value={"application/json"})
    public Response notificationReport(@PathParam(value="id") Integer id, @PathParam(value="page") Integer page, @QueryParam(value="startPage") Integer startPage, @QueryParam(value="endPage") Integer endPage, @QueryParam(value="status") String status, @QueryParam(value="pageSize") Integer pageSize, @QueryParam(value="searchTerm") String searchTerm) {
        Notification notification = this.notificationService.getThisNotification(id);
        if (notification == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        if (StringUtils.isBlank((String)status)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        if (!status.equals("all") && !status.equals("accepted")) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        Map<String, Object> usersMap = this.fetchUserDetails(notification, status, pageSize, page, searchTerm);
        NotificationReport report = this.getNotificationReport(page, startPage, endPage, pageSize, usersMap);
        ObjectMapper mapper = new ObjectMapper();
        mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        String reportResponse = null;
        try {
            reportResponse = mapper.writeValueAsString(report);
        }
        catch (JsonProcessingException e) {
            logger.debug(String.format("Failed to process JSON acceptance report: %s", e.getMessage()));
        }
        return Response.ok((Object)reportResponse).build();
    }

    private Map<String, Object> fetchUserDetails(Notification theNotification, String status, int usersPerPage, int page, String searchTerm) {
        Map<Object, Object> usersMap = new WeakHashMap();
        if (theNotification.getFilterGroups() && theNotification.getGroupTarget() != null && !theNotification.getGroupTarget().trim().equals("")) {
            logger.debug("Using filtered groups");
            usersMap = this.reportService.getUsersInGroup(theNotification, searchTerm, status, usersPerPage, page);
        } else {
            logger.debug("Using all groups");
            usersMap = this.reportService.getActiveUsers(theNotification, searchTerm, status, usersPerPage, page);
        }
        return usersMap;
    }

    private NotificationReport getNotificationReport(Integer page, Integer startPage, Integer endPage, int usersPerPage, Map<String, Object> usersMap) {
        NotificationReport report = new NotificationReport();
        List users = (List)usersMap.get("users");
        int totalSize = (Integer)usersMap.get("userSize");
        report.setSize(totalSize);
        int totalPages = (int)Math.ceil((float)totalSize / (float)usersPerPage);
        if (endPage == -1) {
            endPage = totalPages >= 5 ? 5 : totalPages;
        }
        if (totalSize == users.size() && totalSize > usersPerPage) {
            users = totalSize >= (page - 1) * usersPerPage + usersPerPage ? users.subList((page - 1) * usersPerPage, (page - 1) * usersPerPage + usersPerPage) : users.subList((page - 1) * usersPerPage, totalSize);
        }
        Collections.sort(users, Comparator.comparing(UserReport::getAcceptedDate, Comparator.nullsLast(Comparator.reverseOrder())));
        report.setUsers(users);
        int position = this.getPagePosition(startPage, page, endPage);
        if (position == 0 || page == 1 || page == totalPages) {
            report.setStartPage(startPage);
            report.setEndPage(endPage);
        } else if (position == -1) {
            if (page - 1 == 1) {
                report.setStartPage(startPage);
                report.setEndPage(endPage);
            } else {
                report.setStartPage(startPage - 1);
                report.setEndPage(endPage - 1);
            }
        } else if (position == -2) {
            if (page - 1 == 1) {
                report.setStartPage(startPage - 1);
                report.setEndPage(endPage - 1);
            } else {
                report.setStartPage(startPage - 2);
                report.setEndPage(endPage - 2);
            }
        } else if (position == 1) {
            if (page + 1 == totalPages) {
                report.setStartPage(startPage);
                report.setEndPage(endPage);
            } else {
                report.setStartPage(startPage + 1);
                report.setEndPage(endPage + 1);
            }
        } else if (position == 2) {
            if (page + 1 == totalPages) {
                report.setStartPage(startPage + 1);
                report.setEndPage(endPage + 1);
            } else {
                report.setStartPage(startPage + 2);
                report.setEndPage(endPage + 2);
            }
        } else {
            report.setStartPage(startPage);
            report.setEndPage(endPage);
        }
        return report;
    }

    private int getPagePosition(Integer startPage, Integer page, Integer endPage) {
        int sum = 0;
        int middleNo = 0;
        for (int i = startPage.intValue(); i <= endPage; ++i) {
            sum += i;
        }
        middleNo = sum / 5;
        if (page == middleNo) {
            return 0;
        }
        if (page > middleNo && page == endPage) {
            return 2;
        }
        if (page > middleNo && page < endPage) {
            return 1;
        }
        if (page < middleNo && page == startPage) {
            return -2;
        }
        if (page < middleNo && page > startPage) {
            return -1;
        }
        return 0;
    }
}

