/*
 * Decompiled with CFR 0.152.
 */
package com.wittified.rest;

import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.wittified.AnnouncerHelper;
import com.wittified.analytics.AnnouncerAnalytics;
import com.wittified.analytics.EventType;
import com.wittified.ao.AnnouncerDataService;
import com.wittified.ao.Notification;
import com.wittified.ao.NotificationService;
import com.wittified.job.RecurringAnnouncementScheduler;
import com.wittified.licensecounters.LicenseCounter;
import com.wittified.rest.dto.NotificationUpsertDTO;
import com.wittified.services.TokenChangeService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/admin")
public class NotificationEndPoint {
    private final NotificationService notificationService;
    private final UserManager userManager;
    private final LicenseCounter licenseCounter;
    private final Logger logger = LoggerFactory.getLogger(NotificationEndPoint.class);
    private final AnnouncerAnalytics announcerAnalytics;
    private final RecurringAnnouncementScheduler recurringAnnouncementScheduler;
    private final AnnouncerDataService announcerDataService;
    private final TokenChangeService tokenChangeService;

    public NotificationEndPoint(NotificationService notificationService, UserManager userManager, LicenseCounter licenseCounter, AnnouncerAnalytics announcerAnalytics, RecurringAnnouncementScheduler recurringAnnouncementScheduler, AnnouncerDataService announcerDataService, TokenChangeService tokenChangeService) {
        this.notificationService = notificationService;
        this.userManager = userManager;
        this.licenseCounter = licenseCounter;
        this.announcerAnalytics = announcerAnalytics;
        this.recurringAnnouncementScheduler = recurringAnnouncementScheduler;
        this.announcerDataService = announcerDataService;
        this.tokenChangeService = tokenChangeService;
    }

    @Path(value="/delete/{id}")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response deleteThisNotification(@PathParam(value="id") String idStr, Map<String, String> data) {
        this.logger.debug(String.format("Deleting notification %s", idStr));
        UserKey userkey = this.userManager.getRemoteUserKey();
        Notification notification = this.notificationService.getThisNotification(Integer.parseInt(idStr));
        if (notification != null) {
            if (!this.userManager.isAdmin(userkey)) {
                boolean blocked = true;
                if (notification.getFilterProject()) {
                    String pKey = notification.getTargetProject();
                    if (pKey != null) {
                        pKey = pKey.replaceAll(":", "");
                    }
                    if (notification.getTargetProject().contains(pKey) && this.licenseCounter.currentUserCanEdit(pKey)) {
                        blocked = false;
                    }
                }
                if (blocked) {
                    return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
                }
            }
            WeakHashMap<String, Object> eventDataMap = new WeakHashMap<String, Object>();
            eventDataMap.put("type", EventType.ANNOUNCEMENT_DELETED.toString());
            eventDataMap.put("Operation", EventType.ANNOUNCEMENT_DELETED.toString());
            this.announcerAnalytics.postEventInfo(EventType.ANNOUNCEMENT_DELETED, eventDataMap);
            this.notificationService.deleteNotification(notification);
            if (notification.getCustomRecurrenceOption()) {
                this.logger.debug(String.format("Stopping scheduled job for notification %s", notification.getTitle()));
                this.recurringAnnouncementScheduler.unscheduleJob(notification);
            }
        } else {
            this.logger.debug("This notification does not exist");
            return Response.ok().build();
        }
        return Response.ok(data).build();
    }

    @Path(value="/reset/{id}")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response resetThisNotification(@PathParam(value="id") Integer id, Map<String, String> data) {
        this.logger.debug(String.format("Resetting notification %s", id));
        UserKey userkey = this.userManager.getRemoteUserKey();
        Notification notification = this.notificationService.getThisNotification(id);
        if (!this.userManager.isAdmin(userkey)) {
            boolean blocked = true;
            if (notification.getFilterProject()) {
                String pKey = notification.getTargetProject();
                if (pKey != null) {
                    pKey = pKey.replaceAll(":", "");
                }
                if (notification.getTargetProject().contains(pKey) && this.licenseCounter.currentUserCanEdit(pKey)) {
                    blocked = false;
                }
            }
            if (blocked) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
        }
        this.notificationService.resetNotification(notification);
        return Response.ok(data).build();
    }

    @Path(value="/enable-all")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response enableAllNotification(Map<String, String> data) {
        this.logger.debug(String.format("Enabling all notifications", new Object[0]));
        UserKey userkey = this.userManager.getRemoteUserKey();
        if (!this.userManager.isAdmin(userkey)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        for (Notification notification : this.notificationService.getAllNotifications()) {
            notification.setActive(true);
            this.notificationService.saveNotification(notification);
        }
        return Response.ok(data).build();
    }

    @Path(value="/notifications/status")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateNotificationStatus(ArrayList<Map<String, Boolean>> data) {
        this.logger.debug(String.format("Enabling/Disabling specified notifications", new Object[0]));
        UserKey userkey = this.userManager.getRemoteUserKey();
        if (!this.userManager.isAdmin(userkey)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        for (Map<String, Boolean> notificationMap : data) {
            Set<String> notificationIds = notificationMap.keySet();
            for (String key : notificationIds) {
                Notification notification = this.notificationService.getThisNotification(Integer.parseInt(key));
                if (notification == null) continue;
                if (notificationMap.get(key).booleanValue()) {
                    notification.setActive(true);
                } else {
                    notification.setActive(false);
                }
                this.notificationService.saveNotification(notification);
            }
        }
        return Response.ok(data).build();
    }

    @Path(value="/all-groups")
    @GET
    @Produces(value={"application/json"})
    public Response getAllGroups() {
        this.logger.debug(String.format("Getting all groups", new Object[0]));
        UserKey userKey = this.userManager.getRemoteUserKey();
        if (userKey == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        ArrayList<String> groups = new ArrayList<String>();
        if (this.userManager.isAdmin(userKey)) {
            for (String group : this.userManager.findGroupNamesByPrefix("", 0, 1000)) {
                groups.add(group);
            }
        } else {
            for (String group : this.userManager.findGroupNamesByPrefix("", 0, 1000)) {
                if (!this.userManager.isUserInGroup(userKey, group)) continue;
                groups.add(group);
            }
        }
        return Response.ok(groups).build();
    }

    @Path(value="/is-user-admin")
    @GET
    @Produces(value={"application/json"})
    public Response isCurrentUserAnAdmin() {
        UserKey userKey = this.userManager.getRemoteUserKey();
        HashMap<String, String> map = new HashMap<String, String>();
        if (userKey != null && this.userManager.isAdmin(userKey)) {
            map.put("isAdmin", "true");
        } else {
            map.put("isAdmin", "false");
        }
        return Response.ok(map).build();
    }

    @Path(value="/notifications/")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getAllNotifications() throws JSONException {
        this.logger.debug(String.format("getting all notifications using REST API", new Object[0]));
        UserKey userkey = this.userManager.getRemoteUserKey();
        if (!this.userManager.isAdmin(userkey)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        List<Notification> notificationsV2 = this.announcerDataService.getAllNotificationsV2();
        ArrayList notifications = new ArrayList();
        for (Notification notiff : notificationsV2) {
            HashMap<String, String> notificationsMap = new HashMap<String, String>();
            notificationsMap.put("active", String.valueOf(notiff.getActive()));
            notificationsMap.put("button_text", String.valueOf(notiff.getButtonText()));
            notificationsMap.put("delay_button", String.valueOf(notiff.getDelayButton()));
            notificationsMap.put("display", String.valueOf(notiff.getDisplay()));
            notificationsMap.put("format", String.valueOf(notiff.getFormat()));
            notificationsMap.put("contents", String.valueOf(notiff.getHtml()));
            notificationsMap.put("reset_button", String.valueOf(notiff.getResetButton()));
            notificationsMap.put("show_button", String.valueOf(notiff.getShowButton()));
            notificationsMap.put("title", String.valueOf(notiff.getTitle()));
            notificationsMap.put("type", String.valueOf(notiff.getType()));
            notificationsMap.put("anonymous", String.valueOf(notiff.getAnonymous()));
            notificationsMap.put("is_required", String.valueOf(notiff.getIsRequired()));
            notificationsMap.put("id", String.valueOf(notiff.getID()));
            notificationsMap.put("temp_active", String.valueOf(notiff.getTempActive()));
            notificationsMap.put("total_anon_dwell", String.valueOf(notiff.getTotalAnonDwell()));
            notificationsMap.put("num_anon", String.valueOf(notiff.getNumAnon()));
            notificationsMap.put("date_restrict", String.valueOf(notiff.getDateRestrict()));
            notificationsMap.put("description", String.valueOf(notiff.getDescription()));
            notificationsMap.put("filter_groups", String.valueOf(notiff.getFilterGroups()));
            notificationsMap.put("filter_project", String.valueOf(notiff.getFilterProject()));
            notificationsMap.put("target", String.valueOf(notiff.getTargetProject()));
            notificationsMap.put("start_date", String.valueOf(notiff.getStartDate()));
            notificationsMap.put("end_date", String.valueOf(notiff.getEndDate()));
            notificationsMap.put("group_target", String.valueOf(notiff.getGroupTarget()));
            notifications.add(notificationsMap);
        }
        return Response.ok(notifications).build();
    }

    @Path(value="/notifications/")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createNotification(List<NotificationUpsertDTO> notificationDTOArray) {
        this.logger.debug(String.format("Creating notifications using REST API", new Object[0]));
        if (!AnnouncerHelper.isAdminUser(this.userManager)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        for (NotificationUpsertDTO notificationDTO : notificationDTOArray) {
            Notification notification = this.notificationService.createNewNotification();
            this.buildNotification(notification, notificationDTO);
            this.notificationService.saveNotification(notification);
            notificationDTO.setId(String.valueOf(notification.getID()));
        }
        return Response.ok(notificationDTOArray).build();
    }

    @Path(value="/notifications/{id}")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateNotification(@PathParam(value="id") String id, NotificationUpsertDTO notificationDTO) {
        this.logger.debug(String.format("updating notification: %s", id));
        UserKey userkey = this.userManager.getRemoteUserKey();
        if (!this.userManager.isAdmin(userkey)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        Notification notification = this.notificationService.getThisNotification(Integer.parseInt(id));
        if (notification == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        this.buildNotification(notification, notificationDTO);
        this.notificationService.saveNotification(notification);
        this.logger.debug(String.format("updated notification: %s", id));
        notificationDTO.setId(id);
        return Response.ok((Object)notificationDTO).build();
    }

    private void buildNotification(Notification notification, NotificationUpsertDTO notificationDTO) {
        notification.setTitle(notificationDTO.getTitle());
        notification.setDescription(notificationDTO.getDescription());
        notification.setType(notificationDTO.getType());
        notification.setButtonText(notificationDTO.getButtonText());
        notification.setDisplay(Integer.parseInt(notificationDTO.getDisplayType()));
        notification.setActive(Boolean.parseBoolean(notificationDTO.getIsActive()));
        notification.setTempActive(notification.getActive());
        notification.setHtml(notificationDTO.getContents());
        notification.setDelayButton(Boolean.parseBoolean(notificationDTO.getDelayButton()));
        notification.setAnonymous(Boolean.parseBoolean(notificationDTO.getAnonymous()));
        notification.setShowButton(Boolean.valueOf(notificationDTO.getShowButton()));
        notification.setFormat(Integer.parseInt(notificationDTO.getFormat()));
        notification.setFilterGroups(Boolean.parseBoolean(notificationDTO.getFilterGroups()) && StringUtils.isNotBlank(notificationDTO.getTargetGroup()));
        notification.setGroupTarget(StringUtils.isNotEmpty(notificationDTO.getTargetGroup()) ? notificationDTO.getTargetGroup().replace(" ", "") : null);
    }

    @Path(value="/notifications/{id}")
    @DELETE
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response deleteNotification(@PathParam(value="id") String idStr) {
        this.logger.debug(String.format("Deleting notification %s", idStr));
        UserKey userkey = this.userManager.getRemoteUserKey();
        Notification notification = this.notificationService.getThisNotification(Integer.parseInt(idStr));
        if (notification != null) {
            if (!this.userManager.isAdmin(userkey)) {
                boolean blocked = true;
                if (notification.getFilterProject()) {
                    String pKey = notification.getTargetProject();
                    if (pKey != null) {
                        pKey = pKey.replaceAll(":", "");
                    }
                    if (notification.getTargetProject().contains(pKey) && this.licenseCounter.currentUserCanEdit(pKey)) {
                        blocked = false;
                    }
                }
                if (blocked) {
                    return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
                }
            }
            WeakHashMap<String, Object> eventDataMap = new WeakHashMap<String, Object>();
            eventDataMap.put("type", EventType.ANNOUNCEMENT_DELETED.toString());
            eventDataMap.put("Operation", EventType.ANNOUNCEMENT_DELETED.toString());
            this.announcerAnalytics.postEventInfo(EventType.ANNOUNCEMENT_DELETED, eventDataMap);
            this.notificationService.deleteNotification(notification);
            if (notification.getCustomRecurrenceOption()) {
                this.logger.debug(String.format("Stopping scheduled job for notification %s", notification.getTitle()));
                this.recurringAnnouncementScheduler.unscheduleJob(notification);
            }
        } else {
            this.logger.debug("This notification does not exist");
            return Response.ok((Object)Response.Status.NOT_FOUND).build();
        }
        return Response.ok((Object)String.format("Deleted notification %s", idStr)).build();
    }
}

