/*
 * Decompiled with CFR 0.152.
 */
package com.wittified.cache;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationCacheEntry {
    private static final Logger logger = LoggerFactory.getLogger(NotificationCacheEntry.class);
    private static final String FIELD_DELIMITER = "WITTIFIED::DELIMITED::WITTIFIED";
    public int ID;
    public String html;
    public String title;
    public String description;
    public int format;
    public String type;
    public boolean isRequired;
    public boolean isAnonymous;
    public boolean filterGroups;
    public int numAnon;
    public long totalAnonDwell;
    public String groupTarget;
    public boolean active;
    public boolean delayButton;
    public String buttonText;
    public boolean filterProject;
    public String targetProject;
    public boolean filterProjectRole;
    public String targetProjectRole;
    public int displayType;
    public boolean showButton;
    public boolean resetButton;
    public boolean filterProjectCategory;
    public String targetProjectCategories;
    public boolean isNewUser;
    public boolean tempActive;

    public NotificationCacheEntry() {
        this.ID = -1;
        this.html = null;
        this.title = null;
        this.description = null;
        this.format = -1;
        this.type = null;
        this.isRequired = false;
        this.isAnonymous = true;
        this.filterGroups = false;
        this.numAnon = 0;
        this.totalAnonDwell = 0L;
        this.groupTarget = null;
        this.active = false;
        this.delayButton = false;
        this.buttonText = null;
        this.filterProject = false;
        this.targetProject = null;
        this.filterProjectRole = false;
        this.targetProjectRole = null;
        this.showButton = true;
        this.displayType = 0;
        this.resetButton = false;
        this.filterProjectCategory = false;
        this.targetProjectCategories = "";
        this.isNewUser = false;
        this.tempActive = false;
    }

    public NotificationCacheEntry(String serialized) {
        logger.debug(serialized);
        String[] arr = serialized.split(FIELD_DELIMITER);
        this.ID = Integer.parseInt(arr[0]);
        this.html = arr[1];
        this.title = arr[2];
        this.description = arr[3];
        this.format = Integer.parseInt(arr[4]);
        this.type = arr[5];
        this.isRequired = Boolean.parseBoolean(arr[6]);
        this.isAnonymous = Boolean.parseBoolean(arr[7]);
        this.filterGroups = Boolean.parseBoolean(arr[8]);
        this.numAnon = Integer.parseInt(arr[9]);
        this.totalAnonDwell = Long.parseLong(arr[10]);
        this.groupTarget = arr[11];
        this.active = Boolean.parseBoolean(arr[12]);
        this.buttonText = arr[13];
        this.delayButton = Boolean.parseBoolean(arr[14]);
        this.filterProject = Boolean.parseBoolean(arr[15]);
        if (this.buttonText.equalsIgnoreCase("null")) {
            this.buttonText = null;
        }
        if (arr.length > 16) {
            this.targetProject = arr[16];
        }
        if (arr.length > 17) {
            this.filterProjectRole = Boolean.parseBoolean(arr[17]);
        }
        if (arr.length > 18) {
            this.targetProjectRole = arr[18];
        }
        if (arr.length > 19) {
            this.showButton = Boolean.parseBoolean(arr[19]);
        }
        if (arr.length > 20) {
            this.displayType = Integer.parseInt(arr[20]);
        }
        if (arr.length > 21) {
            this.resetButton = Boolean.parseBoolean(arr[21]);
        }
        if (arr.length > 22) {
            this.filterProjectCategory = Boolean.parseBoolean(arr[22]);
        }
        if (arr.length > 23) {
            this.targetProjectCategories = arr[23];
        }
        if (arr.length > 24) {
            this.isNewUser = Boolean.parseBoolean(arr[24]);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.ID);
        stringBuffer.append(FIELD_DELIMITER);
        stringBuffer.append(this.html);
        stringBuffer.append(FIELD_DELIMITER);
        stringBuffer.append(this.title);
        stringBuffer.append(FIELD_DELIMITER);
        stringBuffer.append(this.description);
        stringBuffer.append(FIELD_DELIMITER);
        stringBuffer.append(this.format);
        stringBuffer.append(FIELD_DELIMITER);
        stringBuffer.append(this.type);
        stringBuffer.append(FIELD_DELIMITER);
        stringBuffer.append(this.isRequired);
        stringBuffer.append(FIELD_DELIMITER);
        stringBuffer.append(this.isAnonymous);
        stringBuffer.append(FIELD_DELIMITER);
        stringBuffer.append(this.filterGroups);
        stringBuffer.append(FIELD_DELIMITER);
        stringBuffer.append(this.numAnon);
        stringBuffer.append(FIELD_DELIMITER);
        stringBuffer.append(this.totalAnonDwell);
        stringBuffer.append(FIELD_DELIMITER);
        stringBuffer.append(this.groupTarget);
        stringBuffer.append(FIELD_DELIMITER);
        stringBuffer.append(this.active);
        stringBuffer.append(FIELD_DELIMITER);
        stringBuffer.append(this.buttonText);
        stringBuffer.append(FIELD_DELIMITER);
        stringBuffer.append(this.delayButton);
        stringBuffer.append(FIELD_DELIMITER);
        stringBuffer.append(this.filterProject);
        stringBuffer.append(FIELD_DELIMITER);
        stringBuffer.append(this.targetProject);
        stringBuffer.append(FIELD_DELIMITER);
        stringBuffer.append(this.filterProjectRole);
        stringBuffer.append(FIELD_DELIMITER);
        stringBuffer.append(this.targetProjectRole);
        stringBuffer.append(FIELD_DELIMITER);
        stringBuffer.append(this.showButton);
        stringBuffer.append(FIELD_DELIMITER);
        stringBuffer.append(this.displayType);
        stringBuffer.append(FIELD_DELIMITER);
        stringBuffer.append(this.resetButton);
        stringBuffer.append(FIELD_DELIMITER);
        stringBuffer.append(this.filterProjectCategory);
        stringBuffer.append(FIELD_DELIMITER);
        stringBuffer.append(this.targetProjectCategories);
        stringBuffer.append(FIELD_DELIMITER);
        stringBuffer.append(this.isNewUser);
        return stringBuffer.toString();
    }

    public int getID() {
        return this.ID;
    }

    public void setID(int ID) {
        this.ID = ID;
    }

    public String getHtml() {
        return this.html;
    }

    public void setHtml(String html) {
        this.html = html;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getFormat() {
        return this.format;
    }

    public void setFormat(int format) {
        this.format = format;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean getIsRequired() {
        return this.isRequired;
    }

    public void setIsRequired(boolean required) {
        this.isRequired = required;
    }

    public boolean getAnonymous() {
        return this.isAnonymous;
    }

    public void setAnonymous(boolean anonymous) {
        this.isAnonymous = anonymous;
    }

    public void setFilterGroups(boolean filterGroups) {
        this.filterGroups = filterGroups;
    }

    public boolean getFilterGroups() {
        return this.filterGroups;
    }

    public Integer getNumAnon() {
        return this.numAnon;
    }

    public void setNumAnon(Integer numAnon) {
        this.numAnon = numAnon;
    }

    public Long getTotalAnonDwell() {
        return this.totalAnonDwell;
    }

    public void setTotalAnonDwell(Long dwell) {
        this.totalAnonDwell = dwell;
    }

    public String getGroupTarget() {
        return this.groupTarget;
    }

    public void setGroupTarget(String groupTarget) {
        this.groupTarget = groupTarget;
    }

    public boolean getActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public String getButtonText() {
        if (this.buttonText != null && this.buttonText.equalsIgnoreCase("null")) {
            return null;
        }
        return this.buttonText;
    }

    public void setButtonText(String text) {
        this.buttonText = text;
    }

    public boolean getDelayButton() {
        return this.delayButton;
    }

    public void setDelayButton(boolean delayButton) {
        this.delayButton = delayButton;
    }

    public void setTargetProject(String targetProject) {
        this.targetProject = targetProject;
    }

    public String getTargetProject() {
        return this.targetProject;
    }

    public void setFilterProject(boolean filterProject) {
        this.filterProject = filterProject;
    }

    public boolean getFilterProject() {
        return this.filterProject;
    }

    public boolean isShowButton() {
        return this.showButton;
    }

    public void setShowButton(boolean showButton) {
        this.showButton = showButton;
    }

    public int getDisplayType() {
        return this.displayType;
    }

    public void setDisplayType(int displayType) {
        this.displayType = displayType;
    }

    public boolean isResetButton() {
        return this.resetButton;
    }

    public void setResetButton(boolean resetButton) {
        this.resetButton = resetButton;
    }

    public boolean getFilterProjectCategory() {
        return this.filterProjectCategory;
    }

    public void setFilterProjectCategory(boolean filterProjectCategory) {
        this.filterProjectCategory = filterProjectCategory;
    }

    public String getTargetProjectCategories() {
        return this.targetProjectCategories;
    }

    public void setTargetProjectCategories(String targetProjectCategories) {
        this.targetProjectCategories = targetProjectCategories;
    }

    public boolean getFilterProjectRole() {
        return this.filterProjectRole;
    }

    public void setFilterProjectRole(boolean filterProjectRole) {
        this.filterProjectRole = filterProjectRole;
    }

    public String getTargetProjectRole() {
        return this.targetProjectRole;
    }

    public void setTargetProjectRole(String targetProjectRole) {
        this.targetProjectRole = targetProjectRole;
    }

    public boolean isNewUser() {
        return this.isNewUser;
    }

    public void setNewUser(boolean isNewUser) {
        this.isNewUser = isNewUser;
    }
}

