/*
 * Decompiled with CFR 0.152.
 */
package com.wittified.ao;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.tx.Transactional;
import com.wittified.ao.AnnouncerDataService;
import com.wittified.ao.AnonUser;
import com.wittified.ao.Notification;
import com.wittified.ao.NotificationToAnonUser;
import com.wittified.ao.NotificationToNotificationUser;
import com.wittified.ao.NotificationUser;
import com.wittified.services.GlobalConfigurationService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.java.ao.Query;
import org.json.JSONException;
import org.json.JSONObject;

public class AnnouncerDataServiceImpl
implements AnnouncerDataService {
    private final ActiveObjects activeObjects;
    private static GlobalConfigurationService globalConfigurationService;

    public AnnouncerDataServiceImpl(ActiveObjects activeObjects, GlobalConfigurationService globalConfigurationService) {
        this.activeObjects = activeObjects;
        AnnouncerDataServiceImpl.globalConfigurationService = globalConfigurationService;
    }

    @Override
    @Transactional
    public Collection<JSONObject> getAllAnonUsers() {
        ArrayList<JSONObject> anonUsers = new ArrayList<JSONObject>();
        this.activeObjects.stream(AnonUser.class, Query.select((String)"ANON_ID, CREATED, ID"), anonUser -> {
            JSONObject notificationJson = new JSONObject();
            try {
                notificationJson.put("notifications", (Object)anonUser.getNotifications());
                notificationJson.put("anonId", (Object)anonUser.getAnonId());
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            anonUsers.add(notificationJson);
        });
        return anonUsers;
    }

    @Override
    @Transactional
    public void saveNotificationExportStatus(Notification notification, boolean status) {
        notification.setActiveExportCsv(status);
        notification.save();
    }

    @Override
    @Transactional
    public Collection<JSONObject> getAllNotifications() {
        ArrayList<JSONObject> notifications = new ArrayList<JSONObject>();
        this.activeObjects.stream(Notification.class, Query.select((String)"ACTIVE, ANONYMOUS, BUTTON_TEXT, DATE_RESTRICT, DELAY_BUTTON, DESCRIPTION, DISPLAY, END_DATE, FILTER_GROUPS, FILTER_PROJECT, FILTER_CATEGORY, FILTER_PROJECT_ROLE, FORMAT, GROUP_TARGET, HTML, ID, IS_REQUIRED, NUM_ANON, RESET_BUTTON, SHOW_BUTTON, START_DATE, TARGET_CATEGORIES, TARGET_PROJECT, TARGET_PROJECT_ROLE, TEMP_ACTIVE, TITLE, TOTAL_ANON_DWELL, TYPE"), notification -> {
            JSONObject jsonObject = new JSONObject();
            try {
                jsonObject.put("active", notification.getActive());
                jsonObject.put("button_text", (Object)notification.getButtonText());
                jsonObject.put("date_restrict", (Object)notification.getDateRestrict());
                jsonObject.put("delay_button", notification.getDelayButton());
                jsonObject.put("description", (Object)notification.getDescription());
                jsonObject.put("display", (Object)notification.getDisplay());
                jsonObject.put("end_date", (Object)notification.getEndDate());
                jsonObject.put("filter_groups", notification.getFilterGroups());
                jsonObject.put("filter_project", notification.getFilterProject());
                jsonObject.put("format", notification.getFormat());
                jsonObject.put("html", (Object)notification.getHtml());
                jsonObject.put("reset_button", notification.getResetButton());
                jsonObject.put("show_button", (Object)notification.getShowButton());
                jsonObject.put("target", (Object)notification.getTargetProject());
                jsonObject.put("title", (Object)notification.getTitle());
                jsonObject.put("type", (Object)notification.getType());
                jsonObject.put("start_date", (Object)notification.getStartDate());
                jsonObject.put("anonymous", notification.getAnonymous());
                jsonObject.put("group_target", (Object)notification.getGroupTarget());
                jsonObject.put("is_required", notification.getIsRequired());
                jsonObject.put("num_anon", (Object)notification.getNumAnon());
                jsonObject.put("id", notification.getID());
                jsonObject.put("temp_active", (Object)notification.getTempActive());
                jsonObject.put("total_anon_dwell", (Object)notification.getTotalAnonDwell());
                notifications.add(jsonObject);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        });
        return notifications;
    }

    @Override
    @Transactional
    public List<Notification> getAllNotificationsV2() {
        ArrayList<Notification> notifications = new ArrayList<Notification>();
        this.activeObjects.stream(Notification.class, Query.select((String)"ACTIVE, ANONYMOUS, BUTTON_TEXT, DATE_RESTRICT, DELAY_BUTTON, DESCRIPTION, DISPLAY, END_DATE, FILTER_GROUPS, FILTER_PROJECT, FILTER_CATEGORY, FILTER_PROJECT_ROLE, FORMAT, GROUP_TARGET, HTML, ID, IS_REQUIRED, NUM_ANON, RESET_BUTTON, SHOW_BUTTON, START_DATE, TARGET_CATEGORIES, TARGET_PROJECT, TARGET_PROJECT_ROLE, TEMP_ACTIVE, TITLE, TOTAL_ANON_DWELL, TYPE"), notification -> notifications.add((Notification)notification));
        return notifications;
    }

    @Override
    @Transactional
    public Collection<JSONObject> getAllNotificationToAnonUsers() {
        ArrayList<JSONObject> notificationToAnonUsers = new ArrayList<JSONObject>();
        this.activeObjects.stream(NotificationToAnonUser.class, Query.select((String)"ANON_USER_ID, DWELL_TIME, ID, NOTIFICATION_ID"), notificationToAnonUser -> {
            JSONObject notificationJson = new JSONObject();
            JSONObject notificationObj = new JSONObject();
            Notification notification = notificationToAnonUser.getNotification();
            if (notification != null) {
                try {
                    notificationObj.put("active", notification.getActive());
                    notificationObj.put("button_text", (Object)notification.getButtonText());
                    notificationObj.put("date_restrict", (Object)notification.getDateRestrict());
                    notificationObj.put("delay_button", notification.getDelayButton());
                    notificationObj.put("description", (Object)notification.getDescription());
                    notificationObj.put("display", (Object)notification.getDisplay());
                    notificationObj.put("end_date", (Object)notification.getEndDate());
                    notificationObj.put("filter_groups", notification.getFilterGroups());
                    notificationObj.put("filter_project", notification.getFilterProject());
                    notificationObj.put("format", notification.getFormat());
                    notificationObj.put("html", (Object)notification.getHtml());
                    notificationObj.put("reset_button", notification.getResetButton());
                    notificationObj.put("show_button", (Object)notification.getShowButton());
                    notificationObj.put("target", (Object)notification.getTargetProject());
                    notificationObj.put("title", (Object)notification.getTitle());
                    notificationObj.put("type", (Object)notification.getType());
                    notificationObj.put("start_date", (Object)notification.getStartDate());
                    notificationObj.put("anonymous", notification.getAnonymous());
                    notificationObj.put("group_target", (Object)notification.getGroupTarget());
                    notificationObj.put("is_required", notification.getIsRequired());
                    notificationObj.put("num_anon", (Object)notification.getNumAnon());
                    notificationObj.put("id", notification.getID());
                    notificationObj.put("temp_active", (Object)notification.getTempActive());
                    notificationObj.put("total_anon_dwell", (Object)notification.getTotalAnonDwell());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            JSONObject userObj = new JSONObject();
            AnonUser user = notificationToAnonUser.getAnonUser();
            if (user != null) {
                try {
                    userObj.put("user", (Object)user.getAnonId());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            try {
                notificationJson.put("notification", (Object)notificationObj);
                notificationJson.put("user", (Object)userObj);
                notificationJson.put("dwellTime", (Object)notificationToAnonUser.getDwellTime());
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            notificationToAnonUsers.add(notificationJson);
        });
        return notificationToAnonUsers;
    }

    @Override
    @Transactional
    public Collection<JSONObject> getAllNotificationToNotificationUsers() {
        ArrayList<JSONObject> notificationToNotificationUsers = new ArrayList<JSONObject>();
        this.activeObjects.stream(NotificationToNotificationUser.class, Query.select((String)"ACCEPT_DATE, DWELL_TIME, ID, NOTIFICATION_ID, NOTIFICATION_USER_ID"), notificationToNotificationUser -> {
            JSONObject notificationJson = new JSONObject();
            JSONObject notificationObj = new JSONObject();
            Notification notification = notificationToNotificationUser.getNotification();
            if (notification != null) {
                try {
                    notificationObj.put("active", notification.getActive());
                    notificationObj.put("button_text", (Object)notification.getButtonText());
                    notificationObj.put("date_restrict", (Object)notification.getDateRestrict());
                    notificationObj.put("delay_button", notification.getDelayButton());
                    notificationObj.put("description", (Object)notification.getDescription());
                    notificationObj.put("display", (Object)notification.getDisplay());
                    notificationObj.put("end_date", (Object)notification.getEndDate());
                    notificationObj.put("filter_groups", notification.getFilterGroups());
                    notificationObj.put("filter_project", notification.getFilterProject());
                    notificationObj.put("format", notification.getFormat());
                    notificationObj.put("html", (Object)notification.getHtml());
                    notificationObj.put("reset_button", notification.getResetButton());
                    notificationObj.put("show_button", (Object)notification.getShowButton());
                    notificationObj.put("target", (Object)notification.getTargetProject());
                    notificationObj.put("title", (Object)notification.getTitle());
                    notificationObj.put("type", (Object)notification.getType());
                    notificationObj.put("start_date", (Object)notification.getStartDate());
                    notificationObj.put("anonymous", notification.getAnonymous());
                    notificationObj.put("group_target", (Object)notification.getGroupTarget());
                    notificationObj.put("is_required", notification.getIsRequired());
                    notificationObj.put("num_anon", (Object)notification.getNumAnon());
                    notificationObj.put("id", notification.getID());
                    notificationObj.put("temp_active", (Object)notification.getTempActive());
                    notificationObj.put("total_anon_dwell", (Object)notification.getTotalAnonDwell());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            JSONObject userObj = new JSONObject();
            NotificationUser user = notificationToNotificationUser.getNotificationUser();
            if (user != null) {
                try {
                    userObj.put("user", (Object)user.getUser());
                    userObj.put("userKey", (Object)user.getUserKey());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            try {
                notificationJson.put("notificationUser", (Object)userObj);
                notificationJson.put("notification", (Object)notificationObj);
                notificationJson.put("acceptDate", (Object)notificationToNotificationUser.getAcceptDate());
                notificationJson.put("dwellTime", (Object)notificationToNotificationUser.getDwellTime());
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            notificationToNotificationUsers.add(notificationJson);
        });
        return notificationToNotificationUsers;
    }

    @Override
    @Transactional
    public Collection<JSONObject> getAllNotificationUsers() {
        ArrayList<JSONObject> notificationUsers = new ArrayList<JSONObject>();
        this.activeObjects.stream(NotificationUser.class, Query.select((String)"ID, USER, USER_KEY"), notificationUser -> {
            JSONObject jsonObject = new JSONObject();
            try {
                jsonObject.put("notifications", (Object)notificationUser.getNotifications());
                jsonObject.put("user", (Object)notificationUser.getUser());
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            notificationUsers.add(jsonObject);
        });
        return notificationUsers;
    }

    @Override
    public JSONObject getGlobalConfiguration() {
        JSONObject globalConfig = new JSONObject();
        try {
            globalConfig.put("dialogHeight", (Object)globalConfigurationService.getDialogHeight());
            globalConfig.put("remindMeLaterEnabled", globalConfigurationService.getRemindMeLaterEnabled());
            globalConfig.put("remindMeLaterExplainerText", (Object)globalConfigurationService.getRemindMeLaterExplainerText());
            globalConfig.put("remindMeLaterText", (Object)globalConfigurationService.getRemindMeLaterText());
            globalConfig.put("remindMeLaterTime", (Object)globalConfigurationService.getRemindMeLaterTime());
            globalConfig.put("usageAnalytics", globalConfigurationService.getUsageAnalytics());
            globalConfig.put("userAgent", (Object)globalConfigurationService.getUserAgent());
            globalConfig.put("validHTMLTagsAndAttributes", (Object)globalConfigurationService.getValidHTMLTagsAndAttributes());
            globalConfig.put("projectConfigEnabled", globalConfigurationService.getProjectConfigEnabled());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return globalConfig;
    }
}

