/*
 * Decompiled with CFR 0.152.
 */
package com.wittified.services;

import com.google.common.collect.Lists;
import com.wittified.ao.Notification;
import com.wittified.licensecounters.LicenseCounter;
import com.wittified.services.InvalidNotificationService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvalidNotificationServiceImpl
implements InvalidNotificationService {
    private final LicenseCounter licenseCounter;
    private static final Logger logger = LoggerFactory.getLogger(InvalidNotificationServiceImpl.class);

    public InvalidNotificationServiceImpl(LicenseCounter licenseCounter) {
        this.licenseCounter = licenseCounter;
    }

    @Override
    public String getMissedTargetProjects(Notification notification) {
        if (notification == null) {
            return null;
        }
        if (!notification.getFilterProject()) {
            return null;
        }
        String projectKeys = notification.getTargetProject();
        if (StringUtils.isBlank(projectKeys) || ":Not Set:".equals(projectKeys) || "::".equals(projectKeys)) {
            return null;
        }
        ArrayList<String> missingProjects = new ArrayList<String>();
        if (projectKeys.contains("::")) {
            List<String> keys = Arrays.asList(projectKeys.split("::"));
            ListIterator<String> i = keys.listIterator();
            while (i.hasNext()) {
                i.set(i.next().replace(":", ""));
            }
            for (String key : keys) {
                if (key == "" || !this.licenseCounter.projectDoesNotExist(key)) continue;
                missingProjects.add(key);
            }
        } else if (this.licenseCounter.projectDoesNotExist(projectKeys = projectKeys.replace(":", ""))) {
            missingProjects.add(projectKeys);
        }
        if (missingProjects.isEmpty()) {
            return null;
        }
        return StringUtils.join(missingProjects, ",");
    }

    @Override
    public String getMissedTargetProjectCategories(Notification notification) {
        if (notification == null) {
            return null;
        }
        if (!notification.getFilterCategory()) {
            return null;
        }
        String categories = notification.getTargetCategories();
        if (StringUtils.isBlank(categories)) {
            return null;
        }
        List<String> targettedCategories = Arrays.asList(categories.split(","));
        List<String> availableCategories = this.licenseCounter.getAllCategories();
        List missingCategories = targettedCategories.stream().filter(category -> !availableCategories.contains(category)).collect(Collectors.toList());
        if (missingCategories.isEmpty()) {
            return null;
        }
        return StringUtils.join(missingCategories, ",");
    }

    @Override
    public String getMissedTargetProjectRoles(Notification notification) {
        if (notification == null) {
            return null;
        }
        if (!notification.getFilterProjectRole()) {
            return null;
        }
        String targetProjectRoles = notification.getTargetProjectRole();
        if (StringUtils.isBlank(targetProjectRoles)) {
            return null;
        }
        String[] targettedRoles = targetProjectRoles.split(",");
        ArrayList<String> missingProjectRoles = new ArrayList<String>();
        List<String> availableProjectRoles = this.licenseCounter.getAllProjectRoles();
        for (String role : targettedRoles) {
            if (availableProjectRoles.contains(role)) continue;
            missingProjectRoles.add(role);
        }
        if (missingProjectRoles.isEmpty()) {
            return null;
        }
        return StringUtils.join(missingProjectRoles, ",");
    }

    @Override
    public String getMissedTargetGroups(Notification notification) {
        if (notification == null) {
            return null;
        }
        if (!notification.getFilterGroups()) {
            return null;
        }
        if (StringUtils.isBlank(notification.getGroupTarget())) {
            return null;
        }
        ArrayList missedGroups = Lists.newArrayList();
        String[] groups = new String[]{};
        for (String group : groups = notification.getGroupTarget().split(",")) {
            if (this.licenseCounter.isGroupExists(group)) continue;
            missedGroups.add(group);
        }
        if (missedGroups.isEmpty()) {
            return null;
        }
        return StringUtils.join(missedGroups, ",");
    }
}

