/*
 * Decompiled with CFR 0.152.
 */
package com.wittified.rest;

import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.wittified.analytics.AnnouncerAnalytics;
import com.wittified.analytics.EventType;
import com.wittified.rest.entities.SimpleValueEntity;
import java.util.Map;
import java.util.WeakHashMap;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/global-config")
@WebSudoRequired
public class GlobalConfigurationEndPoint {
    private final PluginSettingsFactory pluginSettingsFactory;
    private final AnnouncerAnalytics announcerAnalytics;

    public GlobalConfigurationEndPoint(PluginSettingsFactory pluginSettingsFactory, AnnouncerAnalytics announcerAnalytics) {
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.announcerAnalytics = announcerAnalytics;
    }

    @Path(value="/analytics")
    @Produces(value={"application/json"})
    @GET
    public Response getAnalyticsConfig() {
        SimpleValueEntity simpleValueEntity = new SimpleValueEntity();
        String value = (String)this.pluginSettingsFactory.createGlobalSettings().get("wittified.announcer.analytics");
        if (value == null) {
            simpleValueEntity.setValue("false");
        } else {
            simpleValueEntity.setValue("true");
        }
        return Response.ok((Object)simpleValueEntity).build();
    }

    @Path(value="/analytics")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @POST
    @WebSudoRequired
    public Response saveAnalyticsConfig(SimpleValueEntity simpleValueEntity) {
        Map<String, Object> eventDataMap = GlobalConfigurationEndPoint.constructEventMap(EventType.USAGE_ANALYTICS, simpleValueEntity.getValue().toUpperCase());
        this.announcerAnalytics.postEventInfo(EventType.USAGE_ANALYTICS, eventDataMap);
        this.pluginSettingsFactory.createGlobalSettings().put("wittified.announcer.analytics", (Object)simpleValueEntity.getValue());
        return Response.ok((Object)simpleValueEntity).build();
    }

    @Path(value="/project")
    @Produces(value={"application/json"})
    @GET
    public Response getProjectConfig() {
        SimpleValueEntity simpleValueEntity = new SimpleValueEntity();
        String value = (String)this.pluginSettingsFactory.createGlobalSettings().get("wittified.announcer.projects");
        if (value == null) {
            simpleValueEntity.setValue("false");
        } else {
            simpleValueEntity.setValue("true");
        }
        return Response.ok((Object)simpleValueEntity).build();
    }

    @Path(value="/project")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @POST
    @WebSudoRequired
    public Response saveProjectConfig(SimpleValueEntity simpleValueEntity) {
        Map<String, Object> eventDataMap = GlobalConfigurationEndPoint.constructEventMap(EventType.DELEGATION, simpleValueEntity.getValue().toUpperCase());
        this.announcerAnalytics.postEventInfo(EventType.DELEGATION, eventDataMap);
        this.pluginSettingsFactory.createGlobalSettings().put("wittified.announcer.projects", (Object)simpleValueEntity.getValue());
        return Response.ok((Object)simpleValueEntity).build();
    }

    @Path(value="/ignore-useragent")
    @Produces(value={"application/json"})
    @GET
    @WebSudoRequired
    public Response getIgnoredUserAgents() {
        SimpleValueEntity simpleValueEntity = new SimpleValueEntity();
        String value = (String)this.pluginSettingsFactory.createGlobalSettings().get("wittified.announcer.ignored.userAgents");
        if (value == null) {
            simpleValueEntity.setValue("false");
        } else {
            simpleValueEntity.setValue("true");
        }
        return Response.ok((Object)simpleValueEntity).build();
    }

    @Path(value="/ignore-useragent")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @POST
    @WebSudoRequired
    public Response setIgnoredUserAgents(SimpleValueEntity simpleValueEntity) {
        Map<String, Object> eventDataMap = GlobalConfigurationEndPoint.constructEventMap(EventType.USER_AGENTS, "ON");
        this.announcerAnalytics.postEventInfo(EventType.USER_AGENTS, eventDataMap);
        this.pluginSettingsFactory.createGlobalSettings().put("wittified.announcer.ignored.userAgents", (Object)simpleValueEntity.getValue());
        return Response.ok((Object)simpleValueEntity).build();
    }

    @Path(value="/ignore-urls")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @POST
    @WebSudoRequired
    public Response setIgnoredUrls(SimpleValueEntity simpleValueEntity) {
        this.pluginSettingsFactory.createGlobalSettings().put("wittified.announcer.ignored.urls", (Object)simpleValueEntity.getValue());
        return Response.ok((Object)simpleValueEntity).build();
    }

    @Path(value="/dialog-height")
    @Produces(value={"application/json"})
    @GET
    @WebSudoRequired
    public Response getDialogHeight() {
        SimpleValueEntity simpleValueEntity = new SimpleValueEntity();
        String value = (String)this.pluginSettingsFactory.createGlobalSettings().get("wittified.announcer.dialog.height");
        if (value == null) {
            simpleValueEntity.setValue("false");
        } else {
            simpleValueEntity.setValue("true");
        }
        return Response.ok((Object)simpleValueEntity).build();
    }

    @Path(value="/dialog-height")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @POST
    @WebSudoRequired
    public Response setDialogHeight(SimpleValueEntity simpleValueEntity) {
        this.pluginSettingsFactory.createGlobalSettings().put("wittified.announcer.dialog.height", (Object)simpleValueEntity.getValue());
        return Response.ok((Object)simpleValueEntity).build();
    }

    @Path(value="/remind-me-later")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @POST
    @WebSudoRequired
    public Response setRemindMeLaterConfig(SimpleValueEntity simpleValueEntity) {
        Map<String, Object> eventDataMap = GlobalConfigurationEndPoint.constructEventMap(EventType.REMIND_ME_LATER, simpleValueEntity.getValue().toUpperCase());
        this.announcerAnalytics.postEventInfo(EventType.REMIND_ME_LATER, eventDataMap);
        this.pluginSettingsFactory.createGlobalSettings().put("wittified.announcer.remindmelater", (Object)simpleValueEntity.getValue());
        return Response.ok((Object)simpleValueEntity).build();
    }

    @Path(value="/remind-me-later-text")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @POST
    @WebSudoRequired
    public Response setRemindMeLaterText(SimpleValueEntity simpleValueEntity) {
        this.pluginSettingsFactory.createGlobalSettings().put("wittified.announcer.remindmelater.text", (Object)simpleValueEntity.getValue());
        return Response.ok((Object)simpleValueEntity).build();
    }

    @Path(value="/remind-me-later-explainer-text")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @POST
    @WebSudoRequired
    public Response setRemindMeLaterExplainerText(SimpleValueEntity simpleValueEntity) {
        this.pluginSettingsFactory.createGlobalSettings().put("wittified.announcer.remindmelater.explainer.text", (Object)simpleValueEntity.getValue());
        return Response.ok((Object)simpleValueEntity).build();
    }

    @Path(value="/remind-me-later-time")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @POST
    @WebSudoRequired
    public Response setRemindMeLaterTime(SimpleValueEntity simpleValueEntity) {
        this.pluginSettingsFactory.createGlobalSettings().put("wittified.announcer.remindmelater.time", (Object)simpleValueEntity.getValue());
        return Response.ok((Object)simpleValueEntity).build();
    }

    @Path(value="/html-whitelist-tags")
    @Produces(value={"application/json"})
    @GET
    @WebSudoRequired
    public Response getWhiteListedHtmlTags() {
        SimpleValueEntity simpleValueEntity = new SimpleValueEntity();
        String value = (String)this.pluginSettingsFactory.createGlobalSettings().get("wittified.announcer.html.whitelist.tags");
        if (value == null) {
            simpleValueEntity.setValue("false");
        } else {
            simpleValueEntity.setValue("true");
        }
        return Response.ok((Object)simpleValueEntity).build();
    }

    @Path(value="/html-whitelist-tags")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @POST
    @WebSudoRequired
    public Response setWhiteListedHtmlTags(SimpleValueEntity simpleValueEntity) {
        Map<String, Object> eventDataMap = GlobalConfigurationEndPoint.constructEventMap(EventType.HTML_SETTINGS, "ON");
        this.announcerAnalytics.postEventInfo(EventType.HTML_SETTINGS, eventDataMap);
        this.pluginSettingsFactory.createGlobalSettings().put("wittified.announcer.html.whitelist.tags", (Object)simpleValueEntity.getValue());
        return Response.ok((Object)simpleValueEntity).build();
    }

    private static Map<String, Object> constructEventMap(EventType type, String event) {
        WeakHashMap<String, Object> eventDataMap = new WeakHashMap<String, Object>();
        eventDataMap.put("type", (Object)type);
        eventDataMap.put("Operation", event);
        return eventDataMap;
    }
}

