/*
 * Decompiled with CFR 0.152.
 */
package com.wittified.upgrades;

import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import com.wittified.ao.Notification;
import com.wittified.ao.NotificationService;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;

public class NotificationDateRestrictUpgradeTask
implements PluginUpgradeTask {
    private final NotificationService notificationService;

    public NotificationDateRestrictUpgradeTask(NotificationService notificationService) {
        this.notificationService = notificationService;
    }

    public int getBuildNumber() {
        return 2;
    }

    public String getShortDescription() {
        return "Resets Notification DateRestrict field";
    }

    public Collection<Message> doUpgrade() throws Exception {
        List<Notification> notifications = this.notificationService.getAllNotifications();
        for (Notification notification : notifications) {
            if (notification.getDateRestrict() == null) {
                notification.setDateRestrict(false);
            }
            notification.save();
        }
        return Collections.emptySet();
    }

    public String getPluginKey() {
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("announcer-project.properties");
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return "com.wittified.atl-announcer-" + properties.getProperty("wittified-app-key");
    }
}

