/*
 * Decompiled with CFR 0.152.
 */
package com.wittified.services;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.Combine;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import com.google.common.collect.Lists;
import com.wittified.ao.Notification;
import com.wittified.ao.NotificationService;
import com.wittified.ao.NotificationToNotificationUser;
import com.wittified.ao.NotificationUser;
import com.wittified.rest.entities.report.UserReport;
import com.wittified.services.ReportService;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportServiceImpl
implements ReportService {
    private static final Logger logger = LoggerFactory.getLogger(ReportServiceImpl.class);
    private int userSize = 0;
    private final int USER_CACHE_TIME = 5;
    private final Cache<String, List<User>> userCache;
    private final CacheManager cacheManager;
    private final CrowdService crowdService;
    private final NotificationService notificationService;
    private final UserManager userManager;
    private final I18nResolver i18nResolver;
    private final ApplicationProperties applicationProperties;

    public ReportServiceImpl(CacheManager cacheManager, CrowdService crowdService, NotificationService notificationService, UserManager userManager, I18nResolver i18nResolver, ApplicationProperties applicationProperties) {
        this.cacheManager = cacheManager;
        this.crowdService = crowdService;
        this.notificationService = notificationService;
        this.userManager = userManager;
        this.i18nResolver = i18nResolver;
        this.applicationProperties = applicationProperties;
        this.userCache = this.cacheManager.getCache(ReportServiceImpl.class.getName() + ".cache", (CacheLoader)new ListUserCacheLoader(), new CacheSettingsBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build());
    }

    private List<User> getAllMembersOfGroups(String group) {
        String[] groups = group.split(",");
        MembershipQuery query = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withNames(groups).returningAtMost(-1);
        Iterable result = this.crowdService.search((Query)query);
        return Lists.newArrayList((Iterable)result);
    }

    @Override
    public Cache<String, List<User>> getUserCache() {
        return this.userCache;
    }

    @Override
    public Map<String, Object> getUsersInGroup(Notification theNotification, String searchTerm, String status, int usersPerPage, int page) {
        List members;
        String targetGroup = theNotification.getGroupTarget();
        String[] groups = targetGroup.split(",");
        List<Object> groupMembers = Lists.newArrayList();
        if (StringUtils.isNotBlank((String)status) && status.equals("all")) {
            if (StringUtils.isBlank((String)searchTerm)) {
                this.userSize = ((List)this.userCache.get((Object)targetGroup)).size();
                MembershipQuery query = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withNames(groups).startingAt((page - 1) * usersPerPage).returningAtMost(usersPerPage);
                Iterable result = this.crowdService.search((Query)query);
                groupMembers = Lists.newArrayList((Iterable)result);
            } else {
                members = (List)this.userCache.get((Object)targetGroup);
                groupMembers = members.stream().filter(user -> user != null && (user.getName().toLowerCase().contains(searchTerm.toLowerCase()) || user.getDisplayName().toLowerCase().contains(searchTerm.toLowerCase()) || user.getEmailAddress().toLowerCase().contains(searchTerm.toLowerCase()))).collect(Collectors.toList());
                this.userSize = groupMembers.size();
            }
        } else if (StringUtils.isNotBlank((String)status) && status.equals("accepted")) {
            members = (List)this.userCache.get((Object)targetGroup);
            List<User> allAcceptedUsers = this.notificationService.getNotificationToUserForReport(theNotification.getID(), searchTerm);
            groupMembers = allAcceptedUsers.stream().filter(acceptedUsers -> members.contains(acceptedUsers)).collect(Collectors.toList());
            this.userSize = groupMembers.size();
        }
        WeakHashMap<String, Object> returnMap = new WeakHashMap<String, Object>();
        returnMap.put("userSize", this.userSize);
        returnMap.put("users", groupMembers.stream().map(user -> this.convertUsers((User)user, theNotification)).collect(Collectors.toList()));
        return returnMap;
    }

    @Override
    public Map<String, Object> getActiveUsers(Notification theNotification, String searchTerm, String status, int usersPerPage, int page) {
        List<Object> allUsers = Lists.newArrayList();
        if (StringUtils.isNotBlank((String)status) && status.equals("all")) {
            EntityQuery query = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Combine.allOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)UserTermKeys.ACTIVE).exactlyMatching((Object)true), Combine.anyOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)UserTermKeys.USERNAME).containing((Object)searchTerm), Restriction.on((Property)UserTermKeys.DISPLAY_NAME).containing((Object)searchTerm), Restriction.on((Property)UserTermKeys.EMAIL).containing((Object)searchTerm)})})).startingAt((page - 1) * usersPerPage).returningAtMost(usersPerPage);
            Iterable result = this.crowdService.search((Query)query);
            allUsers = Lists.newArrayList((Iterable)result);
            this.userSize = this.getTotalUsers(searchTerm).size();
        } else if (StringUtils.isNotBlank((String)status) && status.equals("accepted")) {
            List<Object> userNames = Lists.newArrayList();
            if (StringUtils.isBlank((String)searchTerm)) {
                this.userSize = this.notificationService.getNotificationToUserCount(theNotification.getID());
                userNames = this.notificationService.getPaginatedAcceptedUsers(theNotification, usersPerPage, page);
                allUsers = userNames.stream().map(userName -> this.crowdService.getUser(userName)).collect(Collectors.toList());
            } else {
                allUsers = this.notificationService.getNotificationToUserForReport(theNotification.getID(), searchTerm);
                this.userSize = allUsers.size();
            }
        }
        WeakHashMap<String, Object> returnMap = new WeakHashMap<String, Object>();
        returnMap.put("userSize", this.userSize);
        returnMap.put("users", allUsers.stream().map(user -> this.convertUsers((User)user, theNotification)).collect(Collectors.toList()));
        return returnMap;
    }

    @Override
    public List<User> getTotalUsers(String searchTerm) {
        EntityQuery query = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Combine.allOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)UserTermKeys.ACTIVE).exactlyMatching((Object)true), Combine.anyOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)UserTermKeys.USERNAME).containing((Object)searchTerm), Restriction.on((Property)UserTermKeys.DISPLAY_NAME).containing((Object)searchTerm), Restriction.on((Property)UserTermKeys.EMAIL).containing((Object)searchTerm)})})).returningAtMost(-1);
        Iterable result = this.crowdService.search((Query)query);
        return Lists.newArrayList((Iterable)result);
    }

    private UserReport convertUsers(User user, Notification theNotification) {
        UserReport userReport = new UserReport();
        NotificationUser notifUser = this.notificationService.getNotificationUser(this.userManager.getUserProfile(user.getName()));
        NotificationToNotificationUser notifToNotifiUser = this.notificationService.getNotificationToUser(theNotification.getID(), notifUser.getUserKey());
        if (notifToNotifiUser != null) {
            if (notifToNotifiUser.getAcceptDate() != null) {
                Date date = notifToNotifiUser.getAcceptDate();
                if (date != null) {
                    userReport.setAcceptedDate("" + date);
                } else {
                    userReport.setAcceptedDate("");
                }
            }
            if (notifToNotifiUser.getDwellTime() != null) {
                userReport.setDwellTime(notifToNotifiUser.getDwellTime());
            }
        }
        userReport.setUsername(user.getName());
        userReport.setDisplayName(user.getDisplayName());
        userReport.setEmail(user.getEmailAddress());
        return userReport;
    }

    @Override
    public CSVPrinter exportCSV(Notification theNotification, OutputStreamWriter osw) {
        CSVFormat csvFileFormat = CSVFormat.DEFAULT.withDelimiter(',').withRecordSeparator("\n");
        try {
            CSVPrinter csvFilePrinter = new CSVPrinter(osw, csvFileFormat);
            csvFilePrinter.printRecord(this.i18nResolver.getText("wittified.announcer.admin.report.activity_report") + " " + theNotification.getTitle());
            Map<String, Object> reportSummary = this.fetchReportSummary(theNotification);
            List<UserReport> userReports = this.fetchUserReports(theNotification);
            DecimalFormat format = new DecimalFormat("0.00");
            ArrayList csvSummaryHeader = Lists.newArrayList();
            csvSummaryHeader.add(this.i18nResolver.getText("wittified.announcer.admin.report.summary.anon_users"));
            csvSummaryHeader.add(this.i18nResolver.getText("wittified.announcer.admin.report.summary.avg_dwell_time_for_anon_users"));
            csvSummaryHeader.add(this.i18nResolver.getText("wittified.announcer.admin.report.summary.real_users"));
            csvSummaryHeader.add(this.i18nResolver.getText("wittified.announcer.admin.report.summary.avg_dwell_time_for_real_users"));
            csvFilePrinter.printRecord(this.i18nResolver.getText("wittified.announcer.admin.report.summary"));
            csvFilePrinter.printRecord(csvSummaryHeader);
            ArrayList<String> row = new ArrayList<String>();
            row.add(String.valueOf(reportSummary.get("numAnonUsers")));
            row.add(format.format(((Float)reportSummary.get("averageAnonDwellTime")).floatValue() / 1000.0f));
            row.add(String.valueOf(reportSummary.get("numRealUsers")));
            row.add(format.format(((Float)reportSummary.get("averageUserDwellTime")).floatValue() / 1000.0f));
            csvFilePrinter.printRecord(row);
            ArrayList csvHeader = Lists.newArrayList();
            csvHeader.add(this.i18nResolver.getText("wittified.announcer.admin.report.username"));
            csvHeader.add(this.i18nResolver.getText("wittified.announcer.admin.report.accepted_header"));
            csvHeader.add(this.i18nResolver.getText("wittified.announcer.admin.report.accepted_date"));
            csvHeader.add(this.i18nResolver.getText("wittified.announcer.admin.report.dwell_time"));
            csvFilePrinter.printRecord("");
            csvFilePrinter.printRecord(this.i18nResolver.getText("wittified.announcer.admin.report.users"));
            csvFilePrinter.printRecord(csvHeader);
            for (UserReport userReport : userReports) {
                row = new ArrayList();
                row.add(userReport.getUsername());
                row.add(userReport.getAcceptedDate() != null ? this.i18nResolver.getText("wittified.announcer.admin.report.accepted") : this.i18nResolver.getText("wittified.announcer.admin.report.not_accepted"));
                row.add(userReport.getAcceptedDate());
                row.add(userReport.getDwellTime());
                csvFilePrinter.printRecord(row);
            }
            return csvFilePrinter;
        }
        catch (IOException e) {
            logger.error(e.getLocalizedMessage());
            return null;
        }
    }

    private Map<String, Object> fetchReportSummary(Notification theNotification) {
        WeakHashMap<String, Object> reportSummary = new WeakHashMap<String, Object>();
        int numAnonUsers = 0;
        if (theNotification.getNumAnon() != null) {
            numAnonUsers = theNotification.getNumAnon();
        }
        long totalAnonDwellTime = this.notificationService.getTotalAnonDwellTime(theNotification.getID());
        reportSummary.put("totalAnonDwellTime", totalAnonDwellTime);
        reportSummary.put("numAnonUsers", numAnonUsers += this.notificationService.getNotificationToAnonUser(theNotification.getID()).size());
        long totalRealDwellTime = 0L;
        int numRealUsers = 0;
        for (NotificationToNotificationUser notificationToNotificationUser : this.notificationService.getNotificationToUser(theNotification.getID())) {
            if (notificationToNotificationUser.getDwellTime() != null) {
                totalRealDwellTime += notificationToNotificationUser.getDwellTime().longValue();
            }
            ++numRealUsers;
        }
        reportSummary.put("totalRealDwellTime", totalRealDwellTime);
        reportSummary.put("numRealUsers", numRealUsers);
        float averageAnonDwellTime = 0.0f;
        if (numAnonUsers > 0) {
            averageAnonDwellTime = totalAnonDwellTime / (long)numAnonUsers;
        }
        float averageUserDwellTime = 0.0f;
        if (numRealUsers > 0) {
            averageUserDwellTime = totalRealDwellTime / (long)numRealUsers;
        }
        reportSummary.put("averageAnonDwellTime", Float.valueOf(averageAnonDwellTime));
        reportSummary.put("averageUserDwellTime", Float.valueOf(averageUserDwellTime));
        return reportSummary;
    }

    private List<UserReport> fetchUserReports(Notification theNotification) {
        List<Object> userReports = Lists.newArrayList();
        if (theNotification.getFilterGroups() && theNotification.getGroupTarget() != null && !theNotification.getGroupTarget().trim().equals("")) {
            logger.debug("Using filtered groups");
            List users = (List)this.getUserCache().get((Object)theNotification.getGroupTarget());
            userReports = users.stream().map(user -> this.convertUsers((User)user, theNotification)).collect(Collectors.toList());
        } else {
            logger.debug("Using all groups");
            List<User> users = this.getTotalUsers("");
            userReports = users.stream().map(user -> this.convertUsers((User)user, theNotification)).collect(Collectors.toList());
        }
        Collections.sort(userReports, Comparator.comparing(UserReport::getAcceptedDate, Comparator.nullsLast(Comparator.reverseOrder())));
        return userReports;
    }

    @Override
    public String fetchExportFilePath(Notification theNotification) {
        String exportedFileDirectory = this.applicationProperties.getHomeDirectory().getAbsolutePath() + "/announcer_report_export/";
        String fileName = "notification_report_" + theNotification.getTitle() + "_" + theNotification.getID() + ".csv";
        File fileDirectory = new File(exportedFileDirectory);
        if (!fileDirectory.exists()) {
            fileDirectory.mkdir();
        }
        String exportedFilePath = exportedFileDirectory.concat(fileName);
        return exportedFilePath;
    }

    private class ListUserCacheLoader
    implements CacheLoader<String, List<User>> {
        private ListUserCacheLoader() {
        }

        public List<User> load(@Nonnull String groupName) {
            return ReportServiceImpl.this.getAllMembersOfGroups(groupName);
        }
    }
}

