/*
 * Decompiled with CFR 0.152.
 */
package com.wittified.cache;

import com.wittified.cache.NotificationCacheEntry;
import java.util.ArrayList;
import java.util.List;

public class NotificationCacheList {
    private static final String FIELD_DELIMITER = "WITTIFIED::LIST-DELIMITER:WITTIFIED";
    private long expirationTime = 0L;
    private List<NotificationCacheEntry> entries;

    public NotificationCacheList(List<NotificationCacheEntry> entries) {
        this.entries = entries;
        this.expirationTime = System.currentTimeMillis() + 600000L;
    }

    public NotificationCacheList(String serializedData) {
        String[] data = serializedData.split(FIELD_DELIMITER);
        this.expirationTime = Long.parseLong(data[0]);
        ArrayList<NotificationCacheEntry> entries = new ArrayList<NotificationCacheEntry>();
        for (int i = 1; i < data.length; ++i) {
            entries.add(new NotificationCacheEntry(data[i]));
        }
        this.entries = entries;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.expirationTime);
        if (!this.entries.isEmpty()) {
            for (NotificationCacheEntry notificationCacheEntry : this.entries) {
                buffer.append(FIELD_DELIMITER);
                buffer.append(notificationCacheEntry.toString());
            }
        }
        return buffer.toString();
    }

    public long getExpirationTime() {
        return this.expirationTime;
    }

    public List<NotificationCacheEntry> getEntries() {
        return this.entries;
    }

    public List<NotificationCacheEntry> getEntries(String type) {
        ArrayList<NotificationCacheEntry> cacheEntries = new ArrayList<NotificationCacheEntry>();
        for (NotificationCacheEntry cacheEntry : this.entries) {
            if (!cacheEntry.getType().equals(type)) continue;
            cacheEntries.add(cacheEntry);
        }
        return cacheEntries;
    }
}

