/*
 * Decompiled with CFR 0.152.
 */
package com.wittified.servlets;

import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.sal.api.websudo.WebSudoSessionException;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.google.common.collect.Lists;
import com.wittified.ao.NotificationService;
import com.wittified.ao.statuspage.Incident;
import com.wittified.general.support.SupportBarService;
import com.wittified.licensecounters.LicenseCounter;
import com.wittified.rest.dto.NotificationCount;
import com.wittified.services.statuspage.StatusPageService;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationAdminServlet
extends HttpServlet {
    private static Logger logger = LoggerFactory.getLogger(NotificationAdminServlet.class);
    private final SupportBarService supportBarService;
    private final LicenseCounter licenseCounter;
    private final TemplateRenderer templateRenderer;
    private final WebResourceManager webResourceManager;
    private final UserManager userManager;
    private final NotificationService notificationService;
    private final PluginLicenseManager licenseStorageManager;
    private final PluginSettingsFactory pluginSettingsFactory;
    private final WebSudoManager webSudoManager;
    private final StatusPageService statusPageService;

    public NotificationAdminServlet(TemplateRenderer templateRenderer, WebResourceManager webResourceManager, UserManager userManager, NotificationService notificationService, PluginLicenseManager licenseStorageManager, LicenseCounter licenseCounter, PluginSettingsFactory pluginSettingsFactory, WebSudoManager webSudoManager, SupportBarService supportBarService, StatusPageService statusPageService) {
        this.templateRenderer = templateRenderer;
        this.webResourceManager = webResourceManager;
        this.userManager = userManager;
        this.notificationService = notificationService;
        this.licenseStorageManager = licenseStorageManager;
        this.licenseCounter = licenseCounter;
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.webSudoManager = webSudoManager;
        this.supportBarService = supportBarService;
        this.statusPageService = statusPageService;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.webResourceManager.requireResourcesForContext("atl-notifier");
        List<Object> notificationIds = Lists.newArrayList();
        String username = this.userManager.getRemoteUsername();
        String projectKey = req.getParameter("project");
        boolean filterProject = projectKey != null;
        String enabledProjectConfig = (String)this.pluginSettingsFactory.createGlobalSettings().get("wittified.announcer.projects");
        if (enabledProjectConfig == null) {
            enabledProjectConfig = "false";
        }
        enabledProjectConfig = enabledProjectConfig.toLowerCase();
        if (!filterProject || !enabledProjectConfig.equals("true")) {
            try {
                this.webSudoManager.willExecuteWebSudoRequest(req);
            }
            catch (WebSudoSessionException wes) {
                this.webSudoManager.enforceWebSudoProtection(req, res);
            }
        }
        if (username != null && (this.userManager.isAdmin(username) || this.licenseCounter.currentUserCanEdit(projectKey) && enabledProjectConfig.equals("true"))) {
            this.licenseCounter.prepareProjectView(projectKey);
            NotificationCount notificationCount = this.notificationService.getNotificationCount(filterProject ? projectKey : null);
            Incident[] incidents = this.statusPageService.getAllIncidents();
            notificationIds = Arrays.asList(incidents).stream().map(e -> e.getNotification().getID()).collect(Collectors.toList());
            PluginLicense license = (PluginLicense)this.licenseStorageManager.getLicense().getOrElse((Object)null);
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("license", this.getCheckLicense());
            context.put("product", this.licenseCounter.getApplicationType());
            context.put("contextPath", req.getContextPath());
            context.put("filterProject", filterProject);
            context.put("projectKey", projectKey);
            context.put("supportbarHtml", this.supportBarService.getHtml());
            context.put("wittifiedXsfrToken", this.licenseCounter.getXsfrToken(req, res));
            context.put("notificationIds", notificationIds);
            context.put("notificationCount", notificationCount);
            res.setContentType("text/html");
            this.render("/templates/admin-wrapper.vm", context, res);
        } else {
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("message", "The user that you're currently logged in as is not an administrator. This page is limited to administrator access.");
            res.setContentType("text/html");
            this.render("/templates/security-breach.vm", context, res);
        }
    }

    protected void render(String template, Map<String, Object> context, HttpServletResponse response) throws IOException {
        this.templateRenderer.render(template, context, (Writer)response.getWriter());
    }

    public String getCheckLicense() {
        if (this.licenseStorageManager.getLicense().isDefined()) {
            PluginLicense pluginLicense = (PluginLicense)this.licenseStorageManager.getLicense().get();
            if (pluginLicense.getError().isDefined()) {
                if (((LicenseError)pluginLicense.getError().get()).name().equals("EXPIRED")) {
                    return "The evaluation license has expired. Please contact your System administrator";
                }
                return "An error occurred while validating your license for this plugin: " + ((LicenseError)pluginLicense.getError().get()).name();
            }
            return null;
        }
        return "Plugin is not licensed. In order to evaluate this plugin you need to create an evaluation license";
    }
}

