/*
 * Decompiled with CFR 0.152.
 */
package com.wittified.servlets;

import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.wittified.AnnouncerHelper;
import com.wittified.ao.NotificationService;
import com.wittified.cache.NotificationCacheEntry;
import com.wittified.licensecounters.LicenseCounter;
import com.wittified.servlets.NotificationApprovalServlet;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DialogAcceptServlet
extends HttpServlet {
    private static Logger logger = LoggerFactory.getLogger(NotificationApprovalServlet.class);
    private final TemplateRenderer templateRenderer;
    private final UserManager userManager;
    private final I18nResolver i18nResolver;
    private final NotificationService notificationService;
    private final LicenseCounter licenseCounter;

    public DialogAcceptServlet(TemplateRenderer templateRenderer, UserManager userManager, NotificationService notificationService, LicenseCounter licenseCounter, I18nResolver i18nResolver) {
        this.templateRenderer = templateRenderer;
        this.userManager = userManager;
        this.notificationService = notificationService;
        this.licenseCounter = licenseCounter;
        this.i18nResolver = i18nResolver;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        List<NotificationCacheEntry> notifications;
        res.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
        res.setHeader("Expires", "0");
        res.setHeader("Pragma", "no-cache");
        HashMap<String, Object> context = new HashMap<String, Object>();
        UserProfile user = this.userManager.getRemoteUser();
        if (user == null) {
            String sessionId = AnnouncerHelper.getCookieName(req, res);
            if (sessionId == null) {
                context.put("message", "You are currently not logged in. Please log in order to confirm this announcement");
                this.render("/templates/security-breach.vm", context, res);
                return;
            }
            notifications = this.notificationService.getAllNotificationsForAnonymous(sessionId, "dialog").getEntries();
        } else {
            notifications = this.notificationService.getAllNotificationsForUser(user, "dialog").getEntries();
        }
        NotificationCacheEntry thisNotification = notifications.get(0);
        context.put("context", req.getContextPath());
        context.put("notification", thisNotification);
        if (thisNotification.getButtonText() == null || thisNotification.getButtonText().equals("")) {
            context.put("buttonText", this.i18nResolver.getText("wittified.announcer.dialog.acknowledge"));
        } else {
            context.put("buttonText", thisNotification.getButtonText());
        }
        if ("CONFLUENCE".equals(this.licenseCounter.getApplicationType())) {
            context.put("displayHeader", false);
        } else {
            context.put("displayHeader", true);
        }
        context.put("isAdmin", this.userManager.isAdmin(this.userManager.getRemoteUsername()));
        res.setContentType("text/html");
        this.render("/templates/dialog-approve-item.vm", context, res);
    }

    protected void render(String template, Map<String, Object> context, HttpServletResponse response) throws IOException {
        this.templateRenderer.render(template, context, (Writer)response.getWriter());
    }
}

