/*
 * Decompiled with CFR 0.152.
 */
package com.wittified.rest;

import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.wittified.analytics.AnnouncerAnalytics;
import com.wittified.analytics.EventType;
import com.wittified.ao.AnnouncerDataService;
import com.wittified.ao.Notification;
import com.wittified.ao.NotificationService;
import com.wittified.job.RecurringAnnouncementScheduler;
import com.wittified.licensecounters.LicenseCounter;
import com.wittified.services.TokenChangeService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.json.JSONException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/admin")
public class NotificationEndPoint {
    private final NotificationService notificationService;
    private final UserManager userManager;
    private final LicenseCounter licenseCounter;
    private final Logger logger = LoggerFactory.getLogger(NotificationEndPoint.class);
    private final AnnouncerAnalytics announcerAnalytics;
    private final RecurringAnnouncementScheduler recurringAnnouncementScheduler;
    private final AnnouncerDataService announcerDataService;
    private final TokenChangeService tokenChangeService;

    public NotificationEndPoint(NotificationService notificationService, UserManager userManager, LicenseCounter licenseCounter, AnnouncerAnalytics announcerAnalytics, RecurringAnnouncementScheduler recurringAnnouncementScheduler, AnnouncerDataService announcerDataService, TokenChangeService tokenChangeService) {
        this.notificationService = notificationService;
        this.userManager = userManager;
        this.licenseCounter = licenseCounter;
        this.announcerAnalytics = announcerAnalytics;
        this.recurringAnnouncementScheduler = recurringAnnouncementScheduler;
        this.announcerDataService = announcerDataService;
        this.tokenChangeService = tokenChangeService;
    }

    @Path(value="/delete/{id}")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response deleteThisNotification(@PathParam(value="id") String idStr, Map<String, String> data) {
        this.logger.debug(String.format("Deleting notification %s", idStr));
        UserKey userkey = this.userManager.getRemoteUserKey();
        Notification notification = this.notificationService.getThisNotification(Integer.parseInt(idStr));
        if (notification != null) {
            if (!this.userManager.isAdmin(userkey)) {
                boolean blocked = true;
                if (notification.getFilterProject()) {
                    String pKey = notification.getTargetProject();
                    if (pKey != null) {
                        pKey = pKey.replaceAll(":", "");
                    }
                    if (notification.getTargetProject().contains(pKey) && this.licenseCounter.currentUserCanEdit(pKey)) {
                        blocked = false;
                    }
                }
                if (blocked) {
                    return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
                }
            }
            WeakHashMap<String, Object> eventDataMap = new WeakHashMap<String, Object>();
            eventDataMap.put("type", EventType.ANNOUNCEMENT_DELETED.toString());
            eventDataMap.put("Operation", EventType.ANNOUNCEMENT_DELETED.toString());
            this.announcerAnalytics.postEventInfo(EventType.ANNOUNCEMENT_DELETED, eventDataMap);
            this.notificationService.deleteNotification(notification);
            if (notification.getCustomRecurrenceOption()) {
                this.logger.debug(String.format("Stopping scheduled job for notification %s", notification.getTitle()));
                this.recurringAnnouncementScheduler.unscheduleJob(notification);
            }
        } else {
            this.logger.debug("This notification does not exist");
            return Response.ok().build();
        }
        return Response.ok(data).build();
    }

    @Path(value="/reset/{id}")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response resetThisNotification(@PathParam(value="id") Integer id, Map<String, String> data) {
        this.logger.debug(String.format("Resetting notification %s", id));
        UserKey userkey = this.userManager.getRemoteUserKey();
        Notification notification = this.notificationService.getThisNotification(id);
        if (!this.userManager.isAdmin(userkey)) {
            boolean blocked = true;
            if (notification.getFilterProject()) {
                String pKey = notification.getTargetProject();
                if (pKey != null) {
                    pKey = pKey.replaceAll(":", "");
                }
                if (notification.getTargetProject().contains(pKey) && this.licenseCounter.currentUserCanEdit(pKey)) {
                    blocked = false;
                }
            }
            if (blocked) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
        }
        this.notificationService.resetNotification(notification);
        return Response.ok(data).build();
    }

    @Path(value="/enable-all")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response enableAllNotification(Map<String, String> data) {
        this.logger.debug(String.format("Enabling all notifications", new Object[0]));
        UserKey userkey = this.userManager.getRemoteUserKey();
        if (!this.userManager.isAdmin(userkey)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        for (Notification notification : this.notificationService.getAllNotifications()) {
            notification.setActive(true);
            this.notificationService.saveNotification(notification);
        }
        return Response.ok(data).build();
    }

    @Path(value="/notifications/status")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateNotificationStatus(ArrayList<Map<String, Boolean>> data) {
        this.logger.debug(String.format("Enabling/Disabling specified notifications", new Object[0]));
        UserKey userkey = this.userManager.getRemoteUserKey();
        if (!this.userManager.isAdmin(userkey)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        for (Map<String, Boolean> notificationMap : data) {
            Set<String> notificationIds = notificationMap.keySet();
            for (String key : notificationIds) {
                Notification notification = this.notificationService.getThisNotification(Integer.parseInt(key));
                if (notification == null) continue;
                if (notificationMap.get(key).booleanValue()) {
                    notification.setActive(true);
                } else {
                    notification.setActive(false);
                }
                this.notificationService.saveNotification(notification);
            }
        }
        return Response.ok(data).build();
    }

    @Path(value="/all-groups")
    @GET
    @Produces(value={"application/json"})
    public Response getAllGroups() {
        this.logger.debug(String.format("Getting all groups", new Object[0]));
        UserKey userKey = this.userManager.getRemoteUserKey();
        if (userKey == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        ArrayList<String> groups = new ArrayList<String>();
        if (this.userManager.isAdmin(userKey)) {
            for (String group : this.userManager.findGroupNamesByPrefix("", 0, 1000)) {
                groups.add(group);
            }
        } else {
            for (String group : this.userManager.findGroupNamesByPrefix("", 0, 1000)) {
                if (!this.userManager.isUserInGroup(userKey, group)) continue;
                groups.add(group);
            }
        }
        return Response.ok(groups).build();
    }

    @Path(value="/is-user-admin")
    @GET
    @Produces(value={"application/json"})
    public Response isCurrentUserAnAdmin() {
        UserKey userKey = this.userManager.getRemoteUserKey();
        HashMap<String, String> map = new HashMap<String, String>();
        if (userKey != null && this.userManager.isAdmin(userKey)) {
            map.put("isAdmin", "true");
        } else {
            map.put("isAdmin", "false");
        }
        return Response.ok(map).build();
    }

    @Path(value="/notifications/")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getAllNotifications() throws JSONException {
        this.logger.debug(String.format("getting all notifications using REST API", new Object[0]));
        UserKey userkey = this.userManager.getRemoteUserKey();
        if (!this.userManager.isAdmin(userkey)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        List<Notification> notificationsV2 = this.announcerDataService.getAllNotificationsV2();
        ArrayList notifications = new ArrayList();
        for (Notification notiff : notificationsV2) {
            HashMap<String, String> notificationsMap = new HashMap<String, String>();
            notificationsMap.put("active", String.valueOf(notiff.getActive()));
            notificationsMap.put("button_text", String.valueOf(notiff.getButtonText()));
            notificationsMap.put("delay_button", String.valueOf(notiff.getDelayButton()));
            notificationsMap.put("display", String.valueOf(notiff.getDisplay()));
            notificationsMap.put("format", String.valueOf(notiff.getFormat()));
            notificationsMap.put("contents", String.valueOf(notiff.getHtml()));
            notificationsMap.put("reset_button", String.valueOf(notiff.getResetButton()));
            notificationsMap.put("show_button", String.valueOf(notiff.getShowButton()));
            notificationsMap.put("title", String.valueOf(notiff.getTitle()));
            notificationsMap.put("type", String.valueOf(notiff.getType()));
            notificationsMap.put("anonymous", String.valueOf(notiff.getAnonymous()));
            notificationsMap.put("is_required", String.valueOf(notiff.getIsRequired()));
            notificationsMap.put("id", String.valueOf(notiff.getID()));
            notificationsMap.put("temp_active", String.valueOf(notiff.getTempActive()));
            notificationsMap.put("total_anon_dwell", String.valueOf(notiff.getTotalAnonDwell()));
            notificationsMap.put("num_anon", String.valueOf(notiff.getNumAnon()));
            notificationsMap.put("date_restrict", String.valueOf(notiff.getDateRestrict()));
            notificationsMap.put("description", String.valueOf(notiff.getDescription()));
            notificationsMap.put("filter_groups", String.valueOf(notiff.getFilterGroups()));
            notificationsMap.put("filter_project", String.valueOf(notiff.getFilterProject()));
            notificationsMap.put("target", String.valueOf(notiff.getTargetProject()));
            notificationsMap.put("start_date", String.valueOf(notiff.getStartDate()));
            notificationsMap.put("end_date", String.valueOf(notiff.getEndDate()));
            notificationsMap.put("group_target", String.valueOf(notiff.getGroupTarget()));
            notifications.add(notificationsMap);
        }
        return Response.ok(notifications).build();
    }

    @Path(value="/notifications/")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createNotification(ArrayList<Map<String, String>> data) {
        this.logger.debug(String.format("Creating notifications using REST API", new Object[0]));
        UserKey userkey = this.userManager.getRemoteUserKey();
        if (!this.userManager.isAdmin(userkey)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        ArrayList notifications = new ArrayList();
        for (Map<String, String> notificationMap : data) {
            Notification notification = this.notificationService.createNewNotification();
            Set<String> keys = notificationMap.keySet();
            for (String key : keys) {
                this.extractAndSetNotificationInfo(notificationMap, notification, key);
            }
            this.notificationService.saveNotification(notification);
            HashMap<String, String> hs = new HashMap<String, String>();
            hs.put("active", String.valueOf(notification.getActive()));
            hs.put("buttonText", notification.getButtonText());
            hs.put("description", notification.getDescription());
            hs.put("display", String.valueOf(notification.getDisplay()));
            hs.put("format", String.valueOf(notification.getFormat()));
            hs.put("contents", notification.getHtml());
            hs.put("resetButton", String.valueOf(notification.getResetButton()));
            hs.put("showButton", String.valueOf(notification.getShowButton()));
            hs.put("title", notification.getTitle());
            hs.put("type", notification.getType());
            hs.put("id", String.valueOf(notification.getID()));
            hs.put("isActive", String.valueOf(notification.getTempActive()));
            hs.put("delayButton", String.valueOf(notification.getDelayButton()));
            hs.put("anonymous", String.valueOf(notification.getAnonymous()));
            notifications.add(hs);
        }
        return Response.ok(notifications).build();
    }

    @Path(value="/notifications/{id}")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateNotification(@PathParam(value="id") String id, Map<String, String> data) {
        this.logger.debug(String.format("updating notification: %s", id));
        UserKey userkey = this.userManager.getRemoteUserKey();
        if (!this.userManager.isAdmin(userkey)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        Map<String, String> notificationMap = data;
        Notification notification = this.notificationService.getThisNotification(Integer.parseInt(id));
        if (notification == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        Set<String> keys = notificationMap.keySet();
        for (String key : keys) {
            this.extractAndSetNotificationInfo(notificationMap, notification, key);
        }
        this.notificationService.saveNotification(notification);
        this.logger.debug(String.format("updated notification: %s", id));
        return Response.ok(data).build();
    }

    private void extractAndSetNotificationInfo(Map<String, String> notificationMap, Notification notification, String key) {
        if (key.equals("title")) {
            notification.setTitle(notificationMap.get(key));
        }
        if (key.equals("description")) {
            notification.setDescription(notificationMap.get(key));
        }
        if (key.equals("type")) {
            notification.setType(notificationMap.get(key));
        }
        if (key.equals("buttonText")) {
            notification.setButtonText(notificationMap.get(key));
        }
        if (key.equals("displayType")) {
            notification.setDisplay(Integer.parseInt(notificationMap.get(key)));
        }
        if (key.equals("isActive")) {
            notification.setActive(Boolean.parseBoolean(notificationMap.get(key)));
            notification.setTempActive(Boolean.parseBoolean(notificationMap.get(key)));
        }
        if (key.equals("contents")) {
            notification.setHtml(notificationMap.get(key));
        }
        if (key.equals("delayButton")) {
            notification.setDelayButton(Boolean.parseBoolean(notificationMap.get(key)));
        }
        if (key.equals("anonymous")) {
            notification.setAnonymous(Boolean.parseBoolean(notificationMap.get(key)));
        }
        if (key.equals("showButton")) {
            notification.setShowButton(Boolean.valueOf(notificationMap.get(key)));
        }
        if (key.equals("delayButton")) {
            notification.setActive(Boolean.parseBoolean(notificationMap.get(key)));
        }
        if (key.equals("format")) {
            notification.setFormat(Integer.parseInt(notificationMap.get(key)));
        }
    }

    @Path(value="/notifications/{id}")
    @DELETE
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response deleteNotification(@PathParam(value="id") String idStr) {
        this.logger.debug(String.format("Deleting notification %s", idStr));
        UserKey userkey = this.userManager.getRemoteUserKey();
        Notification notification = this.notificationService.getThisNotification(Integer.parseInt(idStr));
        if (notification != null) {
            if (!this.userManager.isAdmin(userkey)) {
                boolean blocked = true;
                if (notification.getFilterProject()) {
                    String pKey = notification.getTargetProject();
                    if (pKey != null) {
                        pKey = pKey.replaceAll(":", "");
                    }
                    if (notification.getTargetProject().contains(pKey) && this.licenseCounter.currentUserCanEdit(pKey)) {
                        blocked = false;
                    }
                }
                if (blocked) {
                    return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
                }
            }
            WeakHashMap<String, Object> eventDataMap = new WeakHashMap<String, Object>();
            eventDataMap.put("type", EventType.ANNOUNCEMENT_DELETED.toString());
            eventDataMap.put("Operation", EventType.ANNOUNCEMENT_DELETED.toString());
            this.announcerAnalytics.postEventInfo(EventType.ANNOUNCEMENT_DELETED, eventDataMap);
            this.notificationService.deleteNotification(notification);
            if (notification.getCustomRecurrenceOption()) {
                this.logger.debug(String.format("Stopping scheduled job for notification %s", notification.getTitle()));
                this.recurringAnnouncementScheduler.unscheduleJob(notification);
            }
        } else {
            this.logger.debug("This notification does not exist");
            return Response.ok((Object)Response.Status.NOT_FOUND).build();
        }
        return Response.ok((Object)String.format("Deleted notification %s", idStr)).build();
    }
}

